/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.data.Consumable;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ConsumableItem
extends Item
implements ContentItem<Consumable> {
    private Consumable consumable;

    public ConsumableItem(Consumable consumable) {
        super(new Item.Properties().m_41487_(consumable.getMaxStack()).m_41489_(ConsumableItem.build(consumable)));
        this.consumable = consumable;
    }

    private static FoodProperties build(Consumable consumable) {
        FoodProperties.Builder prop = new FoodProperties.Builder();
        prop.m_38760_(consumable.getHealAmount());
        prop.m_38758_(consumable.getSaturation());
        if (consumable.isWolfFood()) {
            prop.m_38757_();
        }
        if (consumable.isAlwaysEdible()) {
            prop.m_38765_();
        }
        return prop.m_38767_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.consumable.getName()));
        for (String s : this.consumable.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        tooltip.add(GenericUtils.format("&9Type: &7" + (this.consumable.isDrinkable() ? "drink/beverage" : "food")));
        tooltip.add(GenericUtils.format("&9Heal Amout: &7" + this.consumable.getHealAmount()));
        tooltip.add(GenericUtils.format("&9Saturation: &7" + this.consumable.getSaturation()));
        if (this.consumable.isWolfFood()) {
            tooltip.add(GenericUtils.format("&9&oLiked by wolves."));
        }
        if (this.consumable.isAlwaysEdible()) {
            tooltip.add(GenericUtils.format("&8&oAlways " + (this.consumable.isDrinkable() ? "drinkable" : "edible") + "."));
        }
        if (this.consumable.getOreDictId() != null) {
            tooltip.add(GenericUtils.format("&9OreDict: &7" + this.consumable.getOreDictId()));
        }
    }

    @Override
    public Consumable getContent() {
        return this.consumable;
    }

    @Override
    public ContentType getType() {
        return ContentType.CONSUMABLE;
    }
}

