/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class JunctionTool
extends Item
implements JunctionGridItem {
    public JunctionTool() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        StackWrapper wrap = UniStack.getStack((Object)stack);
        if (wrap.hasTag() && wrap.directTag().has("fvtm:junction")) {
            tooltip.add((Component)Component.m_237110_((String)"item.fvtm.junction_tool.selected", (Object[])new Object[]{new QV3D(wrap.directTag(), "fvtm:junction")}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.fvtm.junction_tool.none"));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || Config.DISABLE_RAILS) {
            return InteractionResult.PASS;
        }
        WorldW world = WrapperHolder.getWorld((Object)context.m_43725_());
        RailSystem railsys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, world);
        Player player = context.m_43723_();
        EntityW pass = UniEntity.getEntity((Object)player);
        if (railsys == null) {
            pass.bar("item.fvtm.junction_tool.nosys");
            return InteractionResult.FAIL;
        }
        QV3D vector = new QV3D(context.m_43720_().f_82479_, context.m_43720_().f_82480_, context.m_43720_().f_82481_);
        StackWrapper stack = UniStack.getStack((Object)player.m_21120_(context.m_43724_()));
        if (player.m_6047_()) {
            Junction junc = railsys.getJunction(vector.pos);
            if (junc == null) {
                pass.bar("item.fvtm.junction_tool.nojunc");
            } else if (junc.size() > 0) {
                pass.bar("item.fvtm.junction_tool.fulljunc");
            } else {
                railsys.delJunction(vector.pos);
                pass.bar("item.fvtm.junction_tool.remjunc");
            }
            return InteractionResult.SUCCESS;
        }
        Junction junk = railsys.getJunction(vector.pos, true);
        if (junk == null) {
            pass.bar("item.fvtm.junction_tool.nojunc");
            return InteractionResult.SUCCESS;
        }
        if (stack.directTag().has("fvtm:junction")) {
            QV3D cached = new QV3D(stack.directTag(), "fvtm:junction");
            if (cached.equals(vector)) {
                pass.openUI(UIKeys.RAIL_JUNCTION, cached.pos.x, cached.pos.y, cached.pos.z);
                return InteractionResult.SUCCESS;
            }
            if (junk.tracks.size() <= 2) {
                stack.updateTag(tag -> tag.rem("fvtm:junction"));
                pass.bar("item.fvtm.junction_tool.reset");
            }
        }
        if (junk.tracks.size() < 2) {
            pass.openUI(UIKeys.RAIL_JUNCTION, vector.pos.x, vector.pos.y, vector.pos.z);
        } else {
            stack.updateTag(tag -> vector.write((TagCW)tag, "fvtm:junction"));
            pass.bar("item.fvtm.junction_tool.cached");
        }
        return InteractionResult.SUCCESS;
    }
}

