/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.RenderOrder;

public interface Program {
    public String id();

    default public void pre(ModelGroup group, ModelRenderData data) {
    }

    default public void post(ModelGroup group, ModelRenderData data) {
    }

    default public Program parse(String[] args) {
        return this;
    }

    default public Program parse(JsonMap map) {
        return this;
    }

    default public <T extends Program> T register() {
        ModelGroup.PROGRAMS.add(this);
        return (T)this;
    }

    default public void init(ModelGroup list) {
    }

    default public boolean pre() {
        return true;
    }

    default public boolean post() {
        return true;
    }

    default public RenderOrder order() {
        return RenderOrder.NORMAL;
    }

    default public int ticktime() {
        return 0;
    }

    default public void reverse(ModelRenderData data, boolean bool) {
    }

    default public Program pause(ModelRenderData data, boolean pause) {
        return this;
    }

    default public void reset(ModelRenderData data) {
        data.cache.set(this, null);
    }

    public static class FunctionalProgram
    extends ConditionalProgram {
        protected BiPredicate<ModelGroup, ModelRenderData> predicate;

        public FunctionalProgram(BiPredicate<ModelGroup, ModelRenderData> pred) {
            this.predicate = pred;
        }

        @Override
        public boolean test(ModelGroup group, ModelRenderData data) {
            return this.predicate.test(group, data);
        }

        @Override
        public String id() {
            return "functional";
        }
    }

    public static class ConditionalProgram
    implements Program {
        protected ArrayList<Program> programs = new ArrayList();
        protected ArrayList<Program> opposite = new ArrayList();
        protected boolean passed;

        public boolean test(ModelGroup group, ModelRenderData data) {
            return true;
        }

        @Override
        public String id() {
            return "conditional";
        }

        @Override
        public void pre(ModelGroup group, ModelRenderData data) {
            this.passed = this.test(group, data);
            if (this.passed) {
                for (Program prog : this.programs) {
                    prog.pre(group, data);
                }
            } else {
                for (Program prog : this.opposite) {
                    prog.pre(group, data);
                }
            }
        }

        @Override
        public void post(ModelGroup group, ModelRenderData data) {
            if (this.passed) {
                for (Program prog : this.programs) {
                    prog.post(group, data);
                }
            } else {
                for (Program prog : this.opposite) {
                    prog.post(group, data);
                }
            }
        }

        public ConditionalProgram addIf(Program ... progs) {
            for (Program prog : progs) {
                if (prog == null) continue;
                this.programs.add(prog);
            }
            return this;
        }

        public ConditionalProgram addElse(Program ... progs) {
            for (Program prog : progs) {
                if (prog == null) continue;
                this.opposite.add(prog);
            }
            return this;
        }

        public ConditionalProgram transfer(ConditionalProgram other) {
            this.programs.addAll(other.programs);
            this.opposite.addAll(other.opposite);
            other.programs.clear();
            other.opposite.clear();
            return this;
        }

        public ConditionalProgram copy() {
            try {
                return (ConditionalProgram)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class BlankProgram
    implements Program {
        private String id;

        public BlankProgram(String pid) {
            this.id = pid;
        }

        @Override
        public String id() {
            return this.id;
        }
    }
}

