/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.content;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;

public class RailGaugeModel
extends DefaultModel {
    public static final RailGaugeModel EMPTY = new RailGaugeModel();
    public ArrayList<V3D[]> rail_model = new ArrayList();
    public ArrayList<float[]> rail_vv = new ArrayList();
    public ArrayList<Float> rail_u = new ArrayList();
    public boolean rail_tempcull = false;
    public float ties_distance = 0.5f;
    public float signal_offset = 0.25f;

    @Override
    public RailGaugeModel parse(ModelData data) {
        ArrayList rails;
        super.parse(data);
        this.rail_tempcull = data.getBoolean("RailCulling", false);
        this.ties_distance = data.getFloat("TiesDistance", this.ties_distance);
        this.signal_offset = data.getFloat("SignalOffset", this.signal_offset);
        if (data.has("Rail")) {
            rails = data.getArray("Rail").toStringList();
            if (rails.isEmpty()) {
                return this;
            }
            for (String rail : rails) {
                float ih;
                String[] args = rail.trim().split(" ");
                boolean rect = args[0].equals("rect") || args[0].equals("flat");
                float scale = Float.parseFloat(args[1]);
                float sx = Float.parseFloat(args[2]);
                float sy = Float.parseFloat(args[3]);
                float w = Float.parseFloat(args[4]);
                float h = Float.parseFloat(args[5]);
                boolean m = Boolean.parseBoolean(args[6]);
                float io = args.length > 7 ? Float.parseFloat(args[7]) / (float)this.tex_height : 0.0f;
                float iw = args.length > 8 ? Float.parseFloat(args[8]) / (float)this.tex_height : 0.125f / (float)this.tex_height;
                float f = ih = args.length > 9 ? Float.parseFloat(args[9]) / (float)this.tex_height : 0.125f / (float)this.tex_height;
                if (rect) {
                    this.addRailRect(scale, sx, sy, w, h, m, 1.0f, new float[]{io, iw, ih});
                    continue;
                }
                V3D tl = new V3D(args, 7);
                V3D tr = new V3D(args, 10);
                V3D bl = new V3D(args, 13);
                V3D br = new V3D(args, 16);
                this.addRailRectShape(scale, sx, sy, w, h, tl, tr, bl, br, m);
            }
        }
        if (data.has("Rails")) {
            rails = data.getMap("Rails");
            JsonMap map = null;
            for (Map.Entry entry : rails.entries()) {
                float[] vv;
                float[] fArray;
                float[] fArray2;
                map = ((JsonValue)entry.getValue()).asMap();
                float scl = map.getFloat("scale", 1.0f);
                if (map.has("pos")) {
                    fArray2 = map.getArray("pos").toFloatArray();
                } else {
                    float[] fArray3 = new float[2];
                    fArray3[0] = 0.9375f;
                    fArray2 = fArray3;
                    fArray3[1] = 0.0f;
                }
                float[] pos = fArray2;
                if (map.has("size")) {
                    fArray = map.getArray("size").toFloatArray();
                } else {
                    float[] fArray4 = new float[2];
                    fArray4[0] = 0.125f;
                    fArray = fArray4;
                    fArray4[1] = 0.125f;
                }
                float[] siz = fArray;
                if (map.has("v")) {
                    vv = map.getArray("v").toFloatArray();
                    int i = 0;
                    while (i < vv.length) {
                        int n = i++;
                        vv[n] = vv[n] / (float)this.tex_height;
                    }
                } else {
                    vv = new float[]{0.0f, 0.125f * (float)this.tex_height, 0.125f * (float)this.tex_height};
                }
                float u = map.getFloat("u", 16.0f) / (float)this.tex_width;
                boolean mir = map.getBoolean("mirror", true);
                this.addRailRect(scl, pos[0], pos[1], siz[0], siz[1], mir, u, vv);
            }
        }
        return this;
    }

    @Override
    public void render(ModelRenderData data) {
        for (ModelGroup list : this.groups) {
            list.render();
        }
    }

    public void addRailRect(float scale, float start_x, float start_y, float width, float height, boolean mirror, float u, float[] vv) {
        this.rail_model.add(new V3D[]{new V3D((double)start_x, (double)start_y, 0.0).scale((double)scale), new V3D((double)(start_x + width), (double)start_y, 0.0).scale((double)scale)});
        float buff = 0.0f;
        this.rail_vv.add(new float[]{vv[0], vv[0] + (buff += vv[1])});
        this.rail_u.add(Float.valueOf(u));
        if (height > 0.0f) {
            this.rail_model.add(new V3D[]{new V3D((double)start_x, (double)(start_y + height), 0.0).scale((double)scale), new V3D((double)start_x, (double)start_y, 0.0).scale((double)scale)});
            this.rail_vv.add(new float[]{vv[0] + buff, vv[0] + (buff += vv[2])});
            this.rail_model.add(new V3D[]{new V3D((double)(start_x + width), (double)start_y, 0.0).scale((double)scale), new V3D((double)(start_x + width), (double)(start_y + height), 0.0).scale((double)scale)});
            this.rail_vv.add(new float[]{vv[0] + buff, vv[0] + (buff += vv[2])});
            this.rail_model.add(new V3D[]{new V3D((double)(start_x + width), (double)(start_y + height), 0.0).scale((double)scale), new V3D((double)start_x, (double)(start_y + height), 0.0).scale((double)scale)});
            this.rail_vv.add(new float[]{vv[0] + buff, vv[0] + (buff + vv[1])});
            for (int i = 0; i < 3; ++i) {
                this.rail_u.add(Float.valueOf(u));
            }
        } else {
            float h = 0.01f / scale;
            this.rail_model.add(new V3D[]{new V3D((double)(start_x + width), (double)(start_y + h), 0.0).scale((double)scale), new V3D((double)start_x, (double)(start_y + h), 0.0).scale((double)scale)});
            this.rail_vv.add(new float[]{vv[0] + buff, vv[0] + (buff + vv[1])});
            this.rail_u.add(Float.valueOf(u));
        }
        if (mirror) {
            this.addRailRect(scale, -start_x - width, start_y, width, height, false, u, vv);
        }
    }

    public void addRailRectShape(float scale, float start_x, float start_y, float width, float height, V3D tl, V3D tr, V3D bl, V3D br, boolean mirror) {
        if (tl == null) {
            tl = new V3D();
        }
        if (tr == null) {
            tr = new V3D();
        }
        if (bl == null) {
            bl = new V3D();
        }
        if (br == null) {
            br = new V3D();
        }
        this.rail_model.add(new V3D[]{new V3D((double)start_x + bl.x, (double)start_y + tl.y, 0.0).scale((double)scale), new V3D((double)(start_x + width) + br.x, (double)start_y + tr.y, 0.0).scale((double)scale)});
        if (height > 0.0f) {
            this.rail_model.add(new V3D[]{new V3D((double)start_x + tl.x, (double)(start_y - height) + bl.y, 0.0).scale((double)scale), new V3D((double)start_x + bl.x, (double)start_y + tl.y, 0.0).scale((double)scale)});
            this.rail_model.add(new V3D[]{new V3D((double)(start_x + width) + br.x, (double)start_y + tr.y, 0.0).scale((double)scale), new V3D((double)(start_x + width) + tr.x, (double)(start_y - height) + br.y, 0.0).scale((double)scale)});
            this.rail_model.add(new V3D[]{new V3D((double)start_x + tl.x, (double)(start_y - height) + bl.y, 0.0).scale((double)scale), new V3D((double)(start_x + width) + tr.x, (double)(start_y - height) + br.y, 0.0).scale((double)scale)});
        } else {
            float h = 0.01f / scale;
            this.rail_model.add(new V3D[]{new V3D((double)start_x + tl.x, (double)(start_y - h) + bl.y, 0.0).scale((double)scale), new V3D((double)(start_x + width) + tr.x, (double)(start_y - h) + br.y, 0.0).scale((double)scale)});
        }
        if (mirror) {
            this.addRailRectShape(scale, -start_x - width, start_y, width, height, tl, tr, bl, br, false);
        }
    }

    public void renderSignal(Junction junction, EntryDirection dir, boolean state) {
    }

    @Override
    public int getDefTexWidth() {
        return 16;
    }

    @Override
    public int getDefTexHeight() {
        return 16;
    }
}

