/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.sys.condition.Condition;
import net.fexcraft.mod.fvtm.sys.condition.ConditionRegistry;

public class ConditionalPrograms {
    public static void init() {
        ModelGroup.COND_PROGRAMS.put("fvtm:lights", new Lights());
        ModelGroup.COND_PROGRAMS.put("fvtm:front_lights", new FrontLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:back_lights", new BackLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:brake_lights", new BrakeLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:fog_lights", new FogLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:long_lights", new LongLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:reverse_lights", new ReverseLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:lights_rail_forward", new LightsForward());
        ModelGroup.COND_PROGRAMS.put("fvtm:lights_rail_backward", new LightsBackward());
        ModelGroup.COND_PROGRAMS.put("fvtm:turn_signal_left", new TurnSignalLeft());
        ModelGroup.COND_PROGRAMS.put("fvtm:turn_signal_right", new TurnSignalRight());
        ModelGroup.COND_PROGRAMS.put("fvtm:warning_lights", new WarningLights());
        ModelGroup.COND_PROGRAMS.put("fvtm:back_lights_signal_left", new BackLightsSignalLeft());
        ModelGroup.COND_PROGRAMS.put("fvtm:back_lights_signal_right", new BackLightsSignalRight());
        ModelGroup.COND_PROGRAMS.put("fvtm:category_specific", new IDSpecific());
        ModelGroup.COND_PROGRAMS.put("fvtm:category_specific_array", new IDSpecificArray());
        ModelGroup.COND_PROGRAMS.put("fvtm:signal_lights_0", new SignalLights(0));
        ModelGroup.COND_PROGRAMS.put("fvtm:signal_lights_1", new SignalLights(1));
        ModelGroup.COND_PROGRAMS.put("fvtm:signal_lights_2", new SignalLights(2));
        ModelGroup.COND_PROGRAMS.put("fvtm:signal_lights_3", new SignalLights(3));
    }

    public static class Lights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getLightsState();
        }
    }

    public static class FrontLights
    extends Lights {
    }

    public static class BackLights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01 || data.vehent != null && data.vehent.isBraking();
        }
    }

    public static class BrakeLights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehent != null && data.vehent.isBraking();
        }
    }

    public static class FogLights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getFogLightsState();
        }
    }

    public static class LongLights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getLongLightsState();
        }
    }

    public static class ReverseLights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getThrottle() < -0.01;
        }
    }

    public static class LightsForward
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getLightsState() && data.vehicle.getAttribute("forward").asBoolean();
        }
    }

    public static class LightsBackward
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.vehicle.getLightsState() && !data.vehicle.getAttribute("forward").asBoolean();
        }
    }

    public static class TurnSignalLeft
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return DefaultPrograms.SIGNAL_TOGGLE[0] && (data.vehicle.getTurnLightLeft() || data.vehicle.getWarningLights());
        }
    }

    public static class TurnSignalRight
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return DefaultPrograms.SIGNAL_TOGGLE[0] && (data.vehicle.getTurnLightRight() || data.vehicle.getWarningLights());
        }
    }

    public static class WarningLights
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return DefaultPrograms.SIGNAL_TOGGLE[0] && data.vehicle.getWarningLights();
        }
    }

    public static class BackLightsSignalLeft
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            if (data.vehicle.getTurnLightLeft() || data.vehicle.getWarningLights()) {
                return DefaultPrograms.SIGNAL_TOGGLE[0];
            }
            return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01;
        }
    }

    public static class BackLightsSignalRight
    extends Program.ConditionalProgram {
        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            if (data.vehicle.getTurnLightRight() || data.vehicle.getWarningLights()) {
                return DefaultPrograms.SIGNAL_TOGGLE[0];
            }
            return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01;
        }
    }

    public static class IDSpecific
    extends Program.ConditionalProgram {
        private String group;

        public IDSpecific() {
        }

        public IDSpecific(String id) {
            this.group = id;
        }

        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return data.part_category.equals(this.group);
        }

        @Override
        public Program parse(String[] args) {
            return new IDSpecific(args[0]).transfer(this);
        }
    }

    public static class IDSpecificArray
    extends Program.ConditionalProgram {
        private String[] groups;

        public IDSpecificArray() {
        }

        public IDSpecificArray(String ... ids) {
            this.groups = ids;
        }

        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            for (String str : this.groups) {
                if (!str.equals(data.part_category)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return new IDSpecificArray(args).transfer(this);
        }
    }

    public static class SignalLights
    extends Program.ConditionalProgram {
        private int signal;

        public SignalLights(int sig) {
            this.signal = sig;
        }

        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return DefaultPrograms.SIGNAL_TOGGLE[this.signal];
        }

        @Override
        public Program parse(String[] args) {
            return new SignalLights(this.signal).transfer(this);
        }

        @Override
        public Program.ConditionalProgram copy() {
            return new SignalLights(this.signal);
        }
    }

    public static class TailLightsSignalRight
    extends BackLightsSignalRight {
    }

    public static class TailLightsSignalLeft
    extends BackLightsSignalLeft {
    }

    public static class IndicatorLightRight
    extends TurnSignalRight {
    }

    public static class IndicatorLightLeft
    extends TurnSignalLeft {
    }

    public static class RearLights
    extends BackLights {
    }

    public static class ConditionBased
    extends Program.ConditionalProgram {
        protected Condition cond;

        public ConditionBased(String condition) {
            this.cond = ConditionRegistry.parse(condition).link();
        }

        @Override
        public boolean test(ModelGroup list, ModelRenderData data) {
            return this.cond.al.isMet(this.cond, data);
        }
    }
}

