/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import java.util.ArrayList;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.render.UniWireRenderer;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;

public class WirePrograms {
    public static Program ROTATED = new Program(){

        @Override
        public String id() {
            return "fvtm:wire_rotated";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.rotate(UniWireRenderer.ANGLE, 0, 1, 0);
        }

        @Override
        public boolean post() {
            return false;
        }
    };

    public static void init() {
        ModelGroup.PROGRAMS.add(new RotateY(0.0f));
        ModelGroup.PROGRAMS.add(ROTATED);
        ModelGroup.PROGRAMS.add(new DownwardAngled(0.0f));
        ModelGroup.PROGRAMS.add(new SpacedDeco(new JsonMap()));
        ModelGroup.PROGRAMS.add(new WireBreak(0.0f, 0.0f));
    }

    public static class RotateY
    implements Program {
        private float deg;

        public RotateY(float angle) {
            this.deg = angle;
        }

        @Override
        public String id() {
            return "fvtm:wire_rotate_y";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.rotate(this.deg, 0, 1, 0);
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return args.length > 0 ? new RotateY(Float.parseFloat(args[0])) : this;
        }
    }

    public static class DownwardAngled
    implements Program {
        private float length;

        public DownwardAngled(float length) {
            this.length = length;
        }

        @Override
        public String id() {
            return "fvtm:wire_downward_angled";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.rotate(UniWireRenderer.ANGLE_DOWN, 0, 0, 1);
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return new DownwardAngled(args.length > 0 ? Float.parseFloat(args[0]) : 0.0625f);
        }

        public float length() {
            return this.length;
        }
    }

    public static class SpacedDeco
    implements Program {
        protected boolean symmetric;
        protected boolean centered;
        protected float center_spacing = 0.5f;
        protected float ending_spacing = 0.5f;
        protected float between_spacing = 1.0f;
        protected int limit = 0;

        public SpacedDeco(JsonMap map) {
            this.symmetric = map.getBoolean("symmetric", false);
            this.centered = map.getBoolean("centered", false);
            this.center_spacing = map.getFloat("center_spacing", 0.5f);
            this.ending_spacing = map.getFloat("ending_spacing", 0.5f);
            this.between_spacing = map.getFloat("between_spacing", 1.0f);
            this.limit = map.getInteger("limit", 0);
        }

        @Override
        public String id() {
            return "fvtm:wire_spaced_deco";
        }

        @Override
        public boolean pre() {
            return false;
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(JsonMap map) {
            return new SpacedDeco(map);
        }

        @Override
        public Program parse(String[] args) {
            return new SpacedDeco(new JsonMap());
        }

        public ArrayList generate(WireRelay relay, Wire wire, ModelGroup group, String decoid, boolean vecs) {
            ArrayList<Float> list;
            ArrayList<Float> arrayList = list = vecs ? new ArrayList<Float>() : new ArrayList();
            if (this.symmetric) {
                int limit = this.limit * 2;
                float half = wire.length / 2.0f;
                if (this.centered) {
                    for (float pass = half - this.center_spacing; pass > this.ending_spacing && (limit <= 0 || list.size() < limit); pass -= this.between_spacing) {
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, false) : Float.valueOf(pass)));
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, true) : Float.valueOf(pass)));
                    }
                } else {
                    for (float pass = this.ending_spacing; pass < half - this.center_spacing && (limit <= 0 || list.size() < limit); pass += this.between_spacing) {
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, false) : Float.valueOf(pass)));
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, true) : Float.valueOf(pass)));
                    }
                }
            } else {
                for (float pass = this.center_spacing; pass < wire.length - this.ending_spacing && (this.limit <= 0 || list.size() < this.limit); pass += this.between_spacing) {
                    list.add((Float)(vecs ? wire.getVectorPosition(pass, false) : Float.valueOf(pass)));
                }
            }
            return list;
        }
    }

    public static class WireBreak
    implements Program {
        public final float after;
        public final float _for;

        public WireBreak(float af, float fr) {
            this.after = af;
            this._for = fr;
        }

        @Override
        public String id() {
            return "fvtm:wire_break";
        }

        @Override
        public boolean pre() {
            return false;
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return new WireBreak(args.length > 0 ? Float.parseFloat(args[0]) : 0.5f, args.length > 1 ? Float.parseFloat(args[1]) : 1.0f);
        }

        public float minlength() {
            return this.after * 2.0f + this._for * 2.0f;
        }
    }
}

