/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.entity.RailMarker;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.entity.RailMarkerModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer20;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class RailMarkerRenderer
extends EntityRenderer<RailMarker> {
    private IDL texture = IDLManager.getIDLCached((String)"fvtm:textures/entity/railmarker.png");
    public static final RGB CYAN = new RGB(0, 255, 255);

    public RailMarkerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.125f;
    }

    public void render(RailMarker marker, float yaw, float tick, PoseStack pose, MultiBufferSource buffer, int light) {
        pose.m_85836_();
        Renderer20.set(pose, buffer, light);
        FvtmRenderTypes.setCutout(this.texture);
        RailMarkerModel.INST.base.render();
        DefaultModel.RENDERDATA.texture = null;
        FvtmRenderTypes.setGlow(this.texture);
        RailMarkerModel.INST.glow.render();
        FvtmRenderTypes.setGlow(this.texture);
        if (marker.queueid == null) {
            Renderer20.setColor(RGB.BLACK);
            RailMarkerModel.INST.arrow.render();
        } else {
            RailPlacingUtil.NewTrack road = RailPlacingUtil.QUEUE.get(marker.queueid);
            if (road != null) {
                boolean arrow;
                int index = road.indexOf(marker.position);
                boolean bl = arrow = index == road.selected || index == 0 || index == road.points.size() - 1;
                if (arrow) {
                    Renderer20.setColor(index == road.selected ? CYAN : (index == 0 ? RGB.GREEN : RGB.RED));
                    FvtmRenderTypes.setGlow((IDL)this.texture.local());
                    RailMarkerModel.INST.arrow.render();
                    FvtmRenderTypes.setCutout(this.texture);
                }
            }
        }
        Renderer20.resetColor();
        pose.m_85849_();
    }

    public ResourceLocation getTextureLocation(RailMarker entity) {
        return (ResourceLocation)this.texture.local();
    }
}

