/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.PathModelGenerator;
import net.fexcraft.mod.fvtm.render.Renderer20;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.ui.rail.RailJunction;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RailRenderer {
    private static RailSystem sys;
    private static boolean holding;
    private static HashSet<Junction> juncset;

    @SubscribeEvent
    public static void renderRails(RenderLevelStageEvent event) {
        if (Config.DISABLE_RAILS) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)event.getCamera().m_90592_().m_9236_()));
        if (sys == null) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        PoseStack pose = event.getPoseStack();
        Renderer20.set(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
        holding = Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof JunctionGridItem;
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        Renderer20.resetColor();
        FvtmRenderTypes.setCutout(FvtmResources.WHITE_TEXTURE);
        for (SystemRegion reg : sys.getRegions().values()) {
            juncset.clear();
            juncset.addAll(reg.getObjects().values());
            for (Junction junc : juncset) {
                pose.m_85836_();
                pose.m_85837_(junc.getV3D().x, junc.getV3D().y, junc.getV3D().z);
                Renderer20.RENDERER.light(junc.getV3D());
                if (junc.tracks.size() == 0 || holding) {
                    DebugUtils.renderBB(0.25f, DebugUtils.COL_ORG);
                }
                if (junc.tracks.size() > 0 && holding) {
                    pose.m_252880_(0.0f, junc.tracks.get((int)0).gauge.getHeight(), 0.0f);
                    FvtmRenderTypes.setCutout(FvtmResources.WHITE_TEXTURE);
                    Renderer20.setColor(DebugUtils.COL_GRY);
                    DebugUtils.JUNC_CORE.render();
                    for (int i = 0; i < junc.tracks.size(); ++i) {
                        RailRenderer.renderJuncModel(junc, i, DebugUtils.JUNC_LINE);
                    }
                    switch (junc.type) {
                        case STRAIGHT: {
                            if (junc.tracks.size() > 1 && !junc.sigtype0.none()) {
                                RailRenderer.renderJuncSignal(junc, 0, junc.sigstate0 ? RGB.GREEN : RGB.RED);
                            }
                            if (junc.tracks.size() <= 1 || junc.sigtype1.none()) break;
                            RailRenderer.renderJuncSignal(junc, 1, junc.sigstate1 ? RGB.GREEN : RGB.RED);
                            break;
                        }
                        case FORK_2: {
                            RailRenderer.renderJuncModel(junc, junc.switch0 ? 1 : 2, DebugUtils.JUNC_DIR);
                            break;
                        }
                        case FORK_3: {
                            RailRenderer.renderJuncModel(junc, junc.switch0 ? 1 : (junc.switch1 ? 3 : 2), DebugUtils.JUNC_DIR);
                            break;
                        }
                        case DOUBLE: {
                            RailRenderer.renderJuncModel(junc, junc.switch0 ? 1 : 2, DebugUtils.JUNC_DIR);
                            RailRenderer.renderJuncModel(junc, junc.switch1 ? 0 : 3, DebugUtils.JUNC_DIR);
                            break;
                        }
                    }
                }
                pose.m_85849_();
                RailRenderer.renderRails(pose, junc);
            }
        }
        pose.m_85849_();
    }

    private static void renderJuncModel(Junction junc, int idx, Polyhedron hed) {
        V3D pos = junc.tracks.get(idx).getVectorPosition0(junc.tracks.get((int)idx).length * 0.5, false);
        double ang = -Math.atan2(junc.tracks.get((int)idx).vecpath[0].z - pos.z, junc.tracks.get((int)idx).vecpath[0].x - pos.x) - (double)1.5708f;
        Renderer20.pushPose();
        Renderer20.rotateRad((float)ang, Renderer20.AY);
        Renderer20.setColor(RailJunction.TRACK_RGB[idx]);
        hed.render();
        Renderer20.popPose();
    }

    private static void renderJuncSignal(Junction junc, int idx, RGB col) {
        V3D pos = junc.tracks.get(idx).getVectorPosition0(junc.tracks.get((int)idx).length * 0.5, false);
        double ang = -Math.atan2(junc.tracks.get((int)idx).vecpath[0].z - pos.z, junc.tracks.get((int)idx).vecpath[0].x - pos.x) - (double)1.5708f;
        Renderer20.pushPose();
        Renderer20.rotateRad((float)ang, Renderer20.AY);
        Renderer20.setColor(RailJunction.TRACK_RGB[idx]);
        DebugUtils.JUNC_SIG_DIR.render();
        Renderer20.setColor(col);
        DebugUtils.JUNC_SIG_STATE.render();
        Renderer20.popPose();
    }

    private static void renderRails(PoseStack pose, Junction junc) {
        pose.m_85836_();
        Renderer20.resetColor();
        for (int i = 0; i < junc.size(); ++i) {
            if (i > 2) {
                pose.m_85837_(0.0, -0.02, 0.0);
            }
            if (junc.tracks.get(i).isOppositeCopy()) continue;
            pose.m_85836_();
            Track track = junc.tracks.get(i);
            pose.m_85837_(track.vecpath[0].x, track.vecpath[0].y, track.vecpath[0].z);
            RailGaugeModel model = track.gauge.getModel();
            if (track.railmodel == null) {
                PathModelGenerator.generateTrackModel(track, model);
            }
            FvtmRenderTypes.setCutout(track.gauge.getRailTexture());
            track.railmodel.render();
            FvtmRenderTypes.setCutout(track.gauge.getTiesTexture());
            track.restmodel.render();
            pose.m_85849_();
        }
        pose.m_85849_();
    }

    static {
        juncset = new HashSet();
    }
}

