/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.road;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingCache;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.Path;
import net.fexcraft.mod.fvtm.sys.uni.PathType;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.CompatUtil;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class UniRoadTool {
    public static String TAG_KEY = "RoadToolData";
    public static final Object[] NA = new Object[0];
    public static final V3D HCENTER = new V3D(0.5, 0.0, 0.5);

    public static void addTooltip(TagCW rcom, List<String> list, BiFunction<String, Object[], String> translator) {
        list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.toolbox", NA)));
        if (rcom.empty() || !rcom.has(TAG_KEY)) {
            list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.empty", NA)));
        } else {
            TagCW com = rcom.getCompound(TAG_KEY);
            int width = com.getInteger("Width");
            boolean bot = com.getBoolean("Ground");
            boolean top = com.getBoolean("Top");
            boolean lin = com.getBoolean("Lines");
            int rheight = com.getInteger("RHeight");
            int lheight = com.getInteger("LHeight");
            StackWrapper stack = null;
            if (com.has("CustomRoadFill")) {
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.road_fill_custom", new Object[]{width})));
            } else if (com.has("RoadFill")) {
                stack = UniStack.createStack((Object)com.getCompound("RoadFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.road_fill", new Object[]{stack.getName(), stack.count()})));
            }
            if (com.has("CustomSlabFill")) {
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.slab_fill_custom", new Object[]{width})));
            } else if (com.has("SlabFill")) {
                stack = UniStack.createStack((Object)com.getCompound("SlabFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.slab_fill", new Object[]{stack.getName(), stack.count()})));
            }
            if (com.has("BottomFill") && bot) {
                stack = UniStack.createStack((Object)com.getCompound("BottomFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.ground_fill", new Object[]{stack.getName()})));
            }
            if (com.has("SideLeftFill") && lheight > 0) {
                stack = UniStack.createStack((Object)com.getCompound("SideLeftFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.left_fill", new Object[]{stack.getName(), lheight})));
            }
            if (com.has("SideRightFill") && rheight > 0) {
                stack = UniStack.createStack((Object)com.getCompound("SideRightFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.right_fill", new Object[]{stack.getName(), rheight})));
            }
            if (com.has("CustomTopFill") && top) {
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.top_fill_custom", new Object[]{width})));
            } else if (com.has("TopFill") && top) {
                stack = UniStack.createStack((Object)com.getCompound("TopFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.top_fill", new Object[]{stack.getName(), stack.count()})));
            }
            if (com.has("CustomLinesFill") && lin) {
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.lines_fill_custom", new Object[]{width})));
            } else if (com.has("LinesFill") && lin) {
                stack = UniStack.createStack((Object)com.getCompound("LinesFill"));
                list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.lines_fill", new Object[]{stack.getName(), stack.count()})));
            }
            list.add(Formatter.format((String)translator.apply("tooltip.fvtm.road_tool.undo", NA)));
        }
    }

    public static int onUse(EntityW pass, boolean main) {
        if (pass.getWorld().isClient()) {
            return 0;
        }
        if (!pass.isCreative()) {
            pass.send("tooltip.fvtm.road_tool.creative");
            return 1;
        }
        if (pass.isShiftDown() && main) {
            pass.openUI(UIKeys.ROAD_TOOL, V3I.NULL);
            return 2;
        }
        return 3;
    }

    public static boolean placeRoad(EntityW pass, StackWrapper stack, Road _road) {
        int i;
        double off;
        if (_road.length > (double)Config.MAX_ROAD_LENGTH) {
            pass.bar("interact.fvtm.road_tool.too_long");
            return false;
        }
        TagCW com = stack.directTag().getCompound(TAG_KEY);
        int width = com.getInteger("Width");
        boolean bot_on = com.getBoolean("Ground");
        boolean top_on = com.getBoolean("Top");
        boolean lin_on = com.getBoolean("Lines");
        int rheight = com.getInteger("RHeight");
        int lheight = com.getInteger("LHeight");
        StackWrapper top = null;
        StackWrapper bot = null;
        StackWrapper left = null;
        StackWrapper righ = null;
        StackWrapper line_b = null;
        StackWrapper road_b = null;
        StackWrapper slab_b = null;
        ArrayList<QV3D> ground = null;
        ArrayList<QV3D> border_l = null;
        ArrayList<QV3D> border_r = null;
        int top_h = 0;
        int border_hl = 0;
        int border_hr = 0;
        ArrayList<ArrayList<QV3D>> rooffill = null;
        ArrayList<ArrayList<QV3D>> linefill = null;
        ArrayList<ArrayList<QV3D>> roadfill = null;
        ArrayList<ArrayList<QV3D>> slabfill = null;
        boolean flnk = false;
        boolean vani = false;
        if (com.has("RoadFill")) {
            road_b = UniStack.createStack((Object)com.getCompound("RoadFill"));
            flnk = CompatUtil.isValidFurenikus(road_b.getIDL());
            boolean bl = vani = !road_b.getID().equals("fvtm:asphalt") && !road_b.isItemOf(ContentType.BLOCK.item_type);
        }
        if (com.has("SlabFill")) {
            slab_b = UniStack.createStack((Object)com.getCompound("SlabFill"));
        }
        if (bot_on && com.has("BottomFill")) {
            bot = UniStack.createStack((Object)com.getCompound("BottomFill"));
            ground = new ArrayList<QV3D>();
        }
        if (lheight > 0 && com.has("SideLeftFill")) {
            left = UniStack.createStack((Object)com.getCompound("SideLeftFill"));
            border_hl = lheight;
            border_l = new ArrayList<QV3D>();
        }
        if (rheight > 0 && com.has("SideRightFill")) {
            righ = UniStack.createStack((Object)com.getCompound("SideRightFill"));
            border_hr = rheight;
            border_r = new ArrayList<QV3D>();
        }
        if (top_on && com.has("TopFill") && !com.has("CustomTopFill")) {
            top = UniStack.createStack((Object)com.getCompound("TopFill"));
        }
        if (bot_on && com.has("LinesFill") && !com.has("CustomLinesFill")) {
            line_b = UniStack.createStack((Object)com.getCompound("LinesFill"));
        }
        int n = top_h = border_hl > border_hr ? border_hl : border_hr;
        if (top_h == 0) {
            if (lin_on) {
                ++border_hl;
                ++border_hr;
                top_h = 2;
            }
            top_h = 1;
        }
        ArrayList<StackWrapper> roadfill_b = null;
        ArrayList<StackWrapper> slabfill_b = null;
        ArrayList<StackWrapper> rooffill_b = null;
        ArrayList<StackWrapper> linefill_b = null;
        if (com.has("CustomRoadFill")) {
            roadfill = new ArrayList<ArrayList<QV3D>>();
            roadfill_b = new ArrayList<StackWrapper>();
            UniRoadTool.loadFill(roadfill, roadfill_b, width, com.getCompound("CustomRoadFill"));
        }
        if (com.has("CustomSlabFill")) {
            slabfill = new ArrayList<ArrayList<QV3D>>();
            slabfill_b = new ArrayList<StackWrapper>();
            UniRoadTool.loadFill(slabfill, slabfill_b, width, com.getCompound("CustomSlabFill"));
        }
        if (top_on && com.has("CustomTopFill")) {
            rooffill = new ArrayList<ArrayList<QV3D>>();
            rooffill_b = new ArrayList<StackWrapper>();
            UniRoadTool.loadFill(rooffill, rooffill_b, width, com.getCompound("CustomTopFill"));
        }
        if (lin_on && com.has("CustomLinesFill")) {
            linefill = new ArrayList<ArrayList<QV3D>>();
            linefill_b = new ArrayList<StackWrapper>();
            UniRoadTool.loadFill(linefill, linefill_b, width, com.getCompound("CustomLinesFill"));
        }
        V3I pos = new V3I();
        double half = (double)width * 0.5 - 0.5;
        ArrayList<QV3D> road = roadfill == null && road_b != null ? new ArrayList<QV3D>() : null;
        ArrayList<QV3D> roof = rooffill == null && top_on ? new ArrayList<QV3D>() : null;
        ArrayList<QV3D> line = linefill == null && lin_on ? new ArrayList<QV3D>() : null;
        V3D vec = _road.vecpath[0];
        double d = off = roadfill == null ? 0.0 : 0.25;
        for (double passed = 0.001; passed < _road.length; passed += 0.125) {
            V3D last = vec;
            vec = _road.getVectorPosition(passed, false);
            double angle = Math.atan2(last.x - vec.x, last.z - vec.z);
            for (double db = -half; db <= half; db += 0.25) {
                if (road != null) {
                    road.add(UniRoadTool.gen(vec, angle, db, 0.0));
                }
                if (ground != null) {
                    ground.add(UniRoadTool.gen(vec, angle, db + off, -1.0));
                }
                if (line != null) {
                    line.add(UniRoadTool.gen(vec, angle, db, 1.0));
                }
                if (roof == null) continue;
                roof.add(UniRoadTool.gen(vec, angle, db, top_h));
            }
            if (roadfill != null) {
                for (int i2 = 0; i2 < roadfill.size(); ++i2) {
                    roadfill.get(i2).add(UniRoadTool.gen(vec, angle, -half + off + (double)i2, 0.0));
                }
            }
            if (linefill != null) {
                for (int i3 = 0; i3 < linefill.size(); ++i3) {
                    linefill.get(i3).add(UniRoadTool.gen(vec, angle, -half + off + (double)i3, 1.0));
                }
            }
            if (rooffill != null) {
                for (int i4 = 0; i4 < rooffill.size(); ++i4) {
                    rooffill.get(i4).add(UniRoadTool.gen(vec, angle, -half + off + (double)i4, top_h));
                }
            }
            if (border_l != null) {
                border_l.add(UniRoadTool.gen(vec, angle, -half - 1.0 + off, 0.0));
            }
            if (border_r != null) {
                border_r.add(UniRoadTool.gen(vec, angle, half + 1.0 + off, 0.0));
            }
            if (!(passed < 0.1)) continue;
            passed = 0.0;
        }
        WorldW world = pass.getWorld();
        JsonMap map = new JsonMap();
        if (road != null) {
            UniRoadTool.roadFill(world, pass, road, pos, road_b, slab_b, top_h, flnk, vani, map);
        }
        StackWrapper block = null;
        if (roadfill != null) {
            for (i = 0; i < roadfill.size(); ++i) {
                block = roadfill_b.get(i);
                StackWrapper slb = slabfill_b == null || slabfill_b.isEmpty() ? slab_b : slabfill_b.get(i);
                flnk = CompatUtil.isValidFurenikus(block.getIDL());
                vani = !block.getID().equals("fvtm:asphalt") && !block.isItemOf(ContentType.BLOCK.item_type);
                UniRoadTool.roadFill(world, pass, roadfill.get(i), pos, block, slb, top_h, flnk, vani, map);
            }
        }
        if (linefill != null) {
            for (i = 0; i < linefill.size(); ++i) {
                UniRoadTool.basicFill(world, pass, linefill.get(i), pos, linefill_b.get(i), map);
            }
        }
        if (rooffill != null) {
            for (i = 0; i < rooffill.size(); ++i) {
                UniRoadTool.basicFill(world, pass, rooffill.get(i), pos, rooffill_b.get(i), map);
            }
        }
        if (border_l != null) {
            UniRoadTool.borderFill(world, pass, border_l, pos, left, border_hl, map);
        }
        if (border_r != null) {
            UniRoadTool.borderFill(world, pass, border_r, pos, righ, border_hr, map);
        }
        if (ground != null) {
            for (QV3D v : ground) {
                pos.set(v.pos.x, v.pos.y + (v.y > 0 ? 1 : 0), v.pos.z);
                StateWrapper state = world.getStateAt(pos);
                if (((FvtmWorld)world).isFvtmRoad(state) || CompatUtil.isValidFurenikus(state.getIDL())) continue;
                UniRoadTool.insert(map, pos, state);
                world.setBlockState(pos, StateWrapper.from((StackWrapper)bot, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, pos, HCENTER, null, pass, true)));
            }
        }
        if (line != null) {
            for (QV3D v : line) {
                pos.set(v.pos.x, v.pos.y + (v.y > 0 ? 1 : 0), v.pos.z);
                UniRoadTool.insert(map, pos, world.getStateAt(pos));
                world.setBlockState(pos, StateWrapper.from((StackWrapper)line_b, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, pos, HCENTER, null, pass, true)));
            }
        }
        if (roof != null) {
            for (QV3D v : roof) {
                pos.set(v.pos.x, v.pos.y + (v.y > 0 ? 1 : 0), v.pos.z);
                try {
                    UniRoadTool.insert(map, pos, world.getStateAt(pos));
                    world.setBlockState(pos, StateWrapper.from((StackWrapper)top, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, pos, HCENTER, null, pass, true)));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "road top/ceiling creation");
                }
            }
        }
        pass.bar("interact.fvtm.road_tool.complete");
        RoadPlacingCache.addEntry(pass.getUUID(), pass.dimid(), map);
        com.set("LastRoadDim", pass.dimid());
        stack.updateTag(tag -> tag.set(TAG_KEY, com));
        return true;
    }

    private static void insert(JsonMap map, V3I pos, StateWrapper state) {
        if (map.has(pos.asString())) {
            return;
        }
        JsonArray array = new JsonArray();
        array.add(state.getIDL().colon());
        if (EnvInfo.is112()) {
            array.add(state.get12Meta());
        }
        map.add(pos.asString(), (JsonValue)array);
    }

    private static void loadFill(ArrayList<ArrayList<QV3D>> fill, ArrayList<StackWrapper> bill, int width, TagCW com) {
        for (int i = 0; i < width; ++i) {
            fill.add(new ArrayList());
            StackWrapper stack = StackWrapper.EMPTY;
            if (com.has("Block" + i)) {
                stack = UniStack.createStack((Object)com.getCompound("Block" + i));
            }
            bill.add(stack);
        }
    }

    private static void roadFill(WorldW world, EntityW pass, ArrayList<QV3D> road, V3I pos, StackWrapper stack, StackWrapper slab, int th, boolean flnk, boolean vani, JsonMap map) {
        for (QV3D vec : road) {
            StateWrapper sslab;
            byte height = vec.y;
            pos.set(vec.pos.x, vec.pos.y + (vec.y > 0 ? 1 : 0), vec.pos.z);
            StateWrapper state = world.getStateAt(pos);
            StateWrapper block = StateWrapper.from((StackWrapper)stack, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, pos, HCENTER, null, pass, true));
            if (!UniRoadTool.isRoad(world, state, block) || UniRoadTool.isLower(world, state, height)) {
                if (UniRoadTool.isRoad(world, world.getStateAt(pos.add(0, 1, 0)))) {
                    height = 0;
                }
                UniRoadTool.insert(map, pos, state);
                if (vani) {
                    sslab = StateWrapper.from((StackWrapper)(height < 9 && height != 0 ? slab : stack), (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, !FvtmRegistry.is112 ? pos.add(0, 1, 0) : pos, HCENTER, null, pass, true));
                    world.setBlockState(pos, sslab);
                } else {
                    world.setBlockState(pos, ((FvtmWorld)world).getRoadWithHeight(block, CompatUtil.getRoadHeight(height, flnk)));
                }
            }
            if (height < 9 && height != 0 || UniRoadTool.isRoad(world, world.getStateAt(pos.add(0, -1, 0)))) {
                V3I down = pos.add(0, -1, 0);
                UniRoadTool.insert(map, down, world.getStateAt(down));
                if (vani) {
                    sslab = StateWrapper.from((StackWrapper)stack, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, down, HCENTER, null, pass, true));
                    world.setBlockState(down, sslab);
                } else {
                    world.setBlockState(down, ((FvtmWorld)world).getRoadWithHeight(block, CompatUtil.getRoadHeight(0, flnk)));
                }
            }
            int c = th < 4 ? 4 : th;
            for (int i = 1; i < c; ++i) {
                ++pos.y;
                UniRoadTool.insert(map, pos, world.getStateAt(pos));
                world.setBlockState(pos, StateWrapper.DEFAULT);
            }
        }
    }

    private static void basicFill(WorldW world, EntityW pass, ArrayList<QV3D> vecs, V3I pos, StackWrapper stack, JsonMap map) {
        for (QV3D v : vecs) {
            pos.set(v.pos.x, v.pos.y + (v.y > 0 ? 1 : 0), v.pos.z);
            StateWrapper block = StateWrapper.from((StackWrapper)stack, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, pos, HCENTER, null, pass, true));
            StateWrapper state = world.getStateAt(pos);
            if (state.getBlock() == block.getBlock()) continue;
            UniRoadTool.insert(map, pos, state);
            world.setBlockState(pos, block);
        }
    }

    private static void borderFill(WorldW world, EntityW pass, ArrayList<QV3D> vecs, V3I pos, StackWrapper stack, int top, JsonMap map) {
        for (QV3D v : vecs) {
            pos.set(v.pos.x, v.pos.y + (v.y > 0 ? 1 : 0), v.pos.z);
            for (int i = -1; i < top; ++i) {
                V3I vp = pos.add(0, i, 0);
                UniRoadTool.insert(map, vp, world.getStateAt(vp));
                world.setBlockState(vp, StateWrapper.from((StackWrapper)stack, (StateWrapper.PlacingContext)new StateWrapper.PlacingContext(world, pos, HCENTER, null, pass, true)));
            }
        }
    }

    private static boolean isRoad(WorldW world, StateWrapper state, StateWrapper block) {
        return UniRoadTool.isRoad(world, state) && state.getBlock() == block.getBlock();
    }

    private static boolean isRoad(WorldW world, StateWrapper state) {
        return ((FvtmWorld)world).isFvtmRoad(state) || CompatUtil.isValidFurenikus(state.getIDL());
    }

    private static boolean isLower(WorldW world, StateWrapper state, int height) {
        return ((FvtmWorld)world).getRoadHeight(state) < height;
    }

    public static V3D grv(double rad, V3D vec) {
        return new V3D(-Math.cos(rad) * vec.x, vec.y, Math.sin(rad) * vec.x);
    }

    public static V3D grv(double rad, double x, double y) {
        return new V3D(-Math.cos(rad) * x, y, Math.sin(rad) * x);
    }

    public static QV3D gen(V3D vec, double rad, double x, double y) {
        return new QV3D(vec.add(UniRoadTool.grv(rad, x, y)));
    }

    public static class Road
    extends Path {
        public Road(QV3D[] gridvecs) {
            super(gridvecs);
        }

        public Road(QV3D[] gridvecs, QV3D vector) {
            super(gridvecs, vector);
        }

        @Override
        public V3D getVectorPosition(double distance, boolean reverse) {
            return super.getVectorPosition0(distance, reverse);
        }

        @Override
        public PathType getType() {
            return PathType.ROAD;
        }
    }
}

