/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fexcraft.mod.fvtm.block.generated.FvtmProperties;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD_LINES;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD_MARKER4;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD_PATTERN;
import net.fexcraft.mod.fvtm.model.block.BakedQuadData;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class RoadLinesModelLoader
implements IGeometryLoader<UnbakedGeo> {
    public UnbakedGeo read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        return new UnbakedGeo();
    }

    public static class UnbakedGeo
    implements IUnbakedGeometry<UnbakedGeo> {
        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> function, ModelState state, ItemOverrides overrides, ResourceLocation resloc) {
            return new BakedGeo(context, function);
        }
    }

    public static class BakedGeo
    implements BakedModel {
        private TextureAtlasSprite sprite;
        private TextureAtlasSprite particle;

        public BakedGeo(IGeometryBakingContext context, Function<Material, TextureAtlasSprite> function) {
            this.sprite = function.apply(context.getMaterial("texture"));
            this.particle = function.apply(context.getMaterial("particle"));
        }

        public List<BakedQuad> m_213637_(BlockState state, Direction direction, RandomSource random) {
            int hei = state == null ? 0 : (Integer)state.m_61143_((Property)FvtmProperties.PROP_HEIGHT);
            boolean hl = state.m_60734_() instanceof G_ROAD_LINES;
            Object uv = BakedQuadData.uv_full;
            if (hl) {
                int lines = (Integer)state.m_61143_((Property)FvtmProperties.PROP_LINE_TYPE);
                int rot = (Integer)state.m_61143_((Property)FvtmProperties.PROP_LINE_ROT);
                uv = switch (lines) {
                    case 0 -> BakedQuadData.uv_ls2[rot];
                    case 1 -> BakedQuadData.uv_lc2[rot];
                    case 2 -> BakedQuadData.uv_l3[rot];
                    case 3 -> BakedQuadData.uv_lf;
                    default -> uv;
                };
            } else if (state.m_60734_() instanceof G_ROAD_MARKER4) {
                Direction dir = (Direction)state.m_61143_((Property)FvtmProperties.FACING);
                for (int i = 0; i < dir.m_122416_(); ++i) {
                    uv = BakedQuadData.rotateL(uv);
                }
            } else if (state.m_60734_() instanceof G_ROAD_PATTERN) {
                G_ROAD_PATTERN blk = (G_ROAD_PATTERN)state.m_60734_();
                int x = (Integer)state.m_61143_((Property)blk.prop_x);
                int z = (Integer)state.m_61143_((Property)blk.prop_z);
                float us = 16.0f / (float)blk.texx;
                float vs = 16.0f / (float)blk.texz;
                uv = new double[][]{{us * (float)x + us, vs * (float)z}, {us * (float)x, vs * (float)z}, {us * (float)x, vs * (float)z + vs}, {us * (float)x + us, vs * (float)z + vs}};
                Direction dir = (Direction)state.m_61143_((Property)FvtmProperties.FACING);
                uv = BakedQuadData.rotateU(uv);
                for (int i = 0; i < dir.m_122416_(); ++i) {
                    uv = BakedQuadData.rotateL(uv);
                }
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            QuadBakingVertexConsumer.Buffered baker = new QuadBakingVertexConsumer.Buffered();
            baker.setDirection(Direction.UP);
            baker.setSprite(this.sprite);
            this.addVertex(baker, BakedQuadData.quad[0], hei, uv[0][0], uv[0][1]);
            this.addVertex(baker, BakedQuadData.quad[1], hei, uv[1][0], uv[1][1]);
            this.addVertex(baker, BakedQuadData.quad[2], hei, uv[2][0], uv[2][1]);
            this.addVertex(baker, BakedQuadData.quad[3], hei, uv[3][0], uv[3][1]);
            quads.add(baker.getQuad());
            return quads;
        }

        private void addVertex(QuadBakingVertexConsumer.Buffered builder, double[] vec, int hei, double u, double v) {
            builder.m_5483_(vec[0], vec[1] - (double)((float)hei * 0.0625f), vec[2]);
            builder.m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
            builder.m_7421_(this.sprite.m_118367_(u), this.sprite.m_118393_(v));
            builder.m_5752_();
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }
    }
}

