/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fcl.util.EntityUtil;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.root.LoopedSound;
import net.fexcraft.mod.fvtm.impl.AABBI;
import net.fexcraft.mod.fvtm.item.BlockItem;
import net.fexcraft.mod.fvtm.item.ConsumableItem;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.item.SignItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingCache;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.ui.RoadSlot;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.ui.VehicleCatalogImpl;
import net.fexcraft.mod.fvtm.util.BlockTypeImpl;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.EntityWIE;
import net.fexcraft.mod.fvtm.util.LoopSound;
import net.fexcraft.mod.fvtm.util.Resources20;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.ui.UISlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;

public class FVTM20 {
    public static void init0() {
        EntityUtil.IMPL = EntityWIE.class;
        StackWrapper.ITEM_TYPES.put(ContentType.ITYPE, item -> item instanceof ContentItem);
        StackWrapper.ITEM_TYPES.put(ContentType.PART.item_type, item -> item instanceof PartItem);
        StackWrapper.ITEM_TYPES.put(ContentType.MATERIAL.item_type, item -> item instanceof MaterialItem);
        StackWrapper.ITEM_TYPES.put(ContentType.VEHICLE.item_type, item -> item instanceof VehicleItem);
        StackWrapper.ITEM_TYPES.put(ContentType.BLOCK.item_type, item -> item instanceof BlockItem);
        StackWrapper.ITEM_TYPES.put(ContentType.TOOLBOX.item_type, item -> item instanceof ToolboxItem);
        StackWrapper.ITEM_TYPES.put(ContentType.WIRE.item_type, item -> item instanceof WireItem);
        StackWrapper.ITEM_TYPES.put(ContentType.SIGN.item_type, item -> item instanceof SignItem);
        StackWrapper.CONTENT_TYPES.put(ContentType.PART.item_type, stack -> ((PartItem)stack.getItem().direct()).getData((StackWrapper)stack));
        StackWrapper.CONTENT_TYPES.put(ContentType.VEHICLE.item_type, stack -> ((VehicleItem)stack.getItem().direct()).getData((StackWrapper)stack));
        StackWrapper.CONTENT_TYPES.put(ContentType.MATERIAL.item_type, stack -> stack.getItem().direct() instanceof MaterialItem ? ((MaterialItem)stack.getItem().direct()).getContent() : null);
        StackWrapper.CONTENT_TYPES.put(ContentType.CONSUMABLE.item_type, stack -> ((ConsumableItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.BLOCK.item_type, stack -> ((BlockItem)stack.getItem().direct()).getData((StackWrapper)stack));
        StackWrapper.CONTENT_TYPES.put(ContentType.RAILGAUGE.item_type, stack -> ((RailGaugeItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.WIRE.item_type, stack -> ((WireItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.SIGN.item_type, stack -> ((SignItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.TOOLBOX.item_type, stack -> ((ToolboxItem)((Object)((Object)stack.getItem().direct()))).var);
        AABB.SUPPLIER = () -> new AABBI();
        BlockType.BLOCK_IMPL = BlockTypeImpl::get;
        if (EnvInfo.CLIENT) {
            FvtmRegistry.CONFIG.addListener(DefaultPrograms::setupSignalTimer);
            Renderer.RENDERER = new Renderer120();
            GLO.SUPPLIER = () -> new GLObject();
        }
        FvtmResources.INSTANCE = new Resources20();
        LoopedSound.ACTIVATE = sound -> {
            sound.localsound = new LoopSound((LoopedSound)sound);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound.localsound);
        };
        FvtmRegistry.CONFIG.addListener(() -> {});
        UIKeys.VEHICLE_CATALOG_IMPL = VehicleCatalogImpl.class;
        UIKeys.register();
        UISlot.GETTERS.put("fvtm:roadfill", args -> new RoadSlot((Object[])args));
        FvtmResources.INSTANCE.init();
    }

    public static void init1() {
        FvtmResources.INSTANCE.registerFvtmBlocks();
        FvtmResources.INSTANCE.registerFvtmItems();
        FvtmResources.INSTANCE.registerAttributes();
        FvtmResources.INSTANCE.registerFunctions();
        FvtmResources.INSTANCE.registerHandlers();
        FvtmResources.INSTANCE.searchContent();
        FvtmResources.INSTANCE.createContentBlocks();
        FvtmResources.INSTANCE.createContentItems();
        if (EnvInfo.CLIENT) {
            FvtmResources.initModelSystem();
            if (DefaultPrograms.SIGNAL_TIMER[0] == null) {
                DefaultPrograms.setupSignalTimer();
            }
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> genCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fvtm").then(Commands.m_82127_((String)"undo").then(Commands.m_82127_((String)"road").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            Passenger pass = (Passenger)UniEntity.getCasted((Object)player);
            JsonMap map = RoadPlacingCache.getLastEntry(player.m_36316_().getId(), player.m_9236_().m_46472_().m_135782_().toString());
            if (map == null || map.empty()) {
                pass.send("No last road data in item.");
                return 0;
            }
            String dim = map.getString("LastRoadDim", "minecraft:overworld");
            if (!dim.equals(player.m_9236_().m_46472_().m_135782_().toString())) {
                pass.send("Last road was placed in &6DIM" + map.getString("LastRoadDim", "unknown"));
                pass.send("You are currenctly in &6DIM" + String.valueOf(player.m_9236_().m_46472_().m_135782_()));
                return 0;
            }
            map.rem("LastRoadDim");
            pass.send("&oUndo-ing last placed road...");
            for (String str : ((Map)map.value).keySet()) {
                JsonArray array = map.getArray(str);
                V3I vec = V3I.fromString((String)str);
                BlockPos pos = new BlockPos(vec.x, vec.y, vec.z);
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(array.get(0).string_value()));
                player.m_9236_().m_7731_(pos, block.m_49966_(), 3);
            }
            RoadPlacingCache.remLastEntry(player.m_36316_().getId(), player.m_9236_().m_46472_().m_135782_().toString());
            pass.send("&7Last road undone.");
            return 0;
        })))).then(Commands.m_82127_((String)"debug").executes(ctx -> {
            DebugUtils.ACTIVE = !DebugUtils.ACTIVE;
            return 0;
        }))).then(Commands.m_82127_((String)"catalog").executes(ctx -> {
            UniEntity.getEntity((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).openUI(UIKeys.VEHICLE_CATALOG, V3I.NULL);
            return 0;
        }))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            if (EnvInfo.DEV) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Reloading Config..."));
                FvtmRegistry.CONFIG.reload();
            } else {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Runtime reloading only available in dev-mode."));
            }
            return 0;
        }));
    }
}

