/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.Static;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.data.Recipe;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.addon.AddonLocation;
import net.fexcraft.mod.fvtm.data.attribute.AttrBoolean;
import net.fexcraft.mod.fvtm.data.attribute.AttrFloat;
import net.fexcraft.mod.fvtm.data.attribute.AttrInteger;
import net.fexcraft.mod.fvtm.data.attribute.AttrString;
import net.fexcraft.mod.fvtm.data.attribute.AttrTristate;
import net.fexcraft.mod.fvtm.data.attribute.AttrVector;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.part.PartInstallHandler;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.block.BarrelBlockFunction;
import net.fexcraft.mod.fvtm.function.block.BoolBlockFunction;
import net.fexcraft.mod.fvtm.function.block.SeatBlockFunction;
import net.fexcraft.mod.fvtm.function.block.SetStateFunction;
import net.fexcraft.mod.fvtm.function.part.BogieFunction;
import net.fexcraft.mod.fvtm.function.part.ColorFunction;
import net.fexcraft.mod.fvtm.function.part.ConnectorFunction;
import net.fexcraft.mod.fvtm.function.part.ContainerFunction;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.InteractZoneFunction;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.function.part.PartSlotsFunction;
import net.fexcraft.mod.fvtm.function.part.ParticleEmitterFunction;
import net.fexcraft.mod.fvtm.function.part.SeatsFunction;
import net.fexcraft.mod.fvtm.function.part.TireFunction;
import net.fexcraft.mod.fvtm.function.part.TransmissionFunction;
import net.fexcraft.mod.fvtm.function.part.WheelFunction;
import net.fexcraft.mod.fvtm.function.part.WheelPositionsFunction;
import net.fexcraft.mod.fvtm.handler.BogieInstallationHandler;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.handler.TireInstallationHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelLoader;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.model.content.ClothModel;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.model.content.VehicleModel;
import net.fexcraft.mod.fvtm.model.content.WireModel;
import net.fexcraft.mod.fvtm.model.loaders.BEOModelLoader;
import net.fexcraft.mod.fvtm.model.loaders.BlankModelLoader;
import net.fexcraft.mod.fvtm.model.loaders.ClassModelLoader;
import net.fexcraft.mod.fvtm.model.loaders.FMFModelLoader;
import net.fexcraft.mod.fvtm.model.loaders.JTMTModelLoader;
import net.fexcraft.mod.fvtm.model.loaders.ObjModelLoader;
import net.fexcraft.mod.fvtm.model.loaders.SMPTBJavaModelLoader;
import net.fexcraft.mod.fvtm.util.CTab;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.ZipUtils;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public abstract class FvtmResources {
    public static FvtmResources INSTANCE;
    public static File FVTM_CONFIG_DIR;
    public static final IDL NULL_TEXTURE;
    public static final IDL WHITE_TEXTURE;
    private static boolean initialmodelload;

    public void init() {
        FVTM_CONFIG_DIR = new File(FvtmRegistry.CONFIG_DIR, "/fvtm/");
        if (!FVTM_CONFIG_DIR.exists()) {
            FVTM_CONFIG_DIR.mkdirs();
        }
        JsonMap map = new JsonMap();
        map.add("ID", FvtmRegistry.INTERNAL_ADDON_ID.colon());
        map.add("Name", "FVTM Internal Addon");
        JsonMap ctabs = new JsonMap();
        ctabs.add("default", "fvtm:toolbox" + (EnvInfo.is120() ? "_0" : ""));
        map.add("CreativeTabs", (JsonValue)ctabs);
        FvtmRegistry.ADDONS.register(new Addon(null, AddonLocation.INTERNAL).parse(map));
        INSTANCE.searchASMPacks();
        boolean failed = this.searchPacksInResourcePacks();
        if (!EnvInfo.CLIENT || failed) {
            this.searchPacksInFolder(new File(FvtmRegistry.CONFIG_DIR.getParentFile(), "/resourcepacks/"), AddonLocation.RESOURCEPACK, false);
        }
        this.searchPacksInFolder(new File(FVTM_CONFIG_DIR, "packs/"), AddonLocation.CONFIGPACK, true);
        this.searchPacksInFolder(new File(FvtmRegistry.CONFIG_DIR.getParentFile(), "/mods/"), AddonLocation.CONFIGPACK, false);
        for (File file : Config.PACK_FOLDERS) {
            this.searchPacksInFolder(file, AddonLocation.CONFIGPACK, true);
        }
        this.searchPacksInFolder(new File(FVTM_CONFIG_DIR, "packs/"), AddonLocation.CONFIGPACK, true);
        if (EnvInfo.CLIENT) {
            this.loadPackTextures();
        }
    }

    public abstract void searchASMPacks();

    public abstract boolean searchPacksInResourcePacks();

    public void searchPacksInFolder(File folder, AddonLocation loc, boolean create) {
        if (!folder.exists()) {
            if (!create) {
                return;
            }
            folder.mkdir();
        }
        for (File file : folder.listFiles()) {
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                File assets = new File(file, "assets/");
                if (!assets.exists()) continue;
                for (File fl : assets.listFiles()) {
                    JsonMap map;
                    File dec;
                    if (!fl.isDirectory() || !(dec = new File(fl, "addonpack.fvtm")).exists() || FvtmResources.isDuplicateOrInvalidPack(map = JsonHandler.parse((File)dec))) continue;
                    FvtmRegistry.ADDONS.register(new Addon(file, loc).parse(map));
                }
                continue;
            }
            if (!file.getName().endsWith(".zip") && !file.getName().endsWith(".jar")) continue;
            JsonArray array = ZipUtils.getValuesAt(file, "assets", "addonpack.fvtm");
            for (JsonValue value : (List)array.value) {
                JsonMap map;
                if (!value.isMap() || FvtmResources.isDuplicateOrInvalidPack(map = value.asMap())) continue;
                FvtmRegistry.ADDONS.register(new Addon(file, loc).parse(map));
            }
        }
    }

    public static boolean isDuplicateOrInvalidPack(JsonMap map) {
        if (!map.has("RegistryName") && !map.has("ID")) {
            return true;
        }
        IDL id = ContentConfigUtil.getID(map);
        for (Addon addon : FvtmRegistry.ADDONS) {
            if (!addon.getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public abstract void loadPackTextures();

    public void registerAttributes() {
        FvtmRegistry.ATTRIBUTES.put("boolean", AttrBoolean.class);
        FvtmRegistry.ATTRIBUTES.put("bool", AttrBoolean.class);
        FvtmRegistry.ATTRIBUTES.put("bln", AttrBoolean.class);
        FvtmRegistry.ATTRIBUTES.put("float", AttrFloat.class);
        FvtmRegistry.ATTRIBUTES.put("flt", AttrFloat.class);
        FvtmRegistry.ATTRIBUTES.put("integer", AttrInteger.class);
        FvtmRegistry.ATTRIBUTES.put("int", AttrInteger.class);
        FvtmRegistry.ATTRIBUTES.put("tristate", AttrTristate.class);
        FvtmRegistry.ATTRIBUTES.put("tri", AttrTristate.class);
        FvtmRegistry.ATTRIBUTES.put("string", AttrString.class);
        FvtmRegistry.ATTRIBUTES.put("str", AttrString.class);
        FvtmRegistry.ATTRIBUTES.put("vector3", AttrVector.class);
        FvtmRegistry.ATTRIBUTES.put("vector", AttrVector.class);
        FvtmRegistry.ATTRIBUTES.put("vec", AttrVector.class);
    }

    public void registerFunctions() {
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:wheel", WheelFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:wheel_positions", WheelPositionsFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:seats", SeatsFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:engine", EngineFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:inventory", InventoryFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:container", ContainerFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:bogie", BogieFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:part_slots", PartSlotsFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:connector", ConnectorFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:color", ColorFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:tire", TireFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:transmission", TransmissionFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:particle_emitter", ParticleEmitterFunction.class);
        FvtmRegistry.PART_FUNCTIONS.put("fvtm:interact_zone", InteractZoneFunction.class);
        FvtmRegistry.BLOCK_FUNCTIONS.put("fvtm:seat", SeatBlockFunction.class);
        FvtmRegistry.BLOCK_FUNCTIONS.put("fvtm:set_state", SetStateFunction.class);
        FvtmRegistry.BLOCK_FUNCTIONS.put("fvtm:boolean", BoolBlockFunction.class);
        FvtmRegistry.BLOCK_FUNCTIONS.put("fvtm:barrel", BarrelBlockFunction.class);
    }

    public void registerHandlers() {
        PartInstallHandler.HANDLERS.put("default", new DefaultPartInstallHandler());
        PartInstallHandler.HANDLERS.put("wheel", new WheelInstallationHandler());
        PartInstallHandler.HANDLERS.put("bogie", new BogieInstallationHandler());
        PartInstallHandler.HANDLERS.put("tire", new TireInstallationHandler());
    }

    public void searchContent() {
        INSTANCE.searchInPacksFor(ContentType.FUEL);
        INSTANCE.searchInPacksFor(ContentType.MATERIAL);
        INSTANCE.searchInPacksFor(ContentType.CONSUMABLE);
        INSTANCE.searchInPacksFor(ContentType.CLOTH);
        INSTANCE.searchInPacksFor(ContentType.RAILGAUGE);
        INSTANCE.searchInPacksFor(ContentType.WIRE);
        INSTANCE.searchInPacksFor(ContentType.WIREDECO);
        INSTANCE.searchInPacksFor(ContentType.SIGN);
        INSTANCE.searchInPacksFor(ContentType.DECORATION);
        INSTANCE.searchInPacksFor(ContentType.CONTAINER);
        INSTANCE.searchInPacksFor(ContentType.BLOCK);
        INSTANCE.searchInPacksFor(ContentType.MULTIBLOCK);
        INSTANCE.searchInPacksFor(ContentType.PART);
        INSTANCE.searchInPacksFor(ContentType.VEHICLE);
    }

    public void searchInPacksFor(ContentType contype) {
        if (contype == ContentType.ADDON) {
            return;
        }
        for (Addon addon : FvtmRegistry.ADDONS) {
            if (addon.getFile() == null) continue;
            if (addon.getFile().isDirectory()) {
                File folder = new File(addon.getFile(), "assets/" + addon.getID().id() + "/config/" + contype.folder + "/");
                if (!folder.exists()) continue;
                ArrayList<File> files = FvtmResources.findFiles(folder, contype.suffix);
                for (File file : files) {
                    try {
                        Content content;
                        JsonMap map = JsonHandler.parse((File)file);
                        IDL idl = ContentConfigUtil.getID(addon, map);
                        if (idl == null) {
                            map.add("ID", addon.getID().id() + ":" + file.getName().substring(0, file.getName().indexOf(".")).toLowerCase());
                        }
                        if ((content = (Content)contype.impl.newInstance().parse(map)) == null) {
                            idl = ContentConfigUtil.getID(map);
                            FvtmLogger.log((Object)("Errors while loading config file: " + String.valueOf(file) + " for " + idl.colon()));
                            continue;
                        }
                        contype.register(content);
                    }
                    catch (Exception e) {
                        FvtmLogger.log(e, "while loading config file: " + String.valueOf(file));
                    }
                }
                continue;
            }
            String lastentry = null;
            try {
                String path = "assets/" + addon.getID().id() + "/config/" + contype.folder + "/";
                ZipFile zip = new ZipFile(addon.getFile());
                ZipInputStream stream = new ZipInputStream(new FileInputStream(addon.getFile()));
                ZipEntry entry = null;
                while ((entry = stream.getNextEntry()) != null) {
                    lastentry = entry.getName();
                    if (!entry.getName().startsWith(path) || !entry.getName().endsWith(contype.suffix)) continue;
                    try {
                        Content content;
                        JsonMap map = JsonHandler.parse((InputStream)zip.getInputStream(entry));
                        IDL idl = ContentConfigUtil.getID(addon, map);
                        if (idl == null) {
                            map.add("ID", addon.getID().id() + ":" + entry.getName().substring(0, entry.getName().indexOf(".")).toLowerCase());
                        }
                        if ((content = (Content)contype.impl.newInstance().parse(map)) == null) {
                            idl = ContentConfigUtil.getID(map);
                            FvtmLogger.log((Object)("Errors while loading config from zip: " + String.valueOf(addon.getFile()) + " for " + idl.colon()));
                            continue;
                        }
                        contype.register(content);
                    }
                    catch (Exception e) {
                        FvtmLogger.log(e, "config parsing of " + entry.getName());
                    }
                }
            }
            catch (Exception e) {
                FvtmLogger.log(e, "while loading config from zip " + String.valueOf(addon.getFile()) + " / " + lastentry);
            }
        }
    }

    public static ArrayList<File> findFiles(File file, String suffix) {
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                ArrayList<File> search = FvtmResources.findFiles(sub, suffix);
                if (search.isEmpty()) continue;
                result.addAll(search);
            }
        } else if (file.getName().endsWith(suffix)) {
            result.add(file);
        }
        return result;
    }

    public abstract void createContentBlocks();

    public abstract void createContentItems();

    public void registerRecipes() {
        this.registerFvtmRecipes();
        INSTANCE.searchInPacksFor(ContentType.RECIPE);
        for (Recipe recipe : FvtmRegistry.RECIPES) {
            if (!recipe.fcl) continue;
            FclRecipe.register((String)recipe.category, (FclRecipe)new FclRecipe(recipe.output, recipe.fclcomps.toArray(new FclRecipe.Component[0])));
        }
    }

    public abstract void registerFvtmRecipes();

    public abstract ItemWrapper getItemWrapper(String var1);

    public CTab getCreativeTab(WithItem type) {
        String tab = type.getCreativeTab();
        Addon addon = null;
        if (tab.contains(":")) {
            String[] split = tab.split(":");
            addon = FvtmRegistry.getAddon(split[0]);
            if (addon == null) {
                return null;
            }
            return addon.getCreativeTab(split[1]);
        }
        addon = ((Content)((Object)type)).getAddon();
        return addon.getCreativeTab(tab);
    }

    public CTab getCreativeTab(String tabid) {
        String[] split;
        Addon addon;
        if (tabid.contains(":") && (addon = FvtmRegistry.getAddon((split = tabid.split(":"))[0])) != null) {
            return addon.getCreativeTab(split[1]);
        }
        return FvtmRegistry.ADDONS.get(FvtmRegistry.INTERNAL_ADDON_ID).getCreativeTab(tabid);
    }

    public abstract StackWrapper newStack0(ItemWrapper var1);

    public static StackWrapper newStack(IDL id) {
        return INSTANCE.newStack0(FvtmRegistry.getItem(id.colon()));
    }

    public static StackWrapper newStack(ItemWrapper item) {
        return INSTANCE.newStack0(item);
    }

    public void initModelLoaders() {
        FvtmRegistry.MODEL_LOADERS.add(new ClassModelLoader());
        FvtmRegistry.MODEL_LOADERS.add(new BlankModelLoader());
        FvtmRegistry.MODEL_LOADERS.add(new JTMTModelLoader());
        FvtmRegistry.MODEL_LOADERS.add(new FMFModelLoader());
        FvtmRegistry.MODEL_LOADERS.add(new ObjModelLoader());
        FvtmRegistry.MODEL_LOADERS.add(new SMPTBJavaModelLoader());
        FvtmRegistry.MODEL_LOADERS.add(new BEOModelLoader());
    }

    public abstract void initModelPrograms();

    public void initModels() {
        FvtmRegistry.PARTS.forEach(part -> part.loadModel());
        FvtmRegistry.VEHICLES.forEach(vehicle -> vehicle.loadModel());
        FvtmRegistry.BLOCKS.forEach(block -> block.loadModel());
        FvtmRegistry.CLOTHES.forEach(cloth -> cloth.loadModel());
        FvtmRegistry.WIRES.forEach(wire -> wire.loadModel());
        FvtmRegistry.WIREDECOS.forEach(deco -> deco.loadModel());
        FvtmRegistry.CONTAINERS.forEach(con -> con.loadModel());
        FvtmRegistry.RAILGAUGES.forEach(rail -> rail.loadModel());
        FvtmRegistry.DECORATIONS.forEach(deco -> deco.loadModel());
        FvtmRegistry.SIGNS.forEach(sign -> sign.loadModel());
    }

    public void initModelsClear() {
        ObjModelLoader.clearCache();
    }

    public static void initModelSystem() {
        INSTANCE.initModelLoaders();
        INSTANCE.initModelPrograms();
        initialmodelload = true;
        FvtmResources.reloadModels();
        initialmodelload = false;
    }

    public static void reloadModels() {
        if (!initialmodelload) {
            return;
        }
        FvtmRegistry.MODELS.clear();
        INSTANCE.initModels();
        INSTANCE.initModelsClear();
    }

    public static Model getModel(String location, ModelData data, Class<? extends Model> clazz) {
        if (location == null || location.equals("") || location.equals("null")) {
            return FvtmResources.getEmptyModelForClass(clazz);
        }
        boolean bake = location.startsWith("baked|");
        if (bake) {
            location = location.substring(6);
            data.add("Baked", true);
        }
        Model model = null;
        if (FvtmRegistry.MODELS.containsKey(location)) {
            try {
                model = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                model.setGroups(FvtmRegistry.MODELS.get(location).copyWithoutPrograms());
                model.parse(data).lock();
                return model;
            }
            catch (Throwable e) {
                FvtmLogger.log(e, "new model instance of " + String.valueOf(clazz));
                Static.stop();
                return FvtmResources.getEmptyModelForClass(clazz);
            }
        }
        ModelLoader loader = FvtmResources.getModelLoader(location, FilenameUtils.getExtension((String)location));
        if (loader == null) {
            return FvtmResources.getEmptyModelForClass(clazz);
        }
        try {
            Object[] ret = loader.load(location, data, () -> {
                try {
                    return (Model)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    FvtmLogger.log(e, "new model instance of " + String.valueOf(clazz));
                    Static.stop();
                    return null;
                }
            });
            if (ret.length == 0 || ret[0] == null) {
                return FvtmResources.getEmptyModelForClass(clazz);
            }
            model = (Model)ret[0];
            if (ret.length > 1) {
                data = (ModelData)((Object)ret[1]);
            }
            FvtmRegistry.MODELS.put(location, model.getGroups().copyWithoutPrograms());
            data.location = location;
            model.parse(data).lock();
        }
        catch (Throwable e) {
            FvtmLogger.log(e, "model load of " + location);
        }
        return model;
    }

    public static Model getEmptyModelForClass(Class<? extends Model> clazz) {
        if (clazz == VehicleModel.class) {
            return VehicleModel.EMPTY;
        }
        if (clazz == BlockModel.class) {
            return BlockModel.EMPTY;
        }
        if (clazz == RailGaugeModel.class) {
            return RailGaugeModel.EMPTY;
        }
        if (clazz == ClothModel.class) {
            return ClothModel.EMPTY;
        }
        if (clazz == WireModel.class) {
            return WireModel.EMPTY;
        }
        return DefaultModel.EMPTY;
    }

    public static ModelLoader getModelLoader(String name, String extension) {
        for (ModelLoader loader : FvtmRegistry.MODEL_LOADERS) {
            if (!loader.accepts(name, extension)) continue;
            return loader;
        }
        return null;
    }

    public InputStream getAssetInputStream(String loc, boolean log) {
        return this.getAssetInputStream(IDLManager.getIDLCached((String)loc), log);
    }

    public abstract InputStream getAssetInputStream(IDL var1, boolean var2);

    public static Object[] getAssetInputStreamWithFallback(String loc) {
        return FvtmResources.getAssetInputStreamWithFallback(IDLManager.getIDLCached((String)loc));
    }

    public static Object[] getAssetInputStreamWithFallback(IDL loc) {
        Object[] objectArray;
        InputStream stream;
        Closeable[] close;
        block9: {
            close = null;
            stream = INSTANCE.getAssetInputStream(loc, false);
            if (stream != null) {
                return new Object[]{stream};
            }
            try {
                ZipEntry entry;
                Addon addon = FvtmRegistry.getAddon(loc.space());
                if (addon == null || !addon.getLocation().isConfigPack()) break block9;
                if (addon.getFile().isDirectory()) {
                    File file = new File(addon.getFile(), "assets/" + loc.space() + "/" + loc.path());
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                    break block9;
                }
                String filename = "assets/" + loc.space() + "/" + loc.path();
                ZipFile zip = new ZipFile(addon.getFile());
                ZipInputStream zipstream = new ZipInputStream(new FileInputStream(addon.getFile()));
                close = new Closeable[]{zip, zipstream};
                while ((entry = zipstream.getNextEntry()) != null) {
                    int read;
                    if (!entry.getName().equals(filename)) continue;
                    stream = zip.getInputStream(entry);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((read = stream.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                    stream = new ByteArrayInputStream(out.toByteArray());
                    break;
                }
            }
            catch (Throwable e) {
                FvtmLogger.log(e, "asset input steam of " + String.valueOf(loc));
            }
        }
        if (close == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = stream;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = stream;
            objectArray = objectArray3;
            objectArray3[1] = close;
        }
        return objectArray;
    }

    public abstract boolean isModPresent(String var1);

    public abstract IDL getExternalTexture(String var1);

    public static PartFunction getFunction(String key) {
        try {
            return FvtmRegistry.PART_FUNCTIONS.get(key).newInstance();
        }
        catch (Exception e) {
            if (EnvInfo.DEV) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static PartData getPartData(TagCW com) {
        Part part = FvtmRegistry.PARTS.get(com.getString("Part"));
        if (part == null) {
            return null;
        }
        return new PartData(part).read(com);
    }

    public static PartData getPartData(Object com) {
        return FvtmResources.getPartData(TagCW.wrap((Object)com));
    }

    public static VehicleData getVehicleData(TagCW com) {
        Vehicle vehicle = FvtmRegistry.VEHICLES.get(com.getString("Vehicle"));
        if (vehicle == null) {
            return null;
        }
        return new VehicleData(vehicle).read(com);
    }

    public static VehicleData getVehicleData(Object com) {
        return FvtmResources.getVehicleData(TagCW.wrap((Object)com));
    }

    public static DecorationData getDecorationData(TagCW com) {
        Decoration deco = FvtmRegistry.DECORATIONS.get(com.getString("Decoration"));
        if (deco == null && com.has("key")) {
            deco = FvtmRegistry.DECORATIONS.get(com.getString("key"));
        }
        if (deco == null) {
            return null;
        }
        return new DecorationData(deco).read(com);
    }

    public static DecorationData getDecorationData(Object com) {
        return FvtmResources.getDecorationData(TagCW.wrap((Object)com));
    }

    public static SignData getSignData(TagCW com) {
        Sign sign = FvtmRegistry.SIGNS.get(com.getString("Sign"));
        if (sign == null && com.has("key")) {
            sign = FvtmRegistry.SIGNS.get(com.getString("key"));
        }
        if (sign == null) {
            return null;
        }
        return new SignData(sign).read(com);
    }

    public static BlockData getBlockData(TagCW com) {
        Block block = FvtmRegistry.BLOCKS.get(com.getString("Block"));
        if (block == null) {
            return null;
        }
        return new BlockData(block).read(com);
    }

    public static MultiBlockData getMultiBlockData(Object com) {
        return FvtmResources.getMultiBlockData(TagCW.wrap((Object)com));
    }

    public static MultiBlockData getMultiBlockData(TagCW com) {
        MultiBlock block = FvtmRegistry.MULTIBLOCKS.get(com.getString("Block"));
        if (block == null) {
            return null;
        }
        return new MultiBlockData(block).read(com);
    }

    public static BlockData getBlockData(Object com) {
        return FvtmResources.getBlockData(TagCW.wrap((Object)com));
    }

    public static ContainerData getContainerData(Object tag) {
        return FvtmResources.getContainerData(TagCW.wrap((Object)tag));
    }

    public static ContainerData getContainerData(TagCW com) {
        if (!com.has("Container")) {
            return null;
        }
        Container con = FvtmRegistry.CONTAINERS.get(com.getString("Container"));
        if (con == null) {
            return null;
        }
        try {
            return new ContainerData(con).read(com);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract void registerFvtmBlocks();

    public abstract void registerFvtmItems();

    public abstract double getMouseSensitivity();

    public abstract Object getBlockMaterial(String var1, boolean var2);

    public abstract void spawnRoadMarker(WorldW var1, QV3D var2, UUID var3);

    public abstract void spawnRailMarker(WorldW var1, QV3D var2, UUID var3);

    public abstract void linkItemContainer(ItemWrapper var1);

    static {
        NULL_TEXTURE = IDLManager.getIDLNamed((String)"No Texture;fvtm:textures/entity/null.png");
        WHITE_TEXTURE = IDLManager.getIDLNamed((String)"No Texture;fvtm:textures/entity/white.png");
    }
}

