/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FVTM4;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.vehicle.LiftingPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.impl.WorldWIE;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.uni.packet.PacketListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class VehicleLiftEntity
extends BlockEntity
implements PacketListener,
InteractionHandler.InteractRefHolder {
    private InteractionHandler.InteractRef ref = new InteractionHandler.InteractRef(this);
    private VehicleData data;
    public double liftstate;
    private double lowest;
    private double highest;
    private double lslot;
    private double lwheel;
    private boolean onwheels;
    public int rot;

    public VehicleLiftEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FVTM4.LIFT_ENTITY.get(), pPos, pBlockState);
    }

    public VehicleData getVehicleData() {
        return this.data;
    }

    public void m_183515_(CompoundTag com) {
        super.m_183515_(com);
        if (this.data != null) {
            com.m_128365_("VehicleData", (Tag)this.data.write(TagCW.create()).local());
        }
        com.m_128347_("LiftState", this.liftstate);
        com.m_128350_("Rot", (float)this.rot);
    }

    public void m_142466_(CompoundTag com) {
        super.m_142466_(com);
        this.rot = com.m_128451_("Rot");
        if (com.m_128441_("VehicleData")) {
            this.data = FvtmResources.getVehicleData(com.m_128469_("VehicleData"));
            this.data.getRotationPoint("vehicle").getPivot().set_yaw(-((float)BlockType.GENERIC_4ROT.getRotationFor(this.rot)), true);
        }
        this.liftstate = com.m_128459_("LiftState");
        this.updateState();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void updateState() {
        double low;
        if (this.data == null) {
            this.liftstate = 0.0;
            return;
        }
        double ls = this.liftstate;
        this.lwheel = 16.0;
        this.lslot = 16.0;
        this.lowest = 16.0;
        this.highest = -16.0;
        for (LiftingPoint point : ((Vehicle)this.data.getType()).getLiftingPoints().values()) {
            if (this.highest < point.pos.y) {
                this.highest = point.pos.y;
            }
            if (!(this.lowest > point.pos.y)) continue;
            this.lowest = point.pos.y;
        }
        if (((Vehicle)this.data.getType()).getLiftingPoints().isEmpty()) {
            this.lowest = 0.0;
            this.highest = 0.0;
        }
        for (WheelSlot slot : this.data.getWheelSlots().values()) {
            if (!(this.lslot > slot.position.y)) continue;
            this.lslot = slot.position.y;
        }
        if (this.data.getWheelSlots().isEmpty()) {
            this.lslot = 0.0;
        }
        if (this.data.getWheelSlots().size() > 0 && this.data.getWheelPositions().size() > 0) {
            for (V3D vec : this.data.getWheelPositions().values()) {
                if (!(this.lwheel > vec.y)) continue;
                this.lwheel = vec.y;
            }
        } else {
            this.lwheel = this.lslot;
        }
        this.onwheels = this.data.getWheelPositions().size() >= ((Vehicle)this.data.getType()).getVehicleType().minWheels();
        this.liftstate = ls < 1.125 && !this.onwheels ? 1.25 : ls;
        double d = low = this.lslot > this.lowest ? this.lowest : this.lslot;
        if (this.onwheels || this.lwheel < low) {
            low = this.lwheel;
        }
        this.liftstate -= low;
        while (this.liftstate - low > 3.0) {
            this.liftstate -= 0.5;
        }
    }

    public double getState() {
        return this.liftstate + -this.lowest;
    }

    public void setVehicle(ItemStack stack) {
        if (this.data != null) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (ItemStack)this.data.newItemStack().local()));
            this.data = null;
        }
        if (stack.m_41720_() instanceof VehicleItem) {
            this.data = ((VehicleItem)stack.m_41720_()).getData(TagCW.wrap((Object)stack.m_41783_()));
        }
        this.m_6596_();
        this.sendUpdate();
    }

    private void sendUpdate() {
        TagCW com = TagCW.create();
        com.set("pos", this.f_58858_.m_121878_());
        if (this.data != null) {
            com.set("data", this.data.write(TagCW.create()));
        }
        com.set("task", "update");
        FvtmLogger.marker(com);
        Packets.sendToAll(Packet_TagListener.class, "blockentity", com);
    }

    public void handle(TagCW packet, EntityW player) {
        if (this.f_58857_.f_46443_) {
            switch (packet.getString("task")) {
                case "update": {
                    if (packet.has("data")) {
                        this.data = FvtmResources.getVehicleData(packet.getCompound("data"));
                        this.data.getRotationPoint("vehicle").getPivot().set_yaw(-((float)BlockType.GENERIC_4ROT.getRotationFor(this.rot)), true);
                    } else {
                        this.data = null;
                        this.liftstate = 0.0;
                    }
                    this.updateState();
                    return;
                }
            }
        }
    }

    public V3D getVehicleDataPos() {
        return new V3D((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + this.liftstate + 0.3125, (double)this.f_58858_.m_123343_() + 0.5);
    }

    public V3I getV3I() {
        return new V3I(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
    }

    public InteractionHandler.InteractRef iref() {
        return this.ref.set(this.getV3I(), this.f_58858_.m_121878_(), this.getVehicleDataPos());
    }

    public AABB getRenderBoundingBox() {
        return WorldWIE.aabb.m_82338_(this.m_58899_());
    }

    @Override
    public void markChanged() {
        this.m_6596_();
    }
}

