/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.block.FvtmBlockEntity;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.fvtm.util.VecUtil;

public class RelayData {
    public boolean input;
    public boolean output;
    public LinkedHashMap<String, V3D> conns = new LinkedHashMap();
    public HashMap<String, ArrayList<String>> types = new HashMap();
    public HashMap<String, Integer> limits = new HashMap();
    public HashMap<String, Float> sizes = new HashMap();

    public RelayData(JsonMap map) {
        this.input = map.getBoolean("input", true);
        this.output = map.getBoolean("output", true);
        if (!map.has("points")) {
            this.conns.put("default", new V3D(0.0, 0.5, 0.0));
            return;
        }
        JsonMap points = map.getMap("points");
        for (Map.Entry entry : points.entries()) {
            if (((JsonValue)entry.getValue()).isArray()) {
                JsonArray array = ((JsonValue)entry.getValue()).asArray();
                float x = array.get(0).float_value();
                float y = array.get(1).float_value();
                float z = array.get(2).float_value();
                this.conns.put((String)entry.getKey(), new V3D((double)x, (double)y, (double)z));
                this.limits.put((String)entry.getKey(), array.size() > 3 ? array.get(3).integer_value() : 0);
                this.types.put((String)entry.getKey(), array.size() > 4 ? array.get(4).asArray().toStringList() : new ArrayList());
                this.sizes.put((String)entry.getKey(), Float.valueOf(array.size() > 5 ? array.get(5).float_value() * 0.5f : 0.125f));
                continue;
            }
            JsonMap val = ((JsonValue)entry.getValue()).asMap();
            this.conns.put((String)entry.getKey(), ContentConfigUtil.getVector(val.getArray("pos")));
            this.limits.put((String)entry.getKey(), val.getInteger("limit", 0));
            this.types.put((String)entry.getKey(), val.getArray("types").toStringList());
            this.sizes.put((String)entry.getKey(), Float.valueOf(val.getFloat("size", 0.25f) * 0.5f));
        }
    }

    public HashMap<String, V3D> getVectors(FvtmBlockEntity tile) {
        LinkedHashMap<String, V3D> list = new LinkedHashMap<String, V3D>();
        for (Map.Entry<String, V3D> entry : this.conns.entrySet()) {
            list.put(entry.getKey(), RelayData.rotate(entry.getValue(), tile.getV3I(), tile.getMeta(), ((Block)tile.getBlockData().getType()).getBlockType()));
        }
        return list;
    }

    public static V3D rotate(V3D vector, V3I pos, int meta, BlockType type) {
        double rot = type.getRelayRotFor(meta);
        return VecUtil.rotByDeg(rot, vector).add((double)pos.x + 0.5, (double)pos.y, (double)pos.z + 0.5);
    }

    public V3D getVec(String string, V3I pos, int meta, BlockType type) {
        return VecUtil.rotByDeg(type.getRelayRotFor(meta), this.conns.get(string)).add((double)((float)pos.x + 0.5f), (double)pos.y, (double)((float)pos.z + 0.5f));
    }

    public float getSize(String key) {
        Float size = this.sizes.get(key);
        return size == null ? 1.0f : size.floatValue();
    }
}

