/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;

public class StackEntry {
    public StackWrapper stack;
    public int amount = 0;

    public StackEntry(TagCW com) {
        this.stack = UniStack.getStack((Object)com);
        this.amount = com.getInteger("fvtm:stack_amount");
    }

    public int stacksize() {
        int ret = this.amount % this.stack.maxsize();
        return this.amount / this.stack.maxsize() + (ret > 0 ? 1 : 0);
    }

    public boolean overmax() {
        return this.amount > this.stack.maxsize();
    }

    public int max() {
        return this.stack.maxsize();
    }

    public int tillfullstack() {
        return this.stack.maxsize() - this.amount % this.stack.maxsize();
    }

    public StackWrapper genstack(int size) {
        if (this.amount <= 0) {
            return StackWrapper.EMPTY;
        }
        StackWrapper nstack = this.stack.copy();
        nstack.count(this.amount < size ? this.amount : size);
        return nstack;
    }

    public StackWrapper modstack() {
        if (this.amount < this.stack.maxsize()) {
            return StackWrapper.EMPTY;
        }
        int mod = this.amount % this.stack.maxsize();
        if (mod == 0) {
            return StackWrapper.EMPTY;
        }
        return this.genstack(mod);
    }
}

