/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.part;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.fvtm.util.Rot;

public class PartSlot {
    public static final float DEF_RADIUS = 0.25f;
    public final String type;
    public final V3D pos;
    public final float radius;
    public final Rot rotation;
    public final String swivel;

    public PartSlot(String key, JsonValue<?> value) {
        if (value.isArray() && value.asArray().not_empty()) {
            JsonArray array = value.asArray();
            this.pos = ContentConfigUtil.getVector(array);
            this.type = array.size() > 3 ? array.get(3).string_value() : key;
            this.radius = array.size() > 4 ? array.get(4).float_value() : 0.25f;
            this.rotation = array.size() > 5 ? new Rot(array.getArray(5)) : Rot.NULL;
            this.swivel = array.size() > 6 ? array.get(6).string_value() : "vehicle";
        } else if (value.isMap()) {
            JsonMap map = value.asMap();
            this.type = map.getString("type", key);
            this.pos = map.has("pos") ? ContentConfigUtil.getVector(map.getArray("pos")) : V3D.NULL;
            this.radius = map.getFloat("radius", 0.25f);
            this.rotation = map.has("rot") ? new Rot(map.getArray("rot")) : Rot.NULL;
            this.swivel = map.getString("point", "vehicle");
        } else {
            this.type = value.isArray() ? key : value.string_value();
            this.pos = V3D.NULL;
            this.radius = 0.25f;
            this.rotation = Rot.NULL;
            this.swivel = "vehicle";
        }
    }
}

