/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import java.util.UUID;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class RailMarker
extends Entity
implements IEntityAdditionalSpawnData {
    public QV3D position;
    public UUID queueid;

    public RailMarker(EntityType<? extends RailMarker> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("uuid0")) {
            this.queueid = new UUID(tag.m_128454_("uuid0"), tag.m_128454_("uuid1"));
        }
        if (tag.m_128441_("position")) {
            this.position = new QV3D(TagCW.wrap((Object)tag), "position");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.queueid != null) {
            tag.m_128356_("uuid0", this.queueid.getMostSignificantBits());
            tag.m_128356_("uuid1", this.queueid.getLeastSignificantBits());
        }
        if (this.position != null) {
            this.position.write(TagCW.wrap((Object)tag), "position");
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        try {
            if (this.queueid == null) {
                buffer.writeLong(0L);
                buffer.writeLong(0L);
            } else {
                buffer.writeLong(this.queueid.getMostSignificantBits());
                buffer.writeLong(this.queueid.getLeastSignificantBits());
            }
            buffer.writeDouble(this.position.vec.x);
            buffer.writeDouble(this.position.vec.y);
            buffer.writeDouble(this.position.vec.z);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        try {
            long m = buffer.readLong();
            long l = buffer.readLong();
            this.queueid = m == 0L && l == 0L ? null : new UUID(m, l);
            this.position = new QV3D(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_8119_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.queueid == null || !RailPlacingUtil.QUEUE.containsKey(this.queueid)) {
            this.m_6074_();
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        block9: {
            block8: {
                if (this.m_9236_().f_46443_) break block8;
                if (hand != InteractionHand.OFF_HAND) break block9;
            }
            return InteractionResult.PASS;
        }
        UUID current = RailPlacingUtil.CURRENT.get(player.m_36316_().getId());
        if (current == null || this.queueid == null) {
            return InteractionResult.SUCCESS;
        }
        if (this.queueid.equals(current)) {
            RailPlacingUtil.NewTrack track = RailPlacingUtil.QUEUE.get(current);
            if (track == null) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21205_().m_41720_() instanceof RailGaugeItem) {
                track.create(UniEntity.getEntity((Object)player), this.position);
            } else {
                track.select(UniEntity.getEntity((Object)player), this.position);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6469_(DamageSource source, float am) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        if (source.m_7640_() instanceof Player && this.queueid != null && this.queueid.equals(this.queueid)) {
            Player player = (Player)source.m_7640_();
            RailPlacingUtil.NewTrack track = RailPlacingUtil.QUEUE.get(this.queueid);
            if (track != null) {
                track.remove(UniEntity.getEntity((Object)player), this.position);
            }
            this.m_6074_();
        }
        return false;
    }

    public boolean m_5829_() {
        return true;
    }
}

