/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class RailVehicle
extends RootVehicle {
    public Track current;
    public Track last;
    public double passed;
    public RailSystem sys;
    private double frbogiedis;
    private double rrbogiedis;
    private byte remtimer;

    public RailVehicle(EntityType<?> type, Level world) {
        super(type, world);
        this.sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world));
    }

    public RailVehicle assign(RailEntity ent) {
        this.m_6034_(ent.pos.x, ent.pos.y, ent.pos.z);
        ent.vehicle.entity = this.vehicle.entity;
        this.vehicle = ent.vehicle;
        this.vehicle.iref().update();
        ent.alignEntity(true);
        this.initVD(this.vehicle.data);
        return this;
    }

    @Override
    protected void init(TagCW com) {
        super.init(com);
    }

    @Override
    public void writeSpawnData(TagCW com) {
        if (this.vehicle.railent == null) {
            return;
        }
        com.set("fr_bogie", this.vehicle.railent.frbogiedis);
        com.set("rr_bogie", this.vehicle.railent.rrbogiedis);
        com.set("Track", this.vehicle.railent.current.write(null));
        com.set("RID", this.vehicle.railent.uid);
    }

    @Override
    public void readSpawnData(TagCW com) {
        this.current = new Track(null).read(com.getCompound("Track"));
        this.frbogiedis = com.getDouble("fr_bogie");
        this.rrbogiedis = com.getDouble("rr_bogie");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.vehicle.railent != null) {
            compound.m_128356_("RailEntity", this.vehicle.railent.uid);
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.remtimer = (byte)40;
    }

    public V3D moveOnly(double passed) {
        RailEntity.TRO tro = this.getTrack(this.current, passed);
        return tro.track == null ? null : tro.track.getVectorPosition(tro.passed, false);
    }

    private RailEntity.TRO getTrack(Track track, double passed) {
        Track newtrack;
        Junction junc;
        if (track == null) {
            return new RailEntity.TRO(track, passed);
        }
        while (passed > track.length) {
            junc = this.sys.getJunction(track.end.pos);
            if (junc == null) {
                return new RailEntity.TRO(track, track.length);
            }
            newtrack = junc.getNext(null, track.getOppositeId(), false);
            if (newtrack != null) {
                passed -= track.length;
                track = newtrack;
                continue;
            }
            return new RailEntity.TRO(track, track.length);
        }
        while (passed < 0.0) {
            junc = this.sys.getJunction(track.start.pos);
            if (junc == null) {
                return new RailEntity.TRO(track, 0.0);
            }
            newtrack = junc.getNext(null, track.getId(), false);
            if (newtrack != null) {
                passed += newtrack.length;
                track = newtrack.createOppositeCopy();
                continue;
            }
            return new RailEntity.TRO(track, 0.0);
        }
        return new RailEntity.TRO(track, passed);
    }

    @Override
    public void m_8119_() {
        if (this.remtimer > 0) {
            if (this.remtimer == 1) {
                this.m_6074_();
            }
            this.remtimer = (byte)(this.remtimer - 1);
        }
        if (!this.m_9236_().f_46443_ && this.vehicle.railent == null) {
            if (this.remtimer == 0) {
                this.remtimer = (byte)40;
            }
            return;
        }
        super.m_8119_();
    }

    public void updBogieRot() {
        if (this.current == null) {
            return;
        }
        V3D bf0 = this.moveOnly(this.passed + (double)0.1f);
        V3D bf1 = this.moveOnly(this.passed - (double)0.1f);
        V3D br0 = this.moveOnly(this.passed - this.frbogiedis - this.rrbogiedis + (double)0.1f);
        V3D br1 = this.moveOnly(this.passed - this.frbogiedis - this.rrbogiedis - (double)0.1f);
        if (bf0 != null && br0 != null && bf1 != null && br1 != null) {
            float front = (float)(Math.toDegrees(Math.atan2(bf0.z - bf1.z, bf0.x - bf1.x)) - (double)this.vehicle.point.getPivot().deg_yaw());
            float rear = (float)(Math.toDegrees(Math.atan2(br0.z - br1.z, br0.x - br1.x)) - (double)this.vehicle.point.getPivot().deg_yaw());
            this.vehicle.data.getAttribute("bogie_front_angle").set(Float.valueOf(front));
            this.vehicle.data.getAttribute("bogie_rear_angle").set(Float.valueOf(rear));
        }
    }

    @Override
    public void onPacket(EntityW player, TagCW packet) {
        if (!packet.has("sub")) {
            return;
        }
        switch (packet.getString("sub")) {
            case "passed": {
                this.passed = packet.getDouble("passed");
                break;
            }
            case "track": {
                this.current = new Track(null).read(packet);
            }
        }
    }
}

