/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.ColoredVertex;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.PathModelGenerator;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingUtil;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEvents {
    private static Polyhedron LINE = new Polyhedron();
    private static Polygon POLY = new Polygon(new Vertex[]{new ColoredVertex(new Vec3f()), new ColoredVertex(new Vec3f())});
    private static Polyhedron sphere;
    public static Vec3f BLUE;
    public static Vec3f CYAN;
    public static Vec3f ORG;
    public static final IDL JUNCTEX;
    private static RailSystem railsys;
    private static HashSet<Junction> juncset;
    private static RootVehicle vehicle;

    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (!((PlayerModel)event.getRenderer().m_7200_()).f_102810_.m_233562_("fvtm")) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102810_.f_104213_.put("fvtm", new ModelPart(new ArrayList(), new HashMap()){

                public void m_104301_(PoseStack pose, VertexConsumer cons, int i, int j) {
                    this.m_104306_(pose, cons, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
                }

                public void m_104306_(PoseStack pose, VertexConsumer cons, int i, int j, float k, float l, float m, float n) {
                    Renderer120.set(pose, cons, i, j);
                    FvtmRenderTypes.setLines();
                    DebugUtils.SPHERE.render();
                }
            });
        }
    }

    @SubscribeEvent
    public static void renderRoad(RenderLevelStageEvent event) {
        V3D vec1;
        V3D vec0;
        if (RoadPlacingUtil.CL_CURRENT == null || RoadPlacingUtil.CL_CURRENT.points.size() < 2) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        PoseStack pose = event.getPoseStack();
        VertexConsumer cons = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Renderer120.set(pose, cons, 0);
        FvtmRenderTypes.setLines();
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        RoadPlacingUtil.NewRoad nroad = RoadPlacingUtil.CL_CURRENT;
        if (nroad.preview == null) {
            nroad.genpreview();
        }
        Renderer120.setColor(BLUE);
        for (int j = 0; j < nroad.road.vecpath.length - 1; ++j) {
            vec0 = nroad.road.vecpath[j];
            vec1 = nroad.road.vecpath[j + 1];
            ForgeClientEvents.POLY.vertices[0].pos(vec0.x, vec0.y - 0.25, vec0.z);
            ForgeClientEvents.POLY.vertices[1].pos(vec1.x, vec1.y - 0.25, vec1.z);
            LINE.render();
        }
        int size = RoadPlacingUtil.CL_CURRENT.points.size();
        Renderer120.setColor(CYAN);
        for (int i = 1; i < size - 1; ++i) {
            double[] arr = nroad.road.getPosition(nroad.road.length / (double)(size - 1) * (double)i);
            vec1 = RoadPlacingUtil.CL_CURRENT.points.get((int)i).vec;
            ForgeClientEvents.POLY.vertices[0].pos(arr[0], arr[1] - 0.25, arr[2]);
            ForgeClientEvents.POLY.vertices[1].pos(vec1.x, vec1.y - 0.25, vec1.z);
            LINE.render();
        }
        Renderer120.setColor(ORG);
        for (ArrayList<V3D> l : nroad.preview) {
            for (int j = 0; j < l.size() - 1; ++j) {
                vec0 = l.get(j);
                ForgeClientEvents.POLY.vertices[0].pos(vec0.x, vec0.y - (double)0.45f, vec0.z);
                vec1 = l.get(j + 1);
                ForgeClientEvents.POLY.vertices[1].pos(vec1.x, vec1.y - (double)0.45f, vec1.z);
                LINE.render();
            }
        }
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void renderGrid(RenderHighlightEvent event) {
        if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof JunctionGridItem)) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        VertexConsumer cons = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Renderer120.set(pose, cons, 0);
        FvtmRenderTypes.setLines();
        QV3D vec = new QV3D(event.getTarget().m_82450_().f_82479_, event.getTarget().m_82450_().f_82480_, event.getTarget().m_82450_().f_82481_);
        BlockPos pos = BlockPos.m_274446_((Position)event.getTarget().m_82450_());
        Renderer120.setColor(RGB.WHITE);
        double x = event.getCamera().m_90583_().f_82479_;
        double y = event.getCamera().m_90583_().f_82480_;
        double z = event.getCamera().m_90583_().f_82481_;
        double yy = (float)vec.y * 0.0625f;
        pose.m_85836_();
        for (int i = 0; i < 4; ++i) {
            ForgeClientEvents.POLY.vertices[0].pos((double)pos.m_123341_() + ((double)i * 0.25 + 0.125) - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)pos.m_123343_() - z);
            ForgeClientEvents.POLY.vertices[1].pos((double)pos.m_123341_() + ((double)i * 0.25 + 0.125) - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)(pos.m_123343_() + 1) - z);
            LINE.render();
            ForgeClientEvents.POLY.vertices[0].pos((double)pos.m_123341_() - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)pos.m_123343_() + ((double)i * 0.25 + 0.125) - z);
            ForgeClientEvents.POLY.vertices[1].pos((double)(pos.m_123341_() + 1) - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)pos.m_123343_() + ((double)i * 0.25 + 0.125) - z);
            LINE.render();
        }
        double v = vec.x < 0 ? (double)(-vec.x - 16) * -0.0625 : (double)vec.x * 0.0625;
        Renderer120.setColor(CYAN);
        ForgeClientEvents.POLY.vertices[0].pos((double)pos.m_123341_() + v - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)pos.m_123343_() - z);
        ForgeClientEvents.POLY.vertices[1].pos((double)pos.m_123341_() + v - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)(pos.m_123343_() + 1) - z);
        LINE.render();
        v = vec.z < 0 ? (double)(-vec.z - 16) * -0.0625 : (double)vec.z * 0.0625;
        ForgeClientEvents.POLY.vertices[0].pos((double)pos.m_123341_() - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)pos.m_123343_() + v - z);
        ForgeClientEvents.POLY.vertices[1].pos((double)(pos.m_123341_() + 1) - x, (double)pos.m_123342_() + yy + 0.01 - y, (double)pos.m_123343_() + v - z);
        LINE.render();
        FvtmRenderTypes.setCutout(FvtmRegistry.WHITE_TEXTURE);
        Renderer120.setColor(ORG);
        pose.m_85837_(vec.vec.x - x, vec.vec.y - y, vec.vec.z - z);
        sphere.render();
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void renderRail(RenderLevelStageEvent event) {
        V3D vec1;
        V3D vec0;
        if (RailPlacingUtil.CL_CURRENT == null || RailPlacingUtil.CL_CURRENT.points.size() < 2) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        PoseStack pose = event.getPoseStack();
        VertexConsumer cons = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Renderer120.set(pose, cons, 0);
        FvtmRenderTypes.setLines();
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        RailPlacingUtil.NewTrack conn = RailPlacingUtil.CL_CURRENT;
        if (conn.preview == null) {
            conn.genpreview();
        }
        Renderer120.setColor(BLUE);
        for (int j = 0; j < conn.track.vecpath.length - 1; ++j) {
            vec0 = conn.track.vecpath[j];
            vec1 = conn.track.vecpath[j + 1];
            ForgeClientEvents.POLY.vertices[0].pos(vec0.x, vec0.y + (double)0.1f, vec0.z);
            ForgeClientEvents.POLY.vertices[1].pos(vec1.x, vec1.y + (double)0.1f, vec1.z);
            LINE.render();
        }
        int size = RailPlacingUtil.CL_CURRENT.points.size();
        Renderer120.setColor(CYAN);
        for (int i = 1; i < size - 1; ++i) {
            double[] arr = conn.track.getPosition(conn.track.length / (double)(size - 1) * (double)i);
            vec1 = RailPlacingUtil.CL_CURRENT.points.get((int)i).vec;
            ForgeClientEvents.POLY.vertices[0].pos(arr[0], arr[1] - (double)0.05f, arr[2]);
            ForgeClientEvents.POLY.vertices[1].pos(vec1.x, vec1.y - (double)0.05f, vec1.z);
            LINE.render();
        }
        Renderer120.setColor(ORG);
        for (ArrayList<V3D> l : conn.preview) {
            for (int j = 0; j < l.size() - 1; ++j) {
                vec0 = l.get(j);
                ForgeClientEvents.POLY.vertices[0].pos(vec0.x, vec0.y + (double)conn.gauge.getHeight() - 0.01, vec0.z);
                vec1 = l.get(j + 1);
                ForgeClientEvents.POLY.vertices[1].pos(vec1.x, vec1.y + (double)conn.gauge.getHeight() - 0.01, vec1.z);
                LINE.render();
            }
        }
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void renderRail1(RenderLevelStageEvent event) {
        if (Config.DISABLE_RAILS) {
            return;
        }
        railsys = SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)event.getCamera().m_90592_().m_9236_()), RailSystem.class);
        if (railsys == null || railsys.getRegions() == null) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        PoseStack pose = event.getPoseStack();
        FvtmRenderTypes.setCutout(JUNCTEX);
        Renderer120.set(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        for (SystemRegion reg : railsys.getRegions().values()) {
            juncset.clear();
            juncset.addAll(reg.getObjects().values());
            for (Junction junc : juncset) {
                pose.m_85836_();
                pose.m_85837_(junc.getV3D().x, junc.getV3D().y, junc.getV3D().z);
                Renderer120.light = LevelRenderer.m_109541_((BlockAndTintGetter)camera.m_90592_().m_9236_(), (BlockPos)pos.m_122169_(junc.getV3D().x, junc.getV3D().y + 0.1, junc.getV3D().z));
                DebugUtils.JUNC_CORE.render();
                pose.m_85849_();
                ForgeClientEvents.renderRails(pose, junc);
            }
        }
        pose.m_85849_();
    }

    private static void renderRails(PoseStack pose, Junction junc) {
        pose.m_85836_();
        Renderer120.resetColor();
        for (int i = 0; i < junc.size(); ++i) {
            if (i > 2) {
                pose.m_85837_(0.0, -0.02, 0.0);
            }
            if (junc.tracks.get(i).isOppositeCopy()) continue;
            pose.m_85836_();
            Track track = junc.tracks.get(i);
            pose.m_85837_(track.vecpath[0].x, track.vecpath[0].y, track.vecpath[0].z);
            RailGaugeModel model = track.gauge.getModel();
            if (track.railmodel == null) {
                PathModelGenerator.generateTrackModel(track, model);
            }
            FvtmRenderTypes.setCutout(track.gauge.getRailTexture());
            track.railmodel.render();
            FvtmRenderTypes.setCutout(track.gauge.getTiesTexture());
            track.restmodel.render();
            pose.m_85849_();
        }
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void onLevelRender(RenderGuiOverlayEvent event) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof RootVehicle && event.getOverlay().id().m_135815_().equals("hotbar")) {
            vehicle = (RootVehicle)Minecraft.m_91087_().f_91074_.m_20202_();
            event.getGuiGraphics().m_280488_(Minecraft.m_91087_().f_91062_, "Throttle: " + ForgeClientEvents.round(ForgeClientEvents.vehicle.vehicle.throttle), 10, 10, 0xFFFFFF);
            event.getGuiGraphics().m_280488_(Minecraft.m_91087_().f_91062_, "Steering: " + ForgeClientEvents.round(ForgeClientEvents.vehicle.vehicle.steer_yaw), 10, 20, 0xFFFFFF);
            event.getGuiGraphics().m_280488_(Minecraft.m_91087_().f_91062_, "Speed: " + ForgeClientEvents.round(ForgeClientEvents.vehicle.vehicle.speed), 10, 30, 0xFFFFFF);
        }
    }

    private static double round(double var) {
        return (double)((int)(var * 100.0)) / 100.0;
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        SystemManager.onClientTick();
    }

    static {
        ForgeClientEvents.LINE.polygons.add(POLY);
        sphere = new Polyhedron().importMRT(new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32), false, 0.0625f);
        BLUE = new Vec3f(0.0f, 0.0f, 1.0f);
        CYAN = new Vec3f(0.0f, 1.0f, 1.0f);
        ORG = new Vec3f(1.0f, 0.75f, 0.0f);
        JUNCTEX = IDLManager.getIDLCached((String)"minecraft:textures/block/stone.png");
        juncset = new HashSet();
    }
}

