/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.handler;

import java.util.Map;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.event.EventType;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.tag.TagCW;

public class AttrReqHandler {
    public static void processToggleRequest(Passenger pass, TagCW packet) {
        boolean bool = packet.getBoolean("bool");
        Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = pass.getFvtmWorld().getInteractRef(packet);
        String attribute = packet.getString("attr");
        Attribute<?> attr = ref.getKey().getAttribute(attribute);
        AttrReqHandler.toggleAttr(attr, bool, packet, false, null);
        Object syncval = attr.value();
        Packets.sendToAll(Packet_TagListener.class, "attr_toggle", packet);
        if (ref.getValue().isVehicle()) {
            ref.getKey().getEventHolder().run(EventType.ATTRIBUTE_UPDATE, ref.getValue().vehicle(), pass, attr);
        }
        if (!attr.sync) {
            return;
        }
        if (!((Vehicle)ref.getKey().getType()).getVehicleType().isRailVehicle()) {
            if (ref.getValue().vehicle() == null || ref.getValue().vehicle().front != null) {
                return;
            }
            VehicleInstance trailer = ref.getValue().vehicle().rear;
            while (trailer != null) {
                Attribute<?> attr0 = trailer.data.getAttribute(attribute);
                if (attr0 != null) {
                    TagCW compound = packet.copy();
                    AttrReqHandler.toggleAttr(attr0, bool, compound, true, syncval);
                    compound.set("entity", trailer.entity.getId());
                    Packets.sendToAll(Packet_TagListener.class, "attr_toggle", packet);
                }
                trailer = trailer.rear;
            }
        }
    }

    private static void toggleAttr(Attribute<?> attr, boolean bool, TagCW tag, boolean check, Object syncval) {
        if (check && attr.sync) {
            attr.set(syncval);
            return;
        }
        if (attr.valuetype.isTristate()) {
            if (attr.valuetype.isBoolean() || !tag.has("reset")) {
                attr.set(bool);
                tag.set("bool", attr.asBoolean());
            } else {
                attr.set(null);
                tag.set("reset", true);
            }
        } else if (attr.valuetype.isNumber()) {
            attr.set(Float.valueOf(attr.valuetype.isInteger() ? (float)tag.getInteger("value") : tag.getFloat("value")));
        } else {
            FvtmLogger.log((Object)"no code for toggling this attribute type yet");
        }
    }

    public static void processUpdateRequest(Passenger pass, TagCW packet) {
        boolean reset = packet.has("reset") && packet.getBoolean("reset");
        Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = pass.getFvtmWorld().getInteractRef(packet);
        Attribute<?> attr = ref.getKey().getAttribute(packet.getString("attr"));
        if (reset) {
            attr.reset();
        } else {
            attr.set(attr.parse(packet.getString("value")));
        }
        AttrReqHandler.sendAttrToggle(attr, ref.getValue());
        if (ref.getValue().isVehicle()) {
            ref.getKey().getEventHolder().run(EventType.ATTRIBUTE_UPDATE, ref.getValue().vehicle(), pass, attr);
        }
    }

    public static void sendAttrToggle(Attribute<?> attr, InteractionHandler.InteractRef ref) {
        if (attr == null) {
            return;
        }
        TagCW packet = TagCW.create();
        packet.set("attr", attr.id);
        ref.setPacket(packet);
        if (attr.valuetype.isTristate()) {
            if (attr.asTristate() == null) {
                packet.set("value", false);
                packet.set("reset", true);
            } else {
                packet.set("value", attr.asBoolean());
            }
        } else if (attr.valuetype.isFloat()) {
            packet.set("value", attr.asFloat());
        } else if (attr.valuetype.isInteger()) {
            packet.set("value", attr.asInteger());
        } else if (attr.valuetype.isString()) {
            packet.set("value", attr.asString());
        } else {
            packet.set("value", attr.asString());
        }
        Packets.sendToAll(Packet_TagListener.class, "attr_update", packet);
    }

    public static void processToggleResponse(Passenger pass, TagCW packet) {
        boolean bool = packet.getBoolean("bool");
        String attribute = packet.getString("attr");
        Attribute<?> attr = null;
        Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = pass.getFvtmWorld().getInteractRef(packet);
        if (ref == null) {
            FvtmLogger.debug((Object)"Received packet for interact-ref not found on client side!");
        }
        if (!ref.getValue().isVehicle() || packet.has("railid")) {
            // empty if block
        }
        attr = ref.getKey().getAttribute(attribute);
        if (attr.valuetype.isTristate()) {
            if (attr.valuetype.isBoolean() || !packet.has("reset")) {
                attr.set(bool);
            } else {
                attr.set(null);
            }
        } else if (attr.valuetype.isNumber()) {
            attr.set(Float.valueOf(attr.valuetype.isInteger() ? (float)packet.getInteger("value") : packet.getFloat("value")));
        } else {
            FvtmLogger.log((Object)"no code for toggling this attribute type yet");
        }
    }

    public static void processUpdateResponse(Passenger pass, TagCW packet) {
        Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = pass.getFvtmWorld().getInteractRef(packet);
        Attribute<?> attr = ref.getKey().getAttribute(packet.getString("attr"));
        if (attr.valuetype.isTristate()) {
            if (packet.has("reset") && packet.getBoolean("reset")) {
                attr.set(null);
            } else {
                attr.set(packet.getBoolean("value"));
            }
        } else if (attr.valuetype.isFloat()) {
            attr.set(Float.valueOf(packet.getFloat("value")));
        } else if (attr.valuetype.isInteger()) {
            attr.set(packet.getInteger("value"));
        } else if (attr.valuetype.isString()) {
            attr.set(packet.getString("value"));
        } else {
            attr.set(packet.getString("value"));
        }
    }
}

