/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.handler;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.part.PartInstallHandler;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.TireFunction;
import net.fexcraft.mod.fvtm.function.part.WheelFunction;
import net.fexcraft.mod.uni.world.MessageSender;

public class WheelInstallationHandler
extends PartInstallHandler {
    @Override
    public boolean validInstall(MessageSender sender, PartData part, String cat, VehicleData data, boolean swap) {
        if (((Vehicle)data.getType()).getVehicleType().isRailVehicle()) {
            sender.send("handler.install.fvtm.wheel.rail_vehicle");
            return false;
        }
        if (data.getParts().containsKey(cat)) {
            sender.send("handler.install.fvtm.wheel.category_occupied");
            return false;
        }
        if (!data.getWheelSlots().containsKey(cat)) {
            sender.send("handler.install.fvtm.wheel.wheelslot_missing");
            return false;
        }
        WheelData idata = (WheelData)((Part)part.getType()).getInstallHandlerData();
        WheelSlot slot = data.getWheelSlots().get(cat);
        if (slot == null) {
            sender.send("handler.install.fvtm.wheel.wheelslot_null");
            return false;
        }
        if (idata.radius > slot.max_radius) {
            sender.send("handler.install.fvtm.wheel.radius_too_large:" + idata.radius + ":" + slot.max_radius);
            return false;
        }
        if (idata.radius < slot.min_radius(idata.has_tire)) {
            sender.send("handler.install.fvtm.wheel.radius_too_small:" + idata.radius + ":" + slot.min_radius(idata.has_tire));
            return false;
        }
        if (idata.width > slot.max_width) {
            sender.send("handler.install.fvtm.wheel.width_too_wide:" + idata.width + ":" + slot.max_width);
            return false;
        }
        if (idata.width < slot.min_width(idata.has_tire)) {
            sender.send("handler.install.fvtm.wheel.width_too_thin:" + idata.width + ":" + slot.min_width(idata.has_tire));
            return false;
        }
        if (idata.hubsize != slot.hubsize && slot.hubsize != 0.0f) {
            sender.send("handler.install.fvtm.wheel.incompatible_connector");
            return false;
        }
        sender.send("handler.install.fvtm.wheel.check_passed");
        return true;
    }

    @Override
    public boolean processInstall(MessageSender sender, PartData part, String cat, VehicleData data) {
        data.getParts().put(cat, part);
        part.setInstalled(null, data.getWheelSlots().get((Object)cat).position, null);
        PartFunction func = (WheelFunction)part.getFunction("fvtm:wheel");
        if (func != null) {
            ((WheelFunction)func).setWheel(cat, data.getWheelSlots().get(cat));
        }
        if ((func = (TireFunction)part.getFunction("fvtm:tire")) != null) {
            ((TireFunction)func).setWheel(cat, data.getWheelSlots().get(cat));
        }
        WheelData idata = (WheelData)((Part)part.getType()).getInstallHandlerData();
        data.getWheelPositions().put(cat, part.getInstalledPos().add((double)((cat.contains("left") ? -idata.width : idata.width) * 0.5f), (double)(-idata.radius), 0.0));
        sender.send("handler.install.fvtm.wheel.success");
        return true;
    }

    @Override
    public boolean validUninstall(MessageSender sender, PartData part, String is_category, VehicleData from, boolean swap) {
        WheelData idata = (WheelData)((Part)part.getType()).getInstallHandlerData();
        if (idata != null && !idata.removable) {
            sender.send("handler.deinstall.fvtm.wheel.part_not_removable");
            return false;
        }
        if (from.hasPart(is_category + ":tire")) {
            sender.send("handler.deinstall.fvtm.wheel.remove_tire_first");
            return false;
        }
        sender.send("handler.deinstall.fvtm.wheel.check_passed");
        return true;
    }

    @Override
    public boolean processUninstall(MessageSender sender, PartData part, String cat, VehicleData data) {
        part.setInstalled(null, new V3D(0.0, 0.0, 0.0), null);
        data.getParts().remove(cat);
        data.getWheelPositions().remove(cat);
        sender.send("handler.deinstall.fvtm.wheel.success");
        return true;
    }

    @Override
    public List<String> getValidCategories(PartData part, VehicleData vehicle) {
        return new ArrayList<String>(vehicle.getWheelSlots().keySet());
    }

    @Override
    public Object parseData(JsonMap map) {
        return new WheelData(map);
    }

    public static class WheelData {
        private float radius;
        private float width;
        private float hubsize;
        protected boolean removable;
        private boolean has_tire;

        public WheelData(JsonMap map) {
            this.radius = map.getFloat("Radius", 1.0f);
            this.width = map.getFloat("Width", 0.25f);
            this.hubsize = map.getFloat("HubSize", 0.0f);
            this.removable = map.getBoolean("Removable", true);
            this.has_tire = map.getBoolean("Tireless", true);
        }

        public float getRadius() {
            return this.radius;
        }

        public float getWidth() {
            return this.width;
        }

        public boolean hasTire() {
            return this.has_tire;
        }
    }
}

