/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.FVTM4;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.entity.DecorationEntity;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class DecorationItem
extends Item
implements ContentItem.ContentDataItem<Decoration, DecorationData>,
ItemTextureable.TextureableItem<Decoration> {
    private Decoration deco;

    public DecorationItem(Decoration deco) {
        super(new Item.Properties().m_41487_(deco.getMaxStack()));
        this.deco = deco;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.deco.getName()));
        for (String s : this.deco.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        DecorationData data = (DecorationData)this.getDataFromTag(stack.m_41783_());
        if (data != null) {
            tooltip.add(GenericUtils.format("&9Texture: &7" + VehicleItem.getTexTitle(data)));
            if (this.deco.getModel() != null && this.deco.getModel().getCreators().size() > 0) {
                tooltip.add(GenericUtils.format("&9Model by:"));
                for (String str : this.deco.getModel().getCreators()) {
                    tooltip.add(GenericUtils.format("&7- " + str));
                }
            }
        }
        tooltip.add(GenericUtils.format("&9Rightclick on a block to place this decoration."));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        DecorationEntity decoen = (DecorationEntity)((EntityType)FVTM4.DECORATION_ENTITY.get()).m_20615_(context.m_43725_());
        DecorationData data = (DecorationData)this.getDataFromTag(stack.m_41783_());
        if (data != null) {
            decoen.decos.add(data);
        }
        decoen.m_146884_(context.m_43720_());
        context.m_43725_().m_7967_((Entity)decoen);
        if (!context.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Decoration getContent() {
        return this.deco;
    }

    @Override
    public ContentType getType() {
        return ContentType.DECORATION;
    }

    @Override
    public DecorationData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public DecorationData getData(TagCW compound) {
        return new DecorationData(this.deco).read(compound);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
    }
}

