/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SignItem
extends Item
implements ContentItem.ContentDataItem<Sign, SignData>,
ItemTextureable.TextureableItem<Sign> {
    private Sign sign;

    public SignItem(Sign deco) {
        super(new Item.Properties().m_41487_(64));
        this.sign = deco;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.sign.getName()));
        for (String s : this.sign.getDescription()) {
            tooltip.add(GenericUtils.format(s));
        }
        UniStack uni = UniStack.get((Object)stack);
        if (uni == null) {
            return;
        }
        SignData data = this.getData(uni.stack);
        if (data != null) {
            tooltip.add(GenericUtils.format("&9Texture: &7" + VehicleItem.getTexTitle(data)));
            if (this.sign.getModel() != null && this.sign.getModel().getCreators().size() > 0) {
                tooltip.add(GenericUtils.format("&9Model by:"));
                for (String str : this.sign.getModel().getCreators()) {
                    tooltip.add(GenericUtils.format("&7- " + str));
                }
            }
        }
    }

    @Override
    public Sign getContent() {
        return this.sign;
    }

    @Override
    public ContentType getType() {
        return ContentType.SIGN;
    }

    @Override
    public SignData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public SignData getData(TagCW compound) {
        return new SignData(this.sign).read(compound);
    }
}

