/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.tmt.BoxBuilder;
import net.fexcraft.lib.tmt.CylinderBuilder;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.lib.tmt.RotationOrder;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.ModelGroup;

public class FMFParser {
    private static final int E = 0;
    private static final int N = 1;
    private static final int G = 2;
    private static final int T = 3;
    private static final int C = 4;
    private static final int V = 5;
    private static final int A = 6;
    private static final int AE = 7;
    private static final int PE = 0;
    private static final int PB = 1;
    private static final int PC = 2;
    private static final int PO = 3;
    private static final int PP = 1;
    private static final int PR = 2;
    private static final int PF = 3;
    private static final int PT = 4;
    private static final int PN = 5;
    private static final int PL = 6;
    private static final int PM = 7;
    private static final int PDF = 8;
    private static final int PDU = 9;
    private static final int PCU = 10;
    private static final int PRO = 11;
    private static final int PTM = 12;
    private static final int PBS = 16;
    private static final int PBC = 17;
    private static final int PBE = 18;
    private static final int PCRL = 16;
    private static final int PCD = 17;
    private static final int PCSG = 18;
    private static final int PCSL = 19;
    private static final int PCTO = 20;
    private static final int PCTR = 21;
    private static final int PCRT = 22;

    public static HashMap<String, Object> parse(DefaultModel model, InputStream stream) throws IOException {
        int f0 = stream.read();
        int f1 = stream.read();
        int f2 = stream.read();
        int format = stream.read();
        if (f0 != 6 || f1 != 13 || f2 != 6 || format < 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        int r = -1;
        String larray = null;
        block9: while ((r = stream.read()) > -1) {
            switch (r) {
                case 1: {
                    model.name = FMFParser.readString(stream);
                    continue block9;
                }
                case 4: {
                    model.addToCreators(FMFParser.readString(stream));
                    continue block9;
                }
                case 3: {
                    int[] in = FMFParser.readIntegers(stream, 2);
                    model.tex_width = in[0];
                    model.tex_height = in[1];
                    stream.read();
                    continue block9;
                }
                case 2: {
                    ModelGroup group = new ModelGroup(FMFParser.readString(stream));
                    FMFParser.readPolygons(stream, group, model.tex_width, model.tex_height);
                    model.groups.add(group);
                    continue block9;
                }
                case 5: {
                    data.put(FMFParser.readString(stream), FMFParser.readString(stream));
                    continue block9;
                }
                case 6: {
                    larray = FMFParser.readString(stream);
                    if (data.containsKey(larray)) continue block9;
                    data.put(larray, new ArrayList());
                    continue block9;
                }
                case 7: {
                    if (larray == null) continue block9;
                    Object obj = data.get(larray);
                    if (!(obj instanceof List)) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(obj.toString());
                        list.add(FMFParser.readString(stream));
                        data.put(larray, list);
                        continue block9;
                    }
                    ((List)obj).add(FMFParser.readString(stream));
                    continue block9;
                }
            }
        }
        return data;
    }

    private static byte[] read(InputStream stream) throws IOException {
        int i;
        ArrayList<Byte> list = new ArrayList<Byte>();
        while ((i = stream.read()) != 0 && i != -1) {
            list.add((byte)i);
        }
        byte[] arr = new byte[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arr[i2] = (Byte)list.get(i2);
        }
        return arr;
    }

    private static String readString(InputStream stream) throws IOException {
        return new String(FMFParser.read(stream), StandardCharsets.UTF_8);
    }

    private static void readPolygons(InputStream stream, ModelGroup group, int tx, int ty) throws IOException {
        int r = -1;
        int tv = 0;
        ArrayList<TexturedVertex> verts = new ArrayList<TexturedVertex>();
        ArrayList<Vec3f> norms = new ArrayList<Vec3f>();
        ModelRendererTurbo mrt = null;
        BoxBuilder box = null;
        CylinderBuilder cyl = null;
        BoxBuilder cuv = null;
        block33: while ((r = stream.read()) != -1 && r != 0 && r <= 3) {
            int type = r;
            mrt = new ModelRendererTurbo((Object)group, 0, 0, tx, ty);
            if (r == 1) {
                cuv = box = new BoxBuilder(mrt);
            } else if (r == 2) {
                cyl = new CylinderBuilder(mrt);
                cuv = cyl;
            }
            block34: while ((r = stream.read()) != -1) {
                if (r == 0) {
                    if (type == 1) {
                        group.add((Polyhedron<GLObject>)new Polyhedron().importMRT(box.build(), false, 0.0625f));
                        continue block33;
                    }
                    if (type == 2) {
                        group.add((Polyhedron<GLObject>)new Polyhedron().importMRT(cyl.build(), false, 0.0625f));
                        continue block33;
                    }
                    if (type != 3) continue block33;
                    group.add((Polyhedron<GLObject>)new Polyhedron().importMRT(mrt, false, 0.0625f));
                    continue block33;
                }
                switch (r) {
                    case 1: {
                        float[] fl = FMFParser.readFloats(stream, 3);
                        mrt.setRotationPoint(fl[0], fl[1], fl[2]);
                        continue block34;
                    }
                    case 2: {
                        float[] fl = FMFParser.readFloats(stream, 3);
                        mrt.setRotationAngle(fl[0], fl[1], fl[2]);
                        continue block34;
                    }
                    case 4: {
                        if (type == 3) {
                            float[] fl = FMFParser.readFloats(stream, 2);
                            TexturedVertex vert = ((TexturedVertex)verts.get(tv)).setTexturePosition(fl[0], fl[1]);
                            verts.set(tv++, vert);
                            continue block34;
                        }
                        int[] in = FMFParser.readIntegers(stream, 2);
                        mrt.setTextureOffset(in[0], in[1]);
                        continue block34;
                    }
                    case 6: {
                        mrt.setColor(new RGB(FMFParser.readIntegers(stream, 1)[0]));
                        continue block34;
                    }
                    case 8: {
                        if (type == 3) {
                            TexturedPolygon poly = new TexturedPolygon(verts.toArray(new TexturedVertex[0]));
                            if (norms.size() > 0) {
                                poly.getNormalVerts().addAll(norms);
                            }
                            mrt.copyTo(new TexturedPolygon[]{poly});
                            verts.clear();
                            norms.clear();
                            tv = 0;
                            continue block34;
                        }
                        boolean[] arr = new boolean[]{stream.read() > 0, stream.read() > 0, stream.read() > 0, stream.read() > 0, stream.read() > 0, stream.read() > 0};
                        cuv.removePolygons(arr);
                        continue block34;
                    }
                    case 9: {
                        boolean[] arr = new boolean[]{stream.read() > 0, stream.read() > 0, stream.read() > 0, stream.read() > 0, stream.read() > 0, stream.read() > 0};
                        cuv.setDetachedUV(arr);
                        continue block34;
                    }
                    case 10: {
                        int in = stream.read();
                        cuv.setPolygonUV(in, FMFParser.readFloats(stream, stream.read()));
                        continue block34;
                    }
                    case 7: {
                        mrt.boxName = FMFParser.readString(stream);
                        continue block34;
                    }
                    case 11: {
                        int[] ro = new int[]{stream.read(), stream.read(), stream.read()};
                        mrt.setRotationOrder(FMFParser.getRotationOrder(ro));
                        continue block34;
                    }
                    case 12: {
                        mrt.texName = FMFParser.readString(stream);
                        continue block34;
                    }
                }
                if (type == 1) {
                    switch (r) {
                        case 3: {
                            float[] fl = FMFParser.readFloats(stream, 3);
                            box.setOffset(fl[0], fl[1], fl[2]);
                            continue block34;
                        }
                        case 16: {
                            float[] fl = FMFParser.readFloats(stream, 3);
                            box.setSize(fl[0], fl[1], fl[2]);
                            continue block34;
                        }
                        case 17: {
                            int in = stream.read();
                            float[] fl = FMFParser.readFloats(stream, 3);
                            box.setCorner(in, fl[0], fl[1], fl[2]);
                            continue block34;
                        }
                        case 18: {
                            box.setExpansion(FMFParser.readFloats(stream, 1)[0]);
                            continue block34;
                        }
                    }
                    continue;
                }
                if (type == 2) {
                    switch (r) {
                        case 3: {
                            float[] fl = FMFParser.readFloats(stream, 3);
                            cyl.setPosition(fl[0], fl[1], fl[2]);
                            continue block34;
                        }
                        case 16: {
                            float[] fl = FMFParser.readFloats(stream, 3);
                            cyl.setRadius(fl[0], fl[1]);
                            cyl.setLength(fl[2]);
                            continue block34;
                        }
                        case 17: {
                            cyl.setDirection(FMFParser.readIntegers(stream, 1)[0]);
                            continue block34;
                        }
                        case 18: {
                            int[] in = FMFParser.readIntegers(stream, 2);
                            cyl.setSegments(in[0], in[1]);
                            continue block34;
                        }
                        case 19: {
                            float[] fl = FMFParser.readFloats(stream, 2);
                            cyl.setScale(fl[0], fl[1]);
                            continue block34;
                        }
                        case 20: {
                            float[] fl = FMFParser.readFloats(stream, 3);
                            cyl.setTopOffset(fl[0], fl[1], fl[2]);
                            continue block34;
                        }
                        case 21: {
                            float[] fl = FMFParser.readFloats(stream, 3);
                            cyl.setTopRotation(fl[0], fl[1], fl[2]);
                            continue block34;
                        }
                        case 22: {
                            float[] fl = FMFParser.readFloats(stream, 2);
                            cyl.setRadialTexture(fl[0], fl[1]);
                            continue block34;
                        }
                        case 23: {
                            cyl.setSegmentOffset(FMFParser.readFloats(stream, 1)[0]);
                            continue block34;
                        }
                    }
                    continue;
                }
                if (type != 3) continue;
                switch (r) {
                    case 3: {
                        float[] fl = FMFParser.readFloats(stream, 3);
                        verts.add(new TexturedVertex(fl[0], fl[1], fl[2], 0.0f, 0.0f));
                        break;
                    }
                    case 5: {
                        float[] fl = FMFParser.readFloats(stream, 3);
                        norms.add(new Vec3f(fl[0], fl[1], fl[2]));
                        break;
                    }
                }
            }
        }
    }

    private static float[] readFloats(InputStream stream, int t) throws IOException {
        float[] arr = new float[t];
        for (int i = 0; i < t; ++i) {
            byte[] bit = new byte[4];
            int r = stream.read(bit);
            if (r < 0) {
                return arr;
            }
            arr[i] = ByteBuffer.wrap(bit).getFloat();
        }
        return arr;
    }

    private static int[] readIntegers(InputStream stream, int t) throws IOException {
        int[] arr = new int[t];
        for (int i = 0; i < t; ++i) {
            byte[] bit = new byte[4];
            int r = stream.read(bit);
            if (r < 0) {
                return arr;
            }
            arr[i] = ByteBuffer.wrap(bit).getInt();
        }
        return arr;
    }

    private static RotationOrder getRotationOrder(int[] ro) {
        if (ro[0] == 0 && ro[1] == 1 && ro[2] == 2) {
            return RotationOrder.XYZ;
        }
        if (ro[0] == 0 && ro[1] == 2 && ro[2] == 1) {
            return RotationOrder.XZY;
        }
        if (ro[0] == 1 && ro[1] == 0 && ro[2] == 2) {
            return RotationOrder.YXZ;
        }
        if (ro[0] == 1 && ro[1] == 2 && ro[2] == 0) {
            return RotationOrder.YZX;
        }
        if (ro[0] == 2 && ro[1] == 0 && ro[2] == 1) {
            return RotationOrder.ZXY;
        }
        if (ro[0] == 2 && ro[1] == 1 && ro[2] == 0) {
            return RotationOrder.ZYX;
        }
        return RotationOrder.YZX;
    }
}

