/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.lib.common.Static;
import net.fexcraft.mod.fvtm.block.generated.BaseBlockEntity;
import net.fexcraft.mod.fvtm.block.generated.FvtmProperties;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public class BaseBlockRenderer
implements BlockEntityRenderer<BaseBlockEntity> {
    private BlockData data;
    private double rot;

    public void render(BaseBlockEntity tile, float ticks, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        this.data = tile.getBlockData();
        if (this.data == null) {
            return;
        }
        Renderer120.pose = pose;
        Renderer120.set(pose, buffer, light, overlay);
        FvtmRenderTypes.setCutout(this.data.getCurrentTexture());
        pose.m_85836_();
        pose.m_85837_(0.5, 0.0, 0.5);
        this.rot = this.getRot(tile.m_58900_());
        if (this.rot != 0.0) {
            pose.m_252781_(new Quaternionf().rotateAxis((float)Static.toRadians((double)this.rot), (Vector3fc)Renderer120.AY));
        }
        ((Block)this.data.getType()).getModel().render(DefaultModel.RENDERDATA.set(this.data, tile, null));
        pose.m_85849_();
    }

    private double getRot(BlockState state) {
        if (this.data.getBlockType().rotations == 4 || this.data.getBlockType().rotations == 44) {
            switch (((Direction)state.m_61143_((Property)FvtmProperties.FACING)).ordinal()) {
                case 2: {
                    return 90.0;
                }
                case 3: {
                    return -90.0;
                }
                case 4: {
                    return 180.0;
                }
                case 5: {
                    return 0.0;
                }
            }
        } else {
            if (this.data.getBlockType().rotations == 8) {
                return (Integer)state.m_61143_((Property)FvtmProperties.PROP_ROT8) * -45 + 90;
            }
            if (this.data.getBlockType().rotations == 16) {
                return (double)((Integer)state.m_61143_((Property)FvtmProperties.PROP_ROT16)).intValue() * -22.5 + 90.0;
            }
        }
        return 0.0;
    }

    public int m_142163_() {
        return 128;
    }
}

