/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FVTM4;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartSlot;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.MathUtils;
import net.fexcraft.mod.fvtm.util.PartItemApp;
import net.fexcraft.mod.fvtm.util.Rot;
import net.fexcraft.mod.uni.inv.UniStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public class RVRenderer
extends EntityRenderer<RootVehicle> {
    private SeparateRenderCache.SepVehCache sepcache;

    public RVRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.25f;
    }

    public void render(RootVehicle veh, float yaw, float tick, PoseStack pose, MultiBufferSource buffer, int light) {
        V3D vp;
        if (veh.vehicle == null || veh.vehicle.data == null) {
            return;
        }
        if (veh.vehicle.cache == null) {
            veh.vehicle.cache = FVTM4.getRenderCache(veh);
        }
        this.sepcache = veh.vehicle.cache.get(SeparateRenderCache.SEP_VEH_CACHE, data -> new SeparateRenderCache.SepVehCache());
        pose.m_85836_();
        V3D rot = this.getRotations(veh, tick);
        pose.m_252781_(new Quaternionf().rotateAxis((float)Static.toRadians((double)(-rot.x)), (Vector3fc)Renderer120.AY).rotateAxis((float)Static.toRadians((double)rot.y), (Vector3fc)Renderer120.AX).rotateAxis((float)Static.toRadians((double)rot.z), (Vector3fc)Renderer120.AZ));
        this.sepcache.set(veh.m_20182_().f_82479_, veh.m_20182_().f_82480_, veh.m_20182_().f_82481_, rot);
        Renderer120.set(pose, buffer, light);
        pose.m_85836_();
        Model vehmod = ((Vehicle)veh.vehicle.data.getType()).getModel();
        FvtmRenderTypes.setCutout(veh.vehicle.data.getCurrentTexture());
        if (vehmod != null) {
            pose.m_85836_();
            vehmod.render(DefaultModel.RENDERDATA.set(veh.vehicle.data, veh.vehicle, tick).rc(veh.vehicle.cache));
            pose.m_85849_();
        } else {
            FvtmLogger.LOGGER.info("NO MODEL " + veh.m_19879_() + " " + String.valueOf(((Vehicle)veh.vehicle.data.getType()).getID()));
        }
        if (veh.vehicle.data.getParts().size() > 0) {
            RVRenderer.renderPoint(pose, veh.vehicle.point, veh, veh.vehicle.data, veh.vehicle.cache, tick);
        }
        if (RVRenderer.isInRange(pose, vp = veh.vehicle.getV3D(), veh.vehicle.data)) {
            RVRenderer.renderVehicleInfo(pose, vp, veh.vehicle.data);
        }
        pose.m_85849_();
        if (DebugUtils.ACTIVE) {
            this.renderSeats(pose, veh.vehicle);
        }
        pose.m_85849_();
    }

    private void renderSeats(PoseStack pose, VehicleInstance vehicle) {
        if (vehicle.seats.isEmpty()) {
            return;
        }
        pose.m_85836_();
        for (SeatInstance seat : vehicle.seats) {
            float scale = seat.seat.scale() * 0.5f;
            V3D pos = seat.seat.pos;
            if (!seat.point.isVehicle()) {
                pos = seat.point.getRelativeVector(pos);
            }
            DebugUtils.renderBB(pos, scale, DebugUtils.COL_YLW);
        }
        Renderer120.resetColor();
        pose.m_85849_();
    }

    public static boolean isInRange(PoseStack pose, V3D vehpos, VehicleData data) {
        FvtmRenderTypes.setLineStrip();
        V3D ply = new V3D(Minecraft.m_91087_().f_91074_.m_20182_().f_82479_, Minecraft.m_91087_().f_91074_.m_20182_().f_82480_, Minecraft.m_91087_().f_91074_.m_20182_().f_82481_);
        boolean inrange = false;
        for (InteractZone zone : data.getInteractZones().values()) {
            if (zone.inRange(data, vehpos, ply)) {
                inrange = true;
                break;
            }
            if (!DebugUtils.ACTIVE) continue;
            pose.m_85836_();
            Renderer120.setColor(zone.inRange(data, vehpos, ply) ? DebugUtils.GRNCOLOR : DebugUtils.GRYCOLOR);
            pose.m_85841_(zone.range, zone.range, zone.range);
            DebugUtils.SPHERE.render();
            Renderer120.resetColor();
            pose.m_85849_();
        }
        return inrange;
    }

    public static void renderVehicleInfo(PoseStack pose, V3D vehpos, VehicleData data) {
        int tool;
        boolean red;
        PartData part = RVRenderer.isNormalPart();
        SwivelPoint point = null;
        if (part != null) {
            for (Map.Entry<String, PartSlots> ps : data.getPartSlotProviders().entrySet()) {
                V3D pos = ps.getKey().equals("vehicle") ? V3D.NULL : data.getPart((String)ps.getKey()).getInstalledPos();
                point = data.getRotationPointOfPart((String)ps.getKey());
                red = false;
                for (PartSlot value : ((PartSlots)ps.getValue()).values()) {
                    if (data.hasPart(value.type)) {
                        Part epart = (Part)data.getPart(value.type).getType();
                        if (!(epart.getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData)) continue;
                        red = !((DefaultPartInstallHandler.DPIHData)epart.getInstallHandlerData()).swappable;
                    }
                    String type = value.type;
                    for (String str : ((Part)part.getType()).getCategories()) {
                        if (!str.equals(type)) continue;
                        V3D pes = pos.add(value.pos);
                        if (point.isVehicle()) {
                            pose.m_85837_(pes.x, pes.y, pes.z);
                        } else {
                            pose.m_85836_();
                            V3D vec = point.getRelativeVector(pes);
                            pose.m_85837_(vec.x, vec.y, vec.z);
                            Renderer120.rotateRad(point.getPivot().yaw(), Renderer120.AY);
                            Renderer120.rotateRad(point.getPivot().pitch(), Renderer120.AX);
                            Renderer120.rotateRad(point.getPivot().roll(), Renderer120.AZ);
                        }
                        DebugUtils.renderBB(value.radius, red ? DebugUtils.COL_RED : DebugUtils.COL_CYN);
                        if (!point.isVehicle()) {
                            pose.m_85849_();
                            continue;
                        }
                        pose.m_85837_(-pes.x, -pes.y, -pes.z);
                    }
                }
            }
        }
        if ((tool = RVRenderer.isImpact()) > -1) {
            red = ((Vehicle)data.getType()).getImpactWrenchLevel() > tool;
            for (WheelSlot slot : data.getWheelSlots().values()) {
                DebugUtils.renderBB(slot.position, slot.max_radius, red ? DebugUtils.COL_RED : DebugUtils.COL_CYN);
            }
        }
        if ((part = RVRenderer.isWheelOrTire()) != null) {
            boolean wheel = part.hasFunction("fvtm:wheel");
            for (Map.Entry<String, WheelSlot> entry : data.getWheelSlots().entrySet()) {
                boolean green = ((Part)part.getType()).getInstallHandler().validInstall(FvtmLogger.NONE, part, entry.getKey(), data, true);
                if (wheel) {
                    red = data.hasPart(entry.getKey());
                } else {
                    boolean bl = red = data.hasPart(entry.getKey()) && ((WheelInstallationHandler.WheelData)((Part)data.getPart(entry.getKey()).getType()).getInstallHandlerData()).hasTire();
                    if (!red) {
                        red = data.hasPart(entry.getKey() + ":tire");
                    }
                }
                WheelSlot slot = entry.getValue();
                DebugUtils.renderBB(slot.position, slot.max_radius, red ? DebugUtils.COL_RED : (green ? DebugUtils.COL_GRN : DebugUtils.COL_CYN));
            }
        }
        if ((tool = RVRenderer.isToolbox()) > 0) {
            DebugUtils.renderBB(1.0f, DebugUtils.COL_ORG);
        }
        if (tool > -1 && tool < 2) {
            for (Map.Entry<String, PartData> entry : data.getParts().entrySet()) {
                if (tool == 0 && !(((Part)entry.getValue().getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData)) continue;
                red = tool != 0 || ((DefaultPartInstallHandler.DPIHData)((Part)entry.getValue().getType()).getInstallHandlerData()).removable;
                point = data.getRotationPointOfPart(entry.getKey());
                V3D pos = entry.getValue().getInstalledPos();
                if (point.isVehicle()) {
                    pose.m_85837_(pos.x, pos.y, pos.z);
                } else {
                    pose.m_85836_();
                    pos = point.getRelativeVector(pos);
                    pose.m_85837_(pos.x, pos.y, pos.z);
                    Renderer120.rotateDeg(pose, point.getPivot().deg_yaw(), Renderer120.AY);
                    Renderer120.rotateDeg(pose, point.getPivot().deg_pitch(), Renderer120.AX);
                    Renderer120.rotateDeg(pose, point.getPivot().deg_roll(), Renderer120.AZ);
                }
                DebugUtils.renderBB(red ? 0.25f : 0.125f, red ? DebugUtils.COL_YLW : DebugUtils.COL_RED);
                if (!point.isVehicle()) {
                    pose.m_85849_();
                    continue;
                }
                pose.m_85837_(-pos.x, -pos.y, -pos.z);
            }
        }
        Renderer120.resetColor();
    }

    private static int isImpact() {
        if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof MaterialItem)) {
            return -1;
        }
        return ((MaterialItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_()).getContent().getImpactLevel();
    }

    public static int isToolbox() {
        if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof ToolboxItem)) {
            return -1;
        }
        return ((ToolboxItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_()).var;
    }

    private static PartData isNormalPart() {
        if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof PartItem)) {
            return null;
        }
        PartData data = ((PartItemApp)UniStack.getApp((Object)Minecraft.m_91087_().f_91074_.m_21205_(), PartItemApp.class)).data;
        return ((Part)data.getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData ? data : null;
    }

    private static PartData isWheelOrTire() {
        if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof PartItem)) {
            return null;
        }
        PartData data = ((PartItemApp)UniStack.getApp((Object)Minecraft.m_91087_().f_91074_.m_21205_(), PartItemApp.class)).data;
        return data.hasFunction("fvtm:wheel") || data.hasFunction("fvtm:tire") ? data : null;
    }

    private V3D getRotations(RootVehicle veh, float ticks) {
        double yaw = MathUtils.valDeg(veh.vehicle.pivot().deg_yaw() - veh.f_19859_);
        double pitch = MathUtils.valDeg(veh.vehicle.pivot().deg_pitch() - veh.f_19860_);
        double roll = MathUtils.valDeg(veh.vehicle.pivot().deg_roll() - veh.protZ);
        return new V3D((double)veh.f_19859_ + yaw * (double)ticks, (double)veh.f_19860_ + pitch * (double)ticks, (double)veh.protZ + roll * (double)ticks);
    }

    public static V3D getRotations(SwivelPoint point, float ticks) {
        double yaw = MathUtils.valDeg(point.getPivot().deg_yaw() - point.getPrevPivot().deg_yaw());
        double pitch = MathUtils.valDeg(point.getPivot().deg_pitch() - point.getPrevPivot().deg_pitch());
        double roll = MathUtils.valDeg(point.getPivot().deg_roll() - point.getPrevPivot().deg_roll());
        return new V3D((double)point.getPrevPivot().deg_yaw() + yaw * (double)ticks, (double)point.getPrevPivot().deg_pitch() + pitch * (double)ticks, (double)point.getPrevPivot().deg_roll() + roll * (double)ticks);
    }

    public static void renderPoint(PoseStack pose, SwivelPoint point, RootVehicle vehicle, VehicleData data, RenderCache cache, float ticks) {
        ArrayList<Map.Entry<String, PartData>> parts = data.sorted_parts.get(point.id);
        if (parts == null) {
            return;
        }
        pose.m_85836_();
        if (!point.isVehicle()) {
            V3D temp0 = point.getPos();
            V3D temp1 = point.getPrevPos();
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            V3D rot = RVRenderer.getRotations(point, ticks);
            pose.m_85837_(temp2.x, temp2.y, temp2.z);
            pose.m_252781_(new Quaternionf().rotateAxis((float)Static.toRadians((double)(-rot.x)), (Vector3fc)Renderer120.AY).rotateAxis((float)Static.toRadians((double)(-rot.y)), (Vector3fc)Renderer120.AX).rotateAxis((float)Static.toRadians((double)(-rot.z)), (Vector3fc)Renderer120.AZ));
        }
        for (Map.Entry<String, PartData> entry : parts) {
            if (((Part)entry.getValue().getType()).getModel() == null) continue;
            pose.m_85836_();
            FvtmRenderTypes.setCutout(entry.getValue().getCurrentTexture());
            RVRenderer.translate(pose, entry.getValue().getInstalledPos());
            RVRenderer.rotate(pose, entry.getValue().getInstalledRot());
            ((Part)entry.getValue().getType()).getModel().render(DefaultModel.RENDERDATA.set(data, vehicle == null ? null : vehicle.vehicle, entry.getValue(), entry.getKey(), ticks).rc(cache));
            pose.m_85849_();
        }
        for (SwivelPoint sub : point.subs) {
            RVRenderer.renderPoint(pose, sub, vehicle, data, cache, ticks);
        }
        pose.m_85849_();
    }

    public static void renderPointSep(PoseStack pose, SwivelPoint point, VehicleInstance inst, ArrayList<String> parts, float ticks) {
        pose.m_85836_();
        if (!point.isVehicle()) {
            V3D temp0 = point.getPos();
            V3D temp1 = point.getPrevPos();
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            V3D rot = RVRenderer.getRotations(point, ticks);
            pose.m_85837_(temp2.x, temp2.y, temp2.z);
            pose.m_252781_(new Quaternionf().rotateAxis((float)Static.toRadians((double)(-rot.x)), (Vector3fc)Renderer120.AY).rotateAxis((float)Static.toRadians((double)(-rot.y)), (Vector3fc)Renderer120.AX).rotateAxis((float)Static.toRadians((double)(-rot.z)), (Vector3fc)Renderer120.AZ));
        }
        for (Map.Entry<String, PartData> entry : inst.data.getParts().entrySet()) {
            if (!parts.contains(entry.getKey()) || !entry.getValue().isInstalledOnSwivelPoint(point.id)) continue;
            pose.m_85836_();
            FvtmRenderTypes.setCutout(entry.getValue().getCurrentTexture());
            RVRenderer.translate(pose, entry.getValue().getInstalledPos());
            RVRenderer.rotate(pose, entry.getValue().getInstalledRot());
            ((Part)entry.getValue().getType()).getModel().render(DefaultModel.RENDERDATA.set(inst.data, inst, entry.getValue(), entry.getKey(), ticks).rc(inst.cache).sep());
            pose.m_85849_();
        }
        for (SwivelPoint sub : point.subs) {
            RVRenderer.renderPointSep(pose, sub, inst, parts, ticks);
        }
        pose.m_85849_();
    }

    private static void translate(PoseStack pose, V3D pos) {
        pose.m_85837_(pos.x, pos.y, pos.z);
    }

    private static void rotate(PoseStack pose, Rot rot) {
        rot.rotate112();
        Quaternionf q = new Quaternionf();
        if (rot.vec().y != 0.0) {
            q.rotateAxis((float)Static.toRadians((double)rot.vec().y), (Vector3fc)Renderer120.AY);
        }
        if (rot.vec().x != 0.0) {
            q.rotateAxis((float)Static.toRadians((double)rot.vec().x), (Vector3fc)Renderer120.AX);
        }
        if (rot.vec().z != 0.0) {
            q.rotateAxis((float)Static.toRadians((double)rot.vec().z), (Vector3fc)Renderer120.AZ);
        }
        pose.m_252781_(q);
    }

    public ResourceLocation getTextureLocation(RootVehicle entity) {
        return (ResourceLocation)FvtmRegistry.WHITE_TEXTURE.local();
    }
}

