/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.block.VehicleLiftEntity;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.vehicle.LiftingPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.block.Lift2024Model;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.RVRenderer;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public class VehicleLiftRenderer
implements BlockEntityRenderer<VehicleLiftEntity> {
    public static final IDL TEXTURE = IDLManager.getIDLCached((String)"fvtm:textures/block/lift2024.png");
    private VehicleData data;

    public void render(VehicleLiftEntity tile, float ticks, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        Renderer120.pose = pose;
        Renderer120.set(pose, buffer, light, overlay);
        FvtmRenderTypes.setCutout(TEXTURE);
        pose.m_85836_();
        pose.m_85837_(0.5, 0.0, 0.5);
        if (tile.rot != 0) {
            pose.m_252781_(new Quaternionf().rotateAxis((float)Static.toRadians((double)BlockType.GENERIC_4ROT.getRotationFor(tile.rot)), (Vector3fc)Renderer120.AY));
        }
        Lift2024Model.center.render();
        this.data = tile.getVehicleData();
        if (this.data != null) {
            V3D vdp;
            pose.m_85836_();
            pose.m_85837_(0.0, tile.liftstate + 0.3125, 0.0);
            if (((Vehicle)this.data.getType()).getModel() != null) {
                FvtmRenderTypes.setCutout(this.data.getCurrentTexture());
                ((Vehicle)this.data.getType()).getModel().render(DefaultModel.RENDERDATA.set(this.data, null, ticks));
            }
            if (this.data.getParts().size() > 0) {
                RVRenderer.renderPoint(pose, this.data.getRotationPoint("vehicle"), null, this.data, null, ticks);
            }
            if (RVRenderer.isInRange(pose, vdp = tile.getVehicleDataPos(), this.data)) {
                RVRenderer.renderVehicleInfo(pose, vdp, this.data);
            }
            pose.m_85849_();
            FvtmRenderTypes.setCutout(TEXTURE);
            for (LiftingPoint[] point : ((Vehicle)this.data.getType()).getGroupedLiftingPoints().values()) {
                pose.m_85836_();
                V3D vec = point.length == 1 ? point[0].pos : point[0].pos.add(point[1].pos).multiply(0.5);
                double dis = point.length > 1 ? Math.abs(point[0].pos.z) + Math.abs(point[1].pos.z) : 0.0;
                float m = 0.0f;
                if (point.length == 1 || dis <= 0.75) {
                    if (vec.x > 0.0) {
                        pose.m_85837_(1.75 + vec.x, 0.0, vec.z);
                        Renderer120.rotateRad(pose, 3.14159f, Renderer120.AY);
                    } else {
                        pose.m_85837_(-1.75 + vec.x, 0.0, vec.z);
                        Lift2024Model.motor.render();
                    }
                    Lift2024Model.struct.render();
                    pose.m_85837_(0.0, tile.liftstate + vec.y, 0.0);
                    Lift2024Model.lift.render();
                    Lift2024Model.arm_n.rotate(0.0f, -90.0f, 0.0f, true);
                    Lift2024Model.arm_n_e.rotate(0.0f, -90.0f, 0.0f, true);
                    Lift2024Model.arm_s.rotate(0.0f, 90.0f, 0.0f, true);
                    Lift2024Model.arm_s_e.rotate(0.0f, 90.0f, 0.0f, true);
                    Lift2024Model.arm_n.render();
                    Lift2024Model.arm_n_e.render();
                    Lift2024Model.arm_s.render();
                    Lift2024Model.arm_s_e.render();
                } else {
                    float r = (float)(2.0 - dis - 0.75) * 0.5f;
                    if (vec.x > 0.0) {
                        pose.m_85837_((double)(dis < 2.75 ? -r : 0.0f) + 0.75 + vec.x, 0.0, vec.z);
                        Renderer120.rotateRad(pose, 3.14159f, Renderer120.AY);
                    } else {
                        pose.m_85837_((double)(dis < 2.75 ? r : 0.0f) - 0.75 + vec.x, 0.0, vec.z);
                        Lift2024Model.motor.render();
                    }
                    Lift2024Model.struct.render();
                    pose.m_85837_(0.0, tile.liftstate + vec.y, 0.0);
                    Lift2024Model.lift.render();
                    if (dis < 2.75) {
                        Lift2024Model.arm_n.rotate(0.0f, r *= 90.0f, 0.0f, true);
                        Lift2024Model.arm_n_e.rotate(0.0f, r, 0.0f, true);
                        Lift2024Model.arm_s.rotate(0.0f, -r, 0.0f, true);
                        Lift2024Model.arm_s_e.rotate(0.0f, -r, 0.0f, true);
                    } else {
                        m = dis > 4.75 ? 1.0f : (float)((dis - 2.75) * 0.5);
                        Lift2024Model.arm_n_e.translate(0.0f, 0.0f, -m, false);
                        Lift2024Model.arm_s_e.translate(0.0f, 0.0f, m, false);
                    }
                    Lift2024Model.arm_n.render();
                    Lift2024Model.arm_n_e.render();
                    Lift2024Model.arm_s.render();
                    Lift2024Model.arm_s_e.render();
                    if (m != 0.0f) {
                        Lift2024Model.arm_n_e.translate(0.0f, 0.0f, m, false);
                        Lift2024Model.arm_s_e.translate(0.0f, 0.0f, -m, false);
                    }
                }
                pose.m_85849_();
            }
            Lift2024Model.arm_n.rotate(0.0f, 0.0f, 0.0f, true);
            Lift2024Model.arm_n_e.rotate(0.0f, 0.0f, 0.0f, true);
            Lift2024Model.arm_s.rotate(0.0f, 0.0f, 0.0f, true);
            Lift2024Model.arm_s_e.rotate(0.0f, 0.0f, 0.0f, true);
        } else {
            pose.m_252880_(-2.0f, 0.0f, 0.0f);
            Lift2024Model.struct.render();
            Lift2024Model.motor.render();
            Lift2024Model.lift.render();
            Lift2024Model.arm_n.render();
            Lift2024Model.arm_n_e.render();
            Lift2024Model.arm_s.render();
            Lift2024Model.arm_s_e.render();
            pose.m_252880_(4.0f, 0.0f, 0.0f);
            Renderer120.rotateRad(pose, 3.14159f, Renderer120.AY);
            Lift2024Model.struct.render();
            Lift2024Model.lift.render();
            Lift2024Model.arm_n.render();
            Lift2024Model.arm_n_e.render();
            Lift2024Model.arm_s.render();
            Lift2024Model.arm_s_e.render();
        }
        pose.m_85849_();
    }

    public int m_142163_() {
        return 128;
    }
}

