/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.event.ForgeClientEvents;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.model.content.WireModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.PathModelGenerator;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WireRenderer {
    public static Wire CURRENT;
    public static double ANGLE;
    public static double ANGLE_DOWN;
    private static WireSystem wiredata;
    private static ItemStack held;
    private static boolean holding_wire;
    private static boolean holding_slack;

    @SubscribeEvent
    public static void renderWires(RenderLevelStageEvent event) {
        if (Config.DISABLE_WIRES) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        wiredata = SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)event.getCamera().m_90592_().m_9236_()), WireSystem.class);
        if (wiredata == null || wiredata.getRegions() == null) {
            return;
        }
        held = Minecraft.m_91087_().f_91074_.m_21205_();
        holding_wire = held.m_41720_() instanceof WireItem || held.m_41720_() instanceof ToolboxItem && ToolboxType.WIRE_REMOVAL.eq(ToolboxItem.getToolboxType(held));
        holding_slack = held.m_41720_() instanceof ToolboxItem && ToolboxType.WIRE_SLACK.eq(ToolboxItem.getToolboxType(held));
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        PoseStack pose = event.getPoseStack();
        FvtmRenderTypes.setCutout(ForgeClientEvents.JUNCTEX);
        Renderer120.set(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        for (SystemRegion reg : wiredata.getRegions().values()) {
            for (RelayHolder holder : reg.getObjects().values()) {
                for (WireRelay relay : holder.relays.values()) {
                    Renderer120.light = LevelRenderer.m_109541_((BlockAndTintGetter)camera.m_90592_().m_9236_(), (BlockPos)pos.m_122169_(relay.pos.x, relay.pos.y + 0.1, relay.pos.z));
                    if (DebugUtils.ACTIVE || holding_wire) {
                        DebugUtils.renderBB(relay.pos, holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_CYN);
                    }
                    if ((DebugUtils.ACTIVE || holding_slack) && relay.wires.size() > 0) {
                        for (Wire wire : relay.wires) {
                            if (wire.copy) continue;
                            DebugUtils.renderBB(wire.getVectorPosition((double)wire.length * 0.5, false), holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_ORG);
                        }
                    }
                    WireRenderer.renderWires(pose, relay);
                }
            }
        }
        pose.m_85849_();
    }

    private static void renderWires(PoseStack pose, WireRelay relay) {
        pose.m_85836_();
        for (int i = 0; i < relay.size(); ++i) {
            if (relay.wires.get((int)i).copy) continue;
            Wire wire = relay.wires.get(i);
            if (wire.vecpath == null || wire.getWireType() == null) continue;
            WireModel model = wire.getWireType().getModel();
            if (wire.wiremodel == null) {
                PathModelGenerator.generateWireModel(wire, model);
            }
            FvtmRenderTypes.setCutout(wire.getWireType().getTexture());
            pose.m_85837_(wire.vecpath[0].x, wire.vecpath[0].y, wire.vecpath[0].z);
            wire.wiremodel.render();
            if (relay.getTile() == null) continue;
            CURRENT = wire;
            ANGLE = wire.model_end_angle;
            if (wire.deco_s != null) {
                ANGLE_DOWN = wire.model_start_angle_down;
            }
            if (wire.deco_e == null) continue;
            ANGLE_DOWN = wire.model_end_angle_down;
        }
        pose.m_85849_();
    }

    static {
        ANGLE = 0.0;
        ANGLE_DOWN = 0.0;
    }
}

