/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.mod.fvtm.data.root.Soundable;
import net.fexcraft.mod.fvtm.sys.event.EventAction;
import net.fexcraft.mod.fvtm.sys.event.EventListener;
import net.fexcraft.mod.fvtm.sys.event.EventType;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;

public class EventHolder {
    public HashMap<EventType, ArrayList<EventListener>> listeners = new LinkedHashMap<EventType, ArrayList<EventListener>>();
    public HashMap<String, EventHolder> subholders = new LinkedHashMap<String, EventHolder>();
    public Soundable.SoundHolder sounds;
    public Object root;

    public EventHolder(Object root) {
        this.root = root;
        this.sounds = (Soundable.SoundHolder)root;
    }

    public void integrate(EventHolder holder, String origin) {
        if (origin == null) {
            for (Map.Entry<EventType, ArrayList<EventListener>> entry : holder.listeners.entrySet()) {
                if (!this.listeners.containsKey(entry.getKey())) {
                    this.listeners.put(entry.getKey(), new ArrayList());
                }
                this.listeners.get(entry.getKey()).addAll((Collection<EventListener>)entry.getValue());
            }
        } else {
            this.subholders.put(origin, holder);
        }
    }

    public void deintegrate(EventHolder holder, String origin) {
        if (origin == null) {
            for (Map.Entry<EventType, ArrayList<EventListener>> entry2 : holder.listeners.entrySet()) {
                ArrayList<EventListener> lis = this.listeners.get(entry2.getKey());
                if (lis == null) continue;
                lis.removeAll((Collection)entry2.getValue());
            }
            this.listeners.entrySet().removeIf(entry -> ((ArrayList)entry.getValue()).isEmpty());
        } else if (this.subholders.containsKey(origin)) {
            this.subholders.remove(origin);
        }
    }

    public void insert(EventListener lis) {
        if (!this.listeners.containsKey(lis.type)) {
            this.listeners.put(lis.type, new ArrayList());
        }
        this.listeners.get(lis.type).add(lis);
    }

    public void run(EventType event, VehicleInstance inst, Passenger pass, Object ... args) {
        if (this.listeners.containsKey(event)) {
            for (EventListener lis : this.listeners.get(event)) {
                if (!lis.cond.isMet(EventAction.DATA.set(inst, pass, this, this))) continue;
                lis.action.run(EventAction.DATA, lis, args);
            }
        }
        for (EventHolder hol : this.subholders.values()) {
            if (!hol.listeners.containsKey(event)) continue;
            for (EventListener lis : hol.listeners.get(event)) {
                if (!lis.cond.isMet(EventAction.DATA.set(inst, pass, this, hol))) continue;
                lis.action.run(EventAction.DATA, lis, args);
            }
        }
    }
}

