/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.road.UniRoadTool;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class RailPlacingUtil {
    public static final ConcurrentHashMap<UUID, NewTrack> QUEUE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<UUID, UUID> CURRENT = new ConcurrentHashMap();
    public static NewTrack CL_CURRENT = null;

    public static void place(RailSystem system, EntityW pass, RailGauge gauge, QV3D vector) {
        UUID trackid = CURRENT.get(pass.getUUID());
        if (trackid == null) {
            UUID newid = RailPlacingUtil.genId();
            Junction junc = system.getJunction(vector.pos);
            if (junc != null) {
                vector = junc.getPos();
            }
            QUEUE.put(newid, new NewTrack(newid, vector, gauge));
            CURRENT.put(pass.getUUID(), newid);
            TagCW compound = TagCW.create();
            compound.set("subtask", "new");
            compound.set("uuid_l", newid.getMostSignificantBits());
            compound.set("uuid_m", newid.getLeastSignificantBits());
            compound.set("new", true);
            compound.set("gauge", gauge.getIDS());
            vector.write(compound, "vector");
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
            FvtmResources.INSTANCE.spawnRailMarker(system.getWorld(), vector, newid);
            return;
        }
        NewTrack track = QUEUE.get(trackid);
        if (track == null) {
            CURRENT.remove(pass.getUUID());
        }
        track.add(vector);
        TagCW compound = TagCW.create();
        compound.set("subtask", "add");
        compound.set("uuid_l", trackid.getMostSignificantBits());
        compound.set("uuid_m", trackid.getLeastSignificantBits());
        vector.write(compound, "vector");
        Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        FvtmResources.INSTANCE.spawnRailMarker(system.getWorld(), vector, trackid);
    }

    private static UUID genId() {
        UUID uuid = UUID.randomUUID();
        while (QUEUE.contains(uuid) || uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            uuid = UUID.randomUUID();
        }
        return uuid;
    }

    public static class NewTrack {
        public ArrayList<QV3D> points = new ArrayList();
        public ArrayList<ArrayList<V3D>> preview;
        public RailGauge gauge;
        public Track track;
        public int selected = -1;
        public UUID id;

        public NewTrack(UUID uuid, QV3D vector, RailGauge gauge) {
            this.points.add(vector);
            this.gauge = gauge;
            this.id = uuid;
        }

        public void add(QV3D vector) {
            this.points.add(this.selected == -1 ? this.points.size() : (this.selected = this.selected + 1), vector);
            this.preview = null;
            this.gentrack();
        }

        public void gentrack() {
            this.track = this.points.size() > 1 ? new Track(null, this.points.toArray(new QV3D[0]), this.gauge) : null;
        }

        public void select(EntityW player, QV3D vector) {
            int sel = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                sel = i;
                break;
            }
            this.selected = sel;
            TagCW compound = TagCW.create();
            compound.set("selected", this.selected);
            compound.set("subtask", "selected");
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        }

        public void remove(EntityW player, QV3D vector) {
            int rem = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                rem = i;
                break;
            }
            if (rem < 0) {
                return;
            }
            if (rem <= this.selected) {
                --this.selected;
            }
            if (this.selected < -1) {
                this.selected = -1;
            }
            this.points.remove(rem);
            this.gentrack();
            this.preview = null;
            if (this.points.size() == 0) {
                this.reset();
                return;
            }
            TagCW compound = TagCW.create();
            compound.set("remove", rem);
            compound.set("subtask", "remove");
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            vector.write(compound, "vector");
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        }

        public void reset() {
            QUEUE.remove(this.id);
            CURRENT.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(this.id));
            TagCW compound = TagCW.create();
            compound.set("subtask", "reset");
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        }

        public int indexOf(QV3D vector) {
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                return i;
            }
            return -2;
        }

        public void create(EntityW player, QV3D vector) {
            boolean nn;
            RailSystem sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            Junction junc = sys.getJunction(vector.pos, true);
            UUID current = CURRENT.get(player.getUUID());
            boolean bl = nn = junc != null;
            if (current == null) {
                player.send("no_queue_entry / 0");
                return;
            }
            NewTrack ntrack = QUEUE.get(current);
            if (ntrack == null) {
                player.send("no_queue_entry / 1");
                return;
            }
            if (junc == null) {
                sys.addJunction(vector);
                junc = sys.getJunction(vector.pos, true);
                junc.updateVecPos(vector);
                if (ntrack.points.size() == 1 || ntrack.allsame()) {
                    player.send("&o> Junction Created.");
                    this.reset();
                    return;
                }
                player.send("&o> End Junction Created.");
            }
            if (!junc.tracks.isEmpty() && junc.tracks.size() < 2 && !junc.tracks.get(0).isCompatibleGauge(ntrack.gauge)) {
                player.send("&9Item/Track Gauge not compatible with the &7Junction's Gauge&9.");
                return;
            }
            if (junc.signal != null) {
                player.send("&9Please remove the signal first.");
                return;
            }
            if (junc.tracks.size() >= 4) {
                player.send("&9Junction reached track limit (4)\n&c&oPoint cache reset.");
                ntrack.reset();
                return;
            }
            QV3D[] arr = ntrack.points.toArray(new QV3D[0]);
            if (nn) {
                arr[arr.length - 1] = junc.getPos();
            }
            Track track = new Track(junc, arr, this.gauge);
            if (track.length > (double)Config.MAX_RAIL_TRACK_LENGTH) {
                player.send("&cTrack length exceeds the configured max length.");
                return;
            }
            Junction second = sys.getJunction(track.start.pos);
            if (second == null) {
                sys.addJunction(track.start);
                second = sys.getJunction(track.start.pos, true);
                player.send("&o> Start Junction Created.");
            }
            if (second != null) {
                second.addnew(track);
                junc.addnew(track.createOppositeCopy());
                second.checkTrackSectionConsistency();
                player.send("&o> Track Created.");
                ntrack.reset();
            } else {
                player.send("&cNo Junction at starting point found!");
            }
        }

        private boolean allsame() {
            QV3D vec = this.points.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                if (vec.equals(this.points.get(i))) continue;
                return false;
            }
            return true;
        }

        public void genpreview() {
            double half = this.gauge.getWidth() * 0.5f;
            this.preview = new ArrayList();
            this.preview.add(new ArrayList());
            this.preview.add(new ArrayList());
            V3D vec = this.track.vecpath[0];
            float pass = 0.0f;
            while ((double)pass < this.track.length + 0.125) {
                V3D last = vec;
                vec = this.track.getVectorPosition0(pass == 0.0f ? (double)0.001f : (double)pass, false);
                double angle = (float)Math.atan2(last.x - vec.x, last.z - vec.z);
                this.preview.get(0).add(vec.add(UniRoadTool.grv(angle, new V3D(-half, 0.0, 0.0))));
                this.preview.get(1).add(vec.add(UniRoadTool.grv(angle, new V3D(half, 0.0, 0.0))));
                pass += 0.125f;
            }
        }
    }
}

