/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeMap;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.data.block.FvtmBlockEntity;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireKey;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSection;
import net.fexcraft.mod.fvtm.sys.wire.WireUnit;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class WireSystem
extends DetachedSystem<WireSystem, RelayHolder> {
    private long gc_sections;
    private WireMap wireunits = new WireMap(this);
    private SectionMap sections = new SectionMap(this);

    public WireSystem(WorldW world) {
        super(world);
        if (!world.isClient()) {
            this.load();
        }
    }

    @Override
    public SystemManager.Systems getType() {
        return SystemManager.Systems.WIRE;
    }

    public void load() {
        try {
            TagCW compound;
            File file = new File(this.getSaveRoot(), "/wiresystem.dat");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if ((compound = WrapperHolder.read((File)file)) == null || compound.empty()) {
                return;
            }
            this.gc_sections = compound.getLong("GlobalCounterSections");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        TagCW compound = TagCW.create();
        compound.set("GlobalCounterSections", this.gc_sections);
        try {
            File file = new File(this.getSaveRoot(), "/wiresystem.dat");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            WrapperHolder.write((TagCW)compound, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRelayInteract(TagCW com, Passenger player) {
        RelayHolder holder = this.getHolder(com.getV3I("holder"));
        if (holder == null) {
            player.send("error.holder.null");
            return;
        }
        if (!holder.hasRef()) {
            player.send("error.holder.ref-null");
            return;
        }
        WireRelay relay = holder.get(com.getString("relay"));
        if (relay == null) {
            player.send("error.relay.null");
            return;
        }
        StackWrapper stack = player.getHeldItem(true);
        WireType type = (WireType)stack.getContent(ContentType.WIRE.item_type);
        if (type == null) {
            player.send("error.wire-type.null");
            return;
        }
        ArrayList<String> list = holder.ref().types.get(relay.getKey());
        if (!list.isEmpty() && !list.contains(type.getType())) {
            player.send("interact.fvtm.relay.wire_not_compatible");
            return;
        }
        int l = holder.ref().limits.get(relay.getKey());
        if (l > 0 && relay.size() > l) {
            player.send("interact.fvtm.relay.full");
            return;
        }
        TagCW tag = stack.copyTag();
        if (tag.has("fvtm:wirepoint")) {
            WireRelay relay0 = this.getRelay(new WireKey(tag.getV3I("fvtm:wirepoint"), tag.getString("fvtm:wirepoint_key")));
            if (relay0.pos.dis(relay.pos) > (double)Config.MAX_WIRE_LENGTH) {
                player.send("interact.fvtm.relay.wire_too_long");
                return;
            }
            Wire wire = new Wire(relay0, relay, type, relay0.pos, relay.pos);
            if (relay0.isDuplicate(wire) || relay.isDuplicate(wire)) {
                player.send("interact.fvtm.relay.wire_duplicate");
                return;
            }
            relay0.addnew(wire);
            relay.addnew(wire.createOppositeCopy());
            relay0.checkWireSectionConsistency();
            tag.rem("fvtm:wirepoint");
            tag.rem("fvtm:wirepoint_key");
            stack.updateTag(tag);
            player.bar("interact.fvtm.relay.wire_created");
        } else {
            tag.set("fvtm:wirepoint", holder.pos, false);
            tag.set("fvtm:wirepoint_key", relay.key);
            stack.updateTag(tag);
            player.bar("interact.fvtm.relay.cached");
        }
    }

    public void onRelayRemove(TagCW com, Passenger player) {
        RelayHolder holder = this.getHolder(com.getV3I("holder"));
        if (holder == null) {
            player.send("error.holder.null");
            return;
        }
        WireRelay relay = holder.get(com.getString("relay"));
        if (relay == null) {
            player.send("error.relay.null");
            return;
        }
        if (player.isShiftDown()) {
            while (relay.size() > 0) {
                relay.remove(0, true);
            }
        } else {
            relay.remove(relay.size() - 1, true);
        }
    }

    public void onRelayWireSlack(TagCW com, Passenger player) {
        Wire wire0 = this.getWire(new WireKey(com));
        Wire wire1 = this.getWire(wire0.okey);
        wire0.slack = wire0.slack + (com.getBoolean("up") ? -Config.WIRE_SLACK_ADJUSTMENT : Config.WIRE_SLACK_ADJUSTMENT);
        if (wire0.slack > 8.0f) {
            wire0.slack = 8.0f;
        }
        if (wire0.slack < -8.0f) {
            wire0.slack = -8.0f;
        }
        wire1.slack = wire0.slack;
        wire0.reslack();
        wire1.reslack();
        wire0.getRelay().updateClient();
        wire1.getRelay().updateClient();
        player.bar("interact.fvtm.relay.wire_slack", new Object[]{Float.valueOf(wire0.slack)});
    }

    @Override
    public RelayHolder create(SystemRegion<WireSystem, RelayHolder> region, V3I pos) {
        return new RelayHolder(region, pos);
    }

    @Override
    public void writeRegion(SystemRegion<WireSystem, RelayHolder> region, TagCW com) {
        if (region.getObjects().isEmpty()) {
            return;
        }
        TagLW list = TagLW.create();
        for (RelayHolder holder : region.getObjects().values()) {
            list.add(holder.write());
        }
        com.set("RelayHolders", list);
    }

    @Override
    public void readRegion(SystemRegion<WireSystem, RelayHolder> region, TagCW com) {
        if (!com.has("RelayHolders")) {
            return;
        }
        region.getObjects().clear();
        TagLW list = com.getList("RelayHolders");
        for (TagCW tag : list) {
            RelayHolder holder = new RelayHolder(region);
            holder.read(tag);
            region.getObjects().put(holder.pos, holder);
        }
    }

    public void updateClient(String kind, String key, V3I pos, Object obj) {
        if (this.world.isClient()) {
            return;
        }
        TagCW compound = null;
        String task = null;
        switch (kind) {
            case "relay": {
                task = "wire_upd_relay";
                compound = TagCW.create();
                compound.set("pos", ((WireRelay)obj).holder.pos, false);
                ((WireRelay)obj).write(compound);
                break;
            }
            case "no_relay": {
                task = "wire_rem_relay";
                compound = TagCW.create();
                compound.set("pos", pos, false);
                compound.set("key", key);
                break;
            }
            case "holder": {
                RelayHolder holder = this.getHolder(pos);
                if (holder == null) {
                    return;
                }
                compound = holder.write();
                task = "wire_upd_holder";
                break;
            }
            case "no_holder": {
                task = "wire_rem_holder";
                compound = TagCW.create();
                compound.set("pos", pos, false);
                break;
            }
            case "sections": {
                task = "wire_udp_sections";
                compound = TagCW.create();
                TagLW list = TagLW.create();
                for (WireUnit unit : this.getWireUnits().values()) {
                    TagCW com = TagCW.create();
                    com.set("unit", unit.getUID());
                    com.set("section", unit.getSectionId());
                    list.add(com);
                }
                compound.set("units", list);
                break;
            }
            default: {
                Static.stop();
            }
        }
        if (compound == null) {
            return;
        }
        Packets.sendToAllTrackingPos(Packet_TagListener.class, this.world, pos, task, compound);
    }

    public WireRelay getRelay(WireKey key) {
        SystemRegion region = this.regions.get(key.start_pos, false);
        if (region == null) {
            return null;
        }
        RelayHolder holder = (RelayHolder)region.get(key.start_pos);
        return holder == null ? null : holder.get(key.start_relay);
    }

    public WireRelay getRelay(WireKey key, boolean load) {
        SystemRegion region = this.regions.get(key.start_pos, load);
        RelayHolder holder = (RelayHolder)region.get(key.start_pos);
        return holder == null ? null : holder.get(key.start_relay);
    }

    public ArrayList<WireRelay> getRelaysInChunk(int cx, int cz) {
        ArrayList<WireRelay> arr = new ArrayList<WireRelay>();
        SystemRegion region = this.regions.get(RegionKey.getRegionXZ(cx, cz));
        if (region == null) {
            return arr;
        }
        for (Map.Entry entry : region.getObjects().entrySet()) {
            if (entry.getKey().x >> 4 != cx || entry.getKey().z >> 4 != cz) continue;
            arr.addAll(((RelayHolder)entry.getValue()).relays.values());
        }
        return arr;
    }

    public boolean delRelay(WireKey key) {
        RelayHolder holder = this.getHolder(key.start_pos);
        return holder.remove(key.start_relay) != null;
    }

    @Override
    public void onServerTick() {
        for (SystemRegion region : this.regions.values()) {
            if (region.timer > 20) {
                region.timer = -1;
                for (RelayHolder holder : region.getObjects().values()) {
                    for (WireRelay relay : holder.relays.values()) {
                        relay.onUpdate();
                    }
                }
            }
            ++region.timer;
        }
    }

    @Override
    public void unload() {
        if (!this.world.isClient()) {
            this.regions.values().forEach(reg -> reg.save());
            this.save();
        }
        this.regions.clear();
    }

    @Override
    public void onChunkLoad(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.put(new RegionKey(chunk.x(), chunk.z()), chunk);
    }

    @Override
    public void onChunkUnload(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.values().removeIf(pre -> pre.x() == chunk.x() && pre.z() == chunk.z());
    }

    public long getNewSectionId() {
        return this.gc_sections++;
    }

    public Wire getWire(WireKey key) {
        SystemRegion region = this.regions.get(RegionKey.getRegionXZ(key.start_pos), true);
        RelayHolder holder = (RelayHolder)region.get(key.start_pos);
        if (holder == null) {
            return null;
        }
        WireRelay relay = holder.get(key.start_relay);
        return relay == null ? null : relay.getWire(key);
    }

    public WireMap getWireUnits() {
        return this.wireunits;
    }

    public SectionMap getSections() {
        return this.sections;
    }

    public WireSection getSection(Long sid) {
        return this.sections.get(sid, true);
    }

    public void sendReload(String string, EntityW sender) {
        SystemRegion region = this.regions.get(RegionKey.getRegionXZ(sender.getPos()));
        if (region != null) {
            region.sendSync(sender);
        }
    }

    public boolean isRemote() {
        return this.world.isClient();
    }

    @Override
    public boolean hasTimer() {
        return true;
    }

    @Override
    public void addTimerTask(long time) {
        this.timer.schedule((TimerTask)new TimedTask(this), new Date(time), (long)Config.UNLOAD_INTERVAL);
    }

    @Override
    public String getRegFolderName() {
        return "wireregions";
    }

    public void register(FvtmBlockEntity tile) {
        RelayHolder holder = this.getHolder(tile.getV3I());
        if (holder == null) {
            holder = this.addHolder(tile.getV3I());
        }
        holder.integrate(tile);
        holder.setTile(tile);
    }

    public void unregister(FvtmBlockEntity tile) {
        RelayHolder holder = this.getHolder(tile.getV3I());
        if (holder != null) {
            holder.setTile(null);
        }
    }

    public void deregister(Object tileentity) {
        if (!(tileentity instanceof FvtmBlockEntity)) {
            return;
        }
        FvtmBlockEntity tile = (FvtmBlockEntity)tileentity;
        this.delHolder(tile.getV3I());
    }

    public RelayHolder getHolder(V3I pos) {
        SystemRegion region = this.regions.get(pos, false);
        return region == null ? null : (RelayHolder)region.get(pos);
    }

    public RelayHolder getHolder(V3I pos, boolean load) {
        SystemRegion region = this.regions.get(pos, load);
        return (RelayHolder)region.get(pos);
    }

    private RelayHolder addHolder(V3I pos) {
        SystemRegion region = this.regions.get(pos, true);
        return (RelayHolder)region.add(pos);
    }

    public void delHolder(V3I pos) {
        SystemRegion region = this.regions.get(pos, true);
        if (region != null) {
            region.del(pos);
        }
    }

    @Override
    public void onClientTick() {
    }

    public static class WireMap
    extends TreeMap<String, WireUnit> {
        private WireSystem data;

        public WireMap(WireSystem wiredata) {
            this.data = wiredata;
        }

        public WireUnit get(String str, Long knownid, boolean create) {
            if (!create) {
                return (WireUnit)super.get(str);
            }
            WireUnit trk = (WireUnit)super.get(str);
            if (trk == null) {
                trk = new WireUnit(this.data, str, knownid);
                this.put(str, trk);
            }
            return trk;
        }
    }

    public static class SectionMap
    extends TreeMap<Long, WireSection> {
        private WireSystem data;

        public SectionMap(WireSystem wiredata) {
            this.data = wiredata;
        }

        public WireSection get(Long sid, boolean create) {
            if (create && sid == null) {
                WireSection sec = new WireSection(this.data, null);
                this.put(sec.getUID(), sec);
                return sec;
            }
            if (sid == null) {
                return null;
            }
            if (!create) {
                return (WireSection)super.get(sid);
            }
            WireSection sec = (WireSection)super.get(sid);
            if (sec == null) {
                sec = new WireSection(this.data, sid);
                this.put(sid, sec);
            }
            return sec;
        }
    }

    public static class TimedTask
    extends TimerTask {
        private WireSystem wiresys;

        public TimedTask(WireSystem wiresys) {
            this.wiresys = wiresys;
        }

        @Override
        public void run() {
            ArrayList<SystemRegion> regs = new ArrayList<SystemRegion>();
            for (SystemRegion region : this.wiresys.regions.values()) {
                if (!region.chucks.isEmpty() || region.lastaccess >= Time.getDate() - 60000L) continue;
                regs.add(region);
            }
            for (SystemRegion region : regs) {
                region.save();
                this.wiresys.regions.remove(region.key);
            }
        }
    }
}

