/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.ui.RailJunctionContainer;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class RailJunction
extends UserInterface {
    public static final RGB BLU = new RGB(38143);
    public static final RGB RED = new RGB(13376041);
    public static final RGB GRE = new RGB(65313);
    public static final RGB ORA = new RGB(16738816);
    public static final float[][] TRACK_COLOR = new float[][]{BLU.toFloatArray(), RED.toFloatArray(), GRE.toFloatArray(), ORA.toFloatArray()};
    private RailJunctionContainer menu;

    public RailJunction(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.menu = (RailJunctionContainer)con;
    }

    public void init() {
        ((UIText)this.texts.get("title")).value(this.menu.junc.posString());
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.menu.junc == null) {
            return;
        }
        switch (this.menu.junc.type) {
            case STRAIGHT: {
                ((UIText)this.texts.get("switch0")).value("inactive");
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = RED;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = RGB.WHITE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = RGB.WHITE;
                break;
            }
            case FORK_2: {
                ((UIText)this.texts.get("switch0")).value("Switch0: " + this.menu.junc.switch0);
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = this.menu.junc.switch0 ? RED : GRE;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = RGB.WHITE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = RGB.WHITE;
                break;
            }
            case FORK_3: {
                ((UIText)this.texts.get("switch0")).value("Switch0+1: " + this.menu.junc.switch0 + " / " + this.menu.junc.switch1);
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = this.menu.junc.switch0 ? RED : (this.menu.junc.switch1 ? ORA : GRE);
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = RGB.WHITE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = RGB.WHITE;
                break;
            }
            case DOUBLE: {
                ((UIText)this.texts.get("switch0")).value("Switch0: " + this.menu.junc.switch0);
                ((UIText)this.texts.get("switch1")).value("Switch1: " + this.menu.junc.switch1);
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = this.menu.junc.switch1 ? BLU : ORA;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = this.menu.junc.switch0 ? RED : GRE;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = this.menu.junc.switch0 ? RED : GRE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = this.menu.junc.switch1 ? BLU : ORA;
                break;
            }
            case CROSSING: {
                ((UIText)this.texts.get("switch0")).value("inactive");
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = RED;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = GRE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = ORA;
            }
        }
        for (int i = 0; i < 4; ++i) {
            ((UIText)this.texts.get("track" + i)).value(i >= this.menu.junc.size() ? "" : this.menu.junc.tracks.get((int)i).id.toPosString());
        }
    }

    public void drawbackground(float ticks, int mx, int my) {
        if (this.menu.junc == null) {
            return;
        }
        this.drawer.bindTabTex((UserInterface)this, "main");
        this.drawer.draw((float)(this.gLeft + 73 + this.menu.junc.type.ordinal() * 18), (float)(this.gTop + 21), 0, 238, 18, 18);
        for (int i = 0; i < this.menu.junc.size(); ++i) {
            this.drawTrack(this.menu.junc.tracks.get(i), TRACK_COLOR[i], this.menu.junc.getPos().pos);
        }
    }

    private void drawTrack(Track track, float[] color, V3I pos) {
        if (track.vecpath.length == 2) {
            V3D vec0 = track.vecpath[0];
            V3D vec1 = vec0.distance(track.vecpath[1], 15.0);
            this.drawer.drawLine((vec0.x - (double)pos.x + 16.0) * 2.0 + (double)this.gLeft + 7.0, (vec0.z - (double)pos.z + 16.0) * 2.0 + (double)this.gTop + 21.0, (vec1.x - (double)pos.x + 16.0) * 2.0 + (double)this.gLeft + 7.0, (vec1.z - (double)pos.z + 16.0) * 2.0 + (double)this.gTop + 21.0, color);
            return;
        }
        for (int j = 0; j < track.vecpath.length - 1; ++j) {
            V3D vec0 = track.vecpath[j];
            V3D vec1 = track.vecpath[j + 1];
            double x0 = vec0.x - (double)pos.x;
            double z0 = vec0.z - (double)pos.z;
            if (x0 < -16.0 || z0 < -16.0 || x0 > 16.0 || z0 > 16.0) continue;
            double x1 = vec1.x - (double)pos.x;
            double z1 = vec1.z - (double)pos.z;
            if (x1 < -16.0 || z1 < -16.0 || x1 > 16.0 || z1 > 16.0) continue;
            this.drawer.drawLine((x0 + 16.0) * 2.0 + (double)this.gLeft + 7.0, (z0 + 16.0) * 2.0 + (double)this.gTop + 21.0, (x1 + 16.0) * 2.0 + (double)this.gLeft + 7.0, (z1 + 16.0) * 2.0 + (double)this.gTop + 21.0, color);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int mb) {
        switch (id) {
            case "switch0": 
            case "switch1": 
            case "type_2": 
            case "type_3": 
            case "type_4": 
            case "down0": 
            case "down1": 
            case "down2": 
            case "up1": 
            case "up2": 
            case "up3": 
            case "rem0": 
            case "rem1": 
            case "rem2": 
            case "rem3": {
                TagCW com = TagCW.create();
                com.set("task", id);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
        }
        return false;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        if (((UIButton)this.buttons.get("section")).hovered()) {
            long last = -1L;
            for (int i = 0; i < this.menu.junc.tracks.size(); ++i) {
                Track track = this.menu.junc.tracks.get(i);
                if (last == track.getUnit().section().getUID()) continue;
                last = track.getUnit().section().getUID();
                list.add((String)RailJunctionContainer.TRANSFORMAT.apply("ui.fvtm.rail_junction.section", new Object[]{i, track.getUnit().section().getUID()}));
            }
        }
        if (((UIButton)this.buttons.get("signal")).hovered()) {
            list.add((String)RailJunctionContainer.TRANSFORMAT.apply("ui.fvtm.rail_junction.signal", new Object[]{this.menu.junc.signal == null ? "none" : this.menu.junc.signal}));
        }
    }
}

