/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.road;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.ui.road.RoadToolCustomCon;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UserInterface;

public class RoadToolCustomUI
extends UserInterface {
    protected RoadToolCustomCon rtc;
    protected boolean sscr;
    protected float seg;

    public RoadToolCustomUI(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.rtc = (RoadToolCustomCon)con;
        this.sscr = this.rtc.size[0] > 8;
        ((UITab)this.tabs.get("left")).visible(this.sscr);
        ((UITab)this.tabs.get("right")).visible(this.sscr);
        ((UITab)this.tabs.get("full0")).visible(this.sscr);
        ((UITab)this.tabs.get("full1")).visible(this.sscr);
        ((UITab)this.tabs.get("full2")).visible(this.sscr);
        ((UITab)this.tabs.get("scroll")).visible(this.sscr);
        ((UIButton)this.buttons.get("scroll_left")).visible(this.sscr);
        ((UIButton)this.buttons.get("scroll_right")).visible(this.sscr);
        this.seg = 162.0f / (float)this.rtc.size[0];
    }

    public void predraw(float ticks, int mx, int my) {
    }

    public void drawbackground(float ticks, int mx, int my) {
        if (!this.sscr) {
            int left = this.gLeft + 88 - this.rtc.offset;
            this.drawer.draw((float)(left - 7), (float)this.gTop, 0, 0, 25, 32);
            if (this.rtc.size[0] == 1) {
                this.drawer.draw((float)(left + 18), (float)this.gTop, 61, 0, 7, 32);
            } else {
                for (int i = 1; i < this.rtc.size[0] - 1; ++i) {
                    this.drawer.draw((float)(left + i * 18), (float)this.gTop, 25, 0, 18, 32);
                }
                this.drawer.draw((float)(left + (this.rtc.size[0] - 1) * 18), (float)this.gTop, 43, 0, 25, 32);
            }
        } else {
            float b = this.seg * (float)this.rtc.scroll;
            float w = this.seg * 9.0f;
            this.drawer.draw((float)(this.gLeft + 7) + b, (float)(this.gTop - 18), 7, 151, (int)w, 6);
            this.drawer.draw((float)this.gLeft + 3.5f + b + w / 2.0f, (float)(this.gTop - 24), 177, 132, 7, 7);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "scroll_left": {
                this.scroll(-1);
                return true;
            }
            case "scroll_right": {
                this.scroll(1);
                return true;
            }
        }
        return false;
    }

    private void scroll(int by) {
        TagCW com = TagCW.create();
        com.set("cargo", "scroll");
        com.set("by", by);
        ContainerInterface.SEND_TO_SERVER.accept(com);
        this.rtc.scroll += by;
        if (this.rtc.scroll < 0) {
            this.rtc.scroll = 0;
        }
        if (this.rtc.scroll + 9 >= this.rtc.size[0]) {
            this.rtc.scroll = this.rtc.size[0] - 9;
        }
    }

    public void scrollwheel(int am, int mx, int my) {
        if (my < this.gTop + 36) {
            this.scroll(am < 0 ? 1 : -1);
        }
    }

    public boolean keytyped(char c, int code) {
        if (code == 1) {
            TagCW com = TagCW.create();
            com.set("ui", UIKeys.ROAD_TOOL.id);
            com.set("pos", V3I.NULL.toIntegerArray());
            Packets.send(Packet_TagListener.class, "open_ui", com);
        }
        return true;
    }

    public boolean onClick(int mx, int my, int mb) {
        if (mb == 0 && mx >= this.gLeft + 7 && mx <= this.gLeft + 169 && my >= this.gTop - 18 && my <= this.gTop - 12) {
            int sg = (int)((float)(mx - this.gLeft - 7) / this.seg);
            if (sg < 0) {
                sg = 0;
            }
            if (sg >= this.rtc.size[0] - 9) {
                sg = this.rtc.size[0] - 9;
            }
            this.scroll(sg - this.rtc.scroll);
            return true;
        }
        return super.onClick(mx, my, mb);
    }

    public void getTooltip(int mx, int my, List<String> list) {
        if (this.rtc.size[0] < 9) {
            return;
        }
        if (((UITab)this.tabs.get("scroll")).hovered(this.gLeft, this.gTop, mx, my)) {
            Object[] objs = new Object[]{this.rtc.scroll + 1, this.rtc.scroll + 9, this.rtc.size[0]};
            list.add((String)ContainerInterface.TRANSFORMAT.apply("ui.fvtm.road_tool_custom.scroll_status", objs));
        }
    }
}

