/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonValue;

public class ZipUtils {
    public static JsonArray getValuesAt(File file, String path, String extension) {
        return ZipUtils.getValuesAt(file, path, extension, 0);
    }

    public static JsonArray getValuesAt(File file, String path, String extension, int limit) {
        JsonArray array = new JsonArray();
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(file);
            ZipInputStream stream = new ZipInputStream(new FileInputStream(file));
            while ((limit <= 0 || array.size() < limit) && (entry = stream.getNextEntry()) != null) {
                if (!entry.getName().startsWith(path) || !entry.getName().endsWith(extension)) continue;
                array.add(JsonHandler.parse((InputStream)stream, (boolean)true));
            }
            stream.close();
            zip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return array;
    }

    public static JsonValue<?> getValueAt(File file, String path, String extension) {
        JsonValue value = null;
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(file);
            ZipInputStream stream = new ZipInputStream(new FileInputStream(file));
            while ((entry = stream.getNextEntry()) != null) {
                if (!entry.getName().startsWith(path) || !entry.getName().endsWith(extension)) continue;
                value = JsonHandler.parse((InputStream)stream, (boolean)true);
            }
            stream.close();
            zip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

