/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.world.MessageSender;
import net.fexcraft.mod.uni.world.MessageSenderI;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ContainerBlock
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static ContainerBlock INSTANCE;

    public ContainerBlock() {
        super(Material.field_151573_f, MapColor.field_151646_E);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(Config.UNBREAKABLE_CONTAINERS ? -1.0f : 8.0f);
        this.func_149752_b(50.0f);
        this.setRegistryName("fvtm:container");
        this.func_149663_c(this.getRegistryName().toString());
        INSTANCE = this;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ContainerEntity();
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185505_j.func_186670_a(pos);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state, 2);
        ((ContainerEntity)world.func_175625_s(pos)).setUp(stack);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            ContainerEntity tile = (ContainerEntity)world.func_175625_s(pos);
            tile.notifyBreak(world, pos, state, true);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ContainerEntity te = (ContainerEntity)world.func_175625_s(pos);
            if (te == null) {
                Print.chat((ICommandSender)player, (String)"No TileEntity found.");
                return true;
            }
            if (!te.isCore() && te.getCorePos() == null) {
                Print.chat((ICommandSender)player, (String)"Linked Core block is null! Removing...");
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                return true;
            }
            ItemStack stack = player.func_184586_b(hand);
            if (Lockable.isKey(FvtmRegistry.getItem(stack.func_77973_b().getRegistryName().toString()))) {
                te.getContainerData().getLock().toggle((MessageSender)new MessageSenderI((ICommandSender)player), UniStack.getStack((Object)stack));
                return true;
            }
            if (te.isLocked()) {
                Print.chat((ICommandSender)player, (String)"Container is Locked.");
                return true;
            }
            if (stack.func_190926_b()) {
                if (te.getCore() == null) {
                    Print.chat((ICommandSender)player, (String)"Container Core couldn't be found.");
                    return true;
                }
                BlockPos corepos = te.getCore().func_174877_v();
                te.sendInvUpdate(player);
                if (te.getContainerData().getInventory().type == InvType.ITEM) {
                    player.openGui((Object)FVTM.getInstance(), 941, world, corepos.func_177958_n(), corepos.func_177956_o(), corepos.func_177952_p());
                } else if (te.getContainerData().getInventory().type == InvType.FLUID) {
                    player.openGui((Object)FVTM.getInstance(), 942, world, corepos.func_177958_n(), corepos.func_177956_o(), corepos.func_177952_p());
                } else {
                    Print.chat((ICommandSender)player, (String)"Currently not supported Inventory Type.");
                }
                return true;
            }
            if (Static.dev()) {
                Print.debug((Object)(te.getContainerData() == null ? "No Container." : te.getContainerData().write(new NBTTagCompound()).toString()));
            }
        }
        return false;
    }

    public static ArrayList<BlockPos> getPositions(ContainerData data, BlockPos pos, EnumFacing facing) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        facing = ContainerBlock.rotate90(facing);
        BlockPos core = new BlockPos((Vec3i)pos);
        int xil = 0;
        int xal = 0;
        int zil = 0;
        int zal = 0;
        boolean ax = facing.func_176740_k() == EnumFacing.Axis.Z;
        switch (data.getContainerType()) {
            case LARGE: {
                xil = ax ? -1 : -6;
                xal = ax ? 2 : 6;
                zil = ax ? -6 : -1;
                zal = ax ? 6 : 2;
                break;
            }
            case MEDIUM: {
                xil = ax ? -1 : -3;
                xal = ax ? 2 : 3;
                zil = ax ? -3 : -1;
                zal = ax ? 3 : 2;
                break;
            }
            case SMALL: {
                xil = ax ? -1 : -1;
                xal = ax ? 2 : 2;
                zil = ax ? -1 : -1;
                zal = ax ? 2 : 2;
                break;
            }
            case TINY: {
                xil = ax ? -1 : -1;
                xal = ax ? 2 : 1;
                zil = ax ? -1 : -1;
                zal = ax ? 1 : 2;
                break;
            }
            case MICRO: {
                xil = ax ? -1 : 0;
                xal = ax ? 2 : 1;
                zil = ax ? 0 : -1;
                zal = ax ? 1 : 2;
                break;
            }
            default: {
                return list;
            }
        }
        for (int x = xil; x < xal; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = zil; z < zal; ++z) {
                    list.add(core.func_177982_a(x, y, z));
                }
            }
        }
        return list;
    }

    public static EnumFacing rotate90(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return EnumFacing.DOWN;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case NORTH: {
                return EnumFacing.EAST;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case UP: {
                return EnumFacing.UP;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175625_s(pos) != null) {
            try {
                ContainerEntity tile = (ContainerEntity)world.func_175625_s(pos);
                return (ItemStack)tile.getContainerData().getNewStack().local();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ItemStack.field_190927_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }
}

