/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block.generated;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.block.BlockUtil;
import net.fexcraft.mod.fvtm.util.SoundTypeHandler;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public abstract class PlainBase
extends net.minecraft.block.Block {
    public final Block type;

    public PlainBase(Block type) {
        super(BlockUtil.getMaterial(type), BlockUtil.getMapColor(type));
        this.type = type;
        this.func_149711_c(type.getHardness());
        this.func_149715_a(type.getLightLevel());
        this.func_149752_b(type.getResistance());
        this.func_149713_g(type.getLightOpacity());
        this.setHarvestLevel(type.getHarverestToolClass(), type.getHarverestToolLevel());
        this.func_149672_a(SoundTypeHandler.parse(type.getSoundTypeId()));
    }

    public boolean func_149730_j(IBlockState state) {
        return this.type.isFullBlock();
    }

    public boolean func_149686_d(IBlockState state) {
        return this.type.isFullCube();
    }

    public boolean func_149662_c(IBlockState state) {
        return this.type == null ? false : this.type.isOpaque();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.type.getCollisionDamage() > 0.0f) {
            entity.func_70097_a(DamageSource.field_76367_g, this.type.getCollisionDamage());
        }
        if (this.type.isWebLike()) {
            entity.func_70110_aj();
        }
    }

    public BlockRenderLayer func_180664_k() {
        return this.type.isCutout() ? BlockRenderLayer.CUTOUT : (this.type.isTranslucent() ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.type.isInvisible() ? EnumBlockRenderType.INVISIBLE : EnumBlockRenderType.MODEL;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        this.addCollisionsToList(state, world, pos, null, aabbs);
        if (aabbs.size() < 2) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>();
        for (AxisAlignedBB aabb : aabbs) {
            RayTraceResult res = this.func_185503_a(pos, start, end, aabb);
            if (res == null) continue;
            list.add(res);
        }
        RayTraceResult result = null;
        double v = 0.0;
        for (RayTraceResult sub : list) {
            double d = sub.field_72307_f.func_72436_e(end);
            if (!(d > v)) continue;
            result = sub;
            v = d;
        }
        return result;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entitybox, List<AxisAlignedBB> boxes, @Nullable Entity entity, boolean isactual) {
        this.addCollisionsToList(state, world, pos, entitybox, boxes);
    }

    protected abstract void addCollisionsToList(IBlockState var1, World var2, BlockPos var3, AxisAlignedBB var4, List<AxisAlignedBB> var5);

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (!player.func_70093_af() && this.type.getFunctions().size() > 0) {
            for (BlockFunction func : this.type.getFunctions()) {
                if (!func.onClick(WrapperHolder.getWorld((Object)world), WrapperHolder.getPos((Object)pos), new V3D((double)hitX, (double)hitY, (double)hitZ), StateWrapper.of((Object)state), WrapperHolder.getSide((Object)side), UniEntity.getEntity((Object)player), hand == EnumHand.MAIN_HAND)) continue;
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return this.type.isLadder();
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return this.type.getPassable() == null ? super.func_176205_b(world, pos) : this.type.getPassable().booleanValue();
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing, IPlantable plant) {
        return this.type.isPlantableOn();
    }
}

