/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class FvtmPlayer
implements Appendable<UniEntity> {
    protected HashMap<VehicleType, String> favtypes = new HashMap();
    protected V3D vehspawnpoint;
    public boolean notified;
    public ArrayList<V3I> longdis = new ArrayList();
    public int segmentation = 16;
    public final EntityW entity;

    public FvtmPlayer(UniEntity ent) {
        this.entity = ent == null ? null : ent.entity;
    }

    public String getFavoriteSpawnSystemFor(VehicleType type) {
        return this.favtypes.get((Object)type);
    }

    public boolean setFavoriteSpawnSystemFor(VehicleType type, String systemid) {
        return this.favtypes.put(type, systemid) == null;
    }

    public void setActiveSpawnPoint(V3D vector) {
        this.vehspawnpoint = vector;
    }

    public V3D getActiveSpawnPoint() {
        return this.vehspawnpoint;
    }

    public void save(UniEntity player, TagCW com) {
        if (this.favtypes.isEmpty()) {
            return;
        }
        TagCW types = TagCW.create();
        for (Map.Entry<VehicleType, String> entry : this.favtypes.entrySet()) {
            if (entry.getValue() == null) continue;
            types.set(entry.getKey().name(), entry.getValue());
        }
        com.set("favtypes", types);
    }

    public void load(UniEntity player, TagCW com) {
        if (com.has("favtypes")) {
            this.favtypes.clear();
            TagCW types = com.getCompound("favtypes");
            for (String key : types.keys()) {
                try {
                    VehicleType type = VehicleType.valueOf(key);
                    this.favtypes.put(type, types.getString(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void copy(UniEntity old, Appendable<UniEntity> app) {
        this.favtypes.putAll(((FvtmPlayer)app).favtypes);
        this.segmentation = ((FvtmPlayer)app).segmentation;
        this.longdis = ((FvtmPlayer)app).longdis;
    }

    public FvtmPlayer create(UniEntity unient) {
        if (!unient.entity.isPlayer()) {
            return null;
        }
        return new FvtmPlayer(unient);
    }

    public String id() {
        return "fvtm:player";
    }

    public RailSystem getRailSystem() {
        return (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, this.entity.getWorld());
    }
}

