/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.content.WireModel;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;

public class WireDeco
extends Content<WireDeco>
implements WithItem {
    protected String type;
    protected IDL texture;
    protected Model model;
    protected ModelData modeldata;
    protected String modelid;
    protected String ctab;
    protected List<String> accepts;

    @Override
    public WireDeco parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Wire Decoration");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.type = map.getString("Type", "relay");
        this.texture = ContentConfigUtil.getTextures(map).get(0);
        this.accepts = ContentConfigUtil.getStringList(map, "Accepts");
        if (this.accepts.isEmpty()) {
            this.accepts.add("universal");
        }
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.ctab = map.getString("CreativeTab", "default");
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.WIREDECO;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, WireModel.class);
    }

    @Override
    public WireModel getModel() {
        return (WireModel)this.model;
    }

    public String getType() {
        return this.type;
    }

    public IDL getTexture() {
        return this.texture;
    }

    public boolean accepts(String wiretype) {
        return this.accepts.contains(wiretype);
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    public List<String> getCompatible() {
        return this.accepts;
    }

    public boolean isRelayType() {
        return this.type.equals("relay");
    }
}

