/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.block.MB_Access;
import net.fexcraft.mod.fvtm.data.block.MB_Interact;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.inv.InvHandlerInit;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class MultiBlock
extends Content<MultiBlock>
implements WithItem,
ItemTextureable {
    private Map<String, InvHandler> inventories = new LinkedHashMap<String, InvHandler>();
    private ArrayList<Map.Entry<IDL, CubeSide>> blocks = new ArrayList();
    private ArrayList<MB_Interact> interact = new ArrayList();
    private ArrayList<MB_Access> access = new ArrayList();
    private ArrayList<V3I> blockpos = new ArrayList();
    private String ctab;
    private IDL itemtexloc;
    private boolean no3ditem;

    @Override
    public MultiBlock parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Block");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        this.no3ditem = map.getBoolean("Disable3DItemModel", false);
        if (map.has("Inventories")) {
            JsonMap invs = map.getMap("Inventories");
            for (Map.Entry entry : invs.entries()) {
                JsonArray array = ((JsonValue)entry.getValue()).asArray();
                InvHandlerInit handler = new InvHandlerInit(InvType.parse(array.get(0).string_value()));
                ((InvHandler)handler).setCapacity(array.get(1).integer_value());
                if (array.size() > 2) {
                    ((InvHandler)handler).setArg(array.get(2).string_value());
                }
                this.inventories.put((String)entry.getKey(), handler);
            }
        }
        V3I core = null;
        if (map.has("Core")) {
            core = new V3I(map.getArray("Core").toIntegerArray(), 0);
        }
        if (map.has("Blocks") && map.has("Pattern")) {
            ArrayList<Map.Entry<Character, V3I>> list = new ArrayList<Map.Entry<Character, V3I>>();
            JsonArray array = map.getArray("Pattern");
            int x = 0;
            for (JsonValue val : (List)array.value) {
                if (val.isArray()) {
                    int y = 0;
                    for (JsonValue jsonValue : (List)val.asArray().value) {
                        this.parsePattern(list, x, y, jsonValue.string_value());
                    }
                } else {
                    this.parsePattern(list, 0, x, val.string_value());
                }
                ++x;
            }
            HashMap<Character, IDL> blkmap = new HashMap<Character, IDL>();
            HashMap<Character, CubeSide> sidemap = new HashMap<Character, CubeSide>();
            JsonMap blks = map.getMap("Blocks");
            for (Map.Entry entry : blks.entries()) {
                char key = ((String)entry.getKey()).charAt(0);
                if (((JsonValue)entry.getValue()).isArray()) {
                    JsonArray arr = ((JsonValue)entry.getValue()).asArray();
                    blkmap.put(Character.valueOf(key), IDLManager.getIDLCached((String)arr.get(0).string_value()));
                    CubeSide side = CubeSide.NORTH;
                    side = arr.get(1).isNumber() ? CubeSide.fromIndex((int)arr.get(1).integer_value(), (CubeSide)CubeSide.NORTH) : CubeSide.valueOf((String)arr.get(1).string_value().toUpperCase());
                    sidemap.put(Character.valueOf(key), side);
                    continue;
                }
                blkmap.put(Character.valueOf(key), IDLManager.getIDLCached((String)((JsonValue)entry.getValue()).string_value()));
                sidemap.put(Character.valueOf(key), CubeSide.NORTH);
            }
            for (Map.Entry entry : list) {
                if (!blkmap.containsKey(entry.getKey())) continue;
                V3I pos = ((V3I)entry.getValue()).sub(core);
                this.blocks.add(new AbstractMap.SimpleEntry(blkmap.get(entry.getKey()), sidemap.get(entry.getKey())));
                this.blockpos.add(new V3I(pos.z, pos.y, pos.x));
            }
        }
        if (map.has("Interact")) {
            for (JsonValue val : (List)map.getArray((String)"Interact").value) {
                try {
                    this.interact.add(new MB_Interact(val.asArray(), core));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "MultiBlock Interact Parse / " + this.id);
                }
            }
        }
        if (map.has("Access")) {
            for (JsonValue val : (List)map.getArray((String)"Access").value) {
                try {
                    this.access.add(new MB_Access(val.asArray(), core));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "MultiBlock Access Parse " + this.id);
                }
            }
        }
        return this;
    }

    private void parsePattern(ArrayList<Map.Entry<Character, V3I>> list, int height, int row, String string) {
        char[] arr = string.toCharArray();
        for (int c = 0; c < arr.length; ++c) {
            if (arr[c] == ' ') continue;
            list.add(new AbstractMap.SimpleEntry<Character, V3I>(Character.valueOf(arr[c]), new V3I(row, height, c)));
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.MULTIBLOCK;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public boolean noCustomItemModel() {
        return this.no3ditem;
    }

    public ArrayList<V3I> getPositions(V3I core, CubeSide side) {
        ArrayList<V3I> list = new ArrayList<V3I>();
        int rots = this.getRotations(side, false);
        for (V3I pos : this.blockpos) {
            list.add(core.add(pos.rotate(rots)));
        }
        return list;
    }

    private int getRotations(CubeSide side, boolean counter) {
        switch (side) {
            case EAST: {
                return counter ? 3 : 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return counter ? 1 : 3;
            }
        }
        return 0;
    }

    public static CubeSide rotate(CubeSide side, CubeSide by) {
        if (side.axe() == CubeSide.Axe.Y) {
            return side;
        }
        switch (by) {
            case EAST: {
                return side.rotate();
            }
            case SOUTH: {
                return side.rotate().rotate();
            }
            case WEST: {
                return side.rotateCC();
            }
        }
        return side;
    }

    public static CubeSide rotate(CubeSide side, Object by) {
        return MultiBlock.rotate(side, WrapperHolder.getSide((Object)by));
    }

    public static CubeSide rotate(Object side, Object by) {
        return MultiBlock.rotate(WrapperHolder.getSide((Object)side), WrapperHolder.getSide((Object)by));
    }

    public List<MB_Interact> getInteract(CubeSide side, V3I pos, V3I core) {
        pos = core.sub(pos);
        pos = pos.add(0, -pos.y * 2, 0);
        V3I rpos = pos = pos.rotate(this.getRotations(side, true));
        return this.interact.stream().filter(trigger -> trigger.getPos().equals((Object)rpos)).collect(Collectors.toList());
    }

    public Map<String, InvHandler> getDefInventories() {
        return this.inventories;
    }

    public ArrayList<Map.Entry<IDL, CubeSide>> getBlocks() {
        return this.blocks;
    }

    public ArrayList<MB_Access> getAccess() {
        return this.access;
    }
}

