/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.FvtmPlayer;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.fexcraft.mod.uni.world.WorldW;

public abstract class EntitySystem {
    public static HashMap<String, EntitySystem> REGISTRY = new HashMap();

    public abstract String getId();

    public abstract String getName();

    public abstract void spawn(MessageSender var1, WorldW var2, V3D var3, VehicleData var4, StackWrapper var5);

    public abstract boolean canSpawn(MessageSender var1, WorldW var2, V3D var3, VehicleData var4, StackWrapper var5);

    public abstract boolean validFor(VehicleType var1);

    public static final void spawnVehicle(MessageSender placer, WorldW world, V3D pos, VehicleData data, StackWrapper stack) {
        EntitySystem sel;
        String pref = null;
        FvtmPlayer pd = null;
        if (placer instanceof EntityW && (pd = (FvtmPlayer)UniEntity.get((Object)((EntityW)placer).local()).getApp(FvtmPlayer.class)) != null) {
            pref = pd.getFavoriteSpawnSystemFor(((Vehicle)data.getType()).getVehicleType());
        }
        if ((sel = REGISTRY.get(pref)) != null && sel.canSpawn(placer, world, pos, data, stack)) {
            sel.spawn(placer, world, pos, data, stack);
            return;
        }
        ArrayList<String> valid = EntitySystem.getValidFor(((Vehicle)data.getType()).getVehicleType());
        if (valid.isEmpty()) {
            placer.send("&cNo Spawn systems for this type available.");
            placer.send("&bType: " + (Object)((Object)((Vehicle)data.getType()).getVehicleType()) + "/" + data.getName());
            return;
        }
        if (valid.size() == 1) {
            sel = REGISTRY.get(valid.get(0));
            if (sel.canSpawn(placer, world, pos, data, stack)) {
                sel.spawn(placer, world, pos, data, stack);
            }
            return;
        }
        if (pd != null) {
            pd.setActiveSpawnPoint(pos);
            pd.entity.openUI(UIKeys.ENTITY_SYSTEM_CHOOSE, ((Vehicle)data.getType()).getVehicleType().ordinal(), 0, 0);
        } else {
            placer.send("&cThere are multiple spawn systems to choose from.");
            placer.send("&cPlease try spawning as player or choose a system beforehand.");
        }
    }

    public static ArrayList<String> getValidFor(VehicleType type) {
        ArrayList<String> found = new ArrayList<String>();
        for (Map.Entry<String, EntitySystem> sys : REGISTRY.entrySet()) {
            if (!sys.getValue().validFor(type)) continue;
            found.add(sys.getKey());
        }
        return found;
    }

    public static void add(EntitySystem sys) {
        REGISTRY.put(sys.getId(), sys);
    }
}

