/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.sys.particle.Particle;
import org.lwjgl.opengl.GL11;

public class ParticleEntity {
    public final Particle particle;
    public V3D pos;
    public V3D prev;
    public V3D temp;
    public V3D dir;
    public double percent;
    public double scale;
    public double speed;
    public RGB color;
    public int passed;

    public ParticleEntity(Particle part, V3D pos, V3D dir, Double speed) {
        this.particle = part;
        this.pos = pos;
        this.prev = new V3D(pos);
        this.temp = new V3D();
        this.dir = dir == null ? part.dir : dir;
        this.speed = speed == null ? (double)part.speed : speed;
        this.percent = 0.0;
        this.scale = this.particle.scale;
        this.color = new RGB(this.particle.color);
        if (this.particle.alpha == -1.0f) {
            this.color.alpha = Static.random.nextFloat();
        }
    }

    public void setDirSpeed(V3D dir, float speed) {
        this.dir = dir;
        this.speed = speed;
    }

    public void render(float ticks, double cx, double cy, double cz) {
        this.temp.x = this.pos.x;
        this.temp.y = this.pos.y;
        this.temp.z = this.pos.z;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.temp.x - cx), (double)(this.temp.y - cy), (double)(this.temp.z - cz));
        this.color.glColorApply();
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        this.particle.model.render();
        RGB.glColorReset();
        GL11.glPopMatrix();
    }

    public void update() {
        this.prev = this.pos;
        this.pos = new V3D();
        double x = (Static.random.nextDouble() - 0.5) / 50.0;
        double z = (Static.random.nextDouble() - 0.5) / 50.0;
        this.pos.x = this.prev.x + this.dir.x * this.speed + x;
        this.pos.y = this.prev.y + this.dir.y * this.speed;
        this.pos.z = this.prev.z + this.dir.z * this.speed + z;
        this.percent = this.passed / this.particle.persistence;
        if (this.particle.scale_to > 0.0f) {
            this.scale = (double)this.particle.scale + (double)(this.particle.scale_to - this.particle.scale) * this.percent;
        }
        if (this.particle.color_to != null) {
            this.color.packed = this.mix(this.particle.color, this.particle.color_to, (float)this.percent);
        }
        if (this.particle.alpha >= 0.0f && this.particle.alpha_to != this.particle.alpha) {
            this.color.alpha = (float)((double)this.particle.alpha + (double)(this.particle.alpha_to - this.particle.alpha) * this.percent);
        }
        ++this.passed;
    }

    public int mix(RGB base, RGB mix, float percent) {
        float[] fl = base.toFloatArray();
        float[] f1 = mix.toFloatArray();
        int r = (int)((fl[0] + (f1[0] - fl[0]) * percent) * 256.0f);
        int g = (int)((fl[1] + (f1[1] - fl[1]) * percent) * 256.0f);
        int b = (int)((fl[2] + (f1[2] - fl[2]) * percent) * 256.0f);
        int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
        int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
        b = b > 255 ? 255 : (b < 0 ? 0 : b);
        return 65536 * r + 256 * g + b;
    }

    public boolean expired() {
        return this.passed >= this.particle.persistence;
    }
}

