/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.block;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.data.block.CraftBlockScript;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.gui.block.GBlockCraftChooseContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class GBlockCraftChoose
extends GenericGui<GBlockCraftChooseContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/block_craftscript_choose_recipe.png");
    public CraftBlockScript.Recipe[] recipes = new CraftBlockScript.Recipe[16];
    private int hovered = -1;
    private ArrayList<String> hoverlines = new ArrayList();

    public GBlockCraftChoose(EntityPlayer player, World world, int x, int y, int z) {
        super(texture, (GenericContainer)new GBlockCraftChooseContainer(player, world, x, y, z), player);
        this.defbackground = true;
        this.deftexrect = true;
        ((GBlockCraftChooseContainer)this.container).gui = this;
        this.field_146999_f = 256;
        this.field_147000_g = 246;
    }

    protected void init() {
        this.texts.put("top", new GenericGui.BasicText(this.field_147003_i + 7, this.field_147009_r + 6, 192, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "loading...."));
        this.texts.put("page", new GenericGui.BasicText(this.field_147003_i + 203, this.field_147009_r + 6, 28, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "1/pg"));
        this.buttons.put("prev", new GenericGui.BasicButton("prev", this.field_147003_i + 233, this.field_147009_r + 6, 233, 6, 8, 8, true));
        this.buttons.put("next", new GenericGui.BasicButton("next", this.field_147003_i + 242, this.field_147009_r + 6, 242, 6, 8, 8, true));
        for (int i = 0; i < 16; ++i) {
            this.texts.put("t_" + i, new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 19 + i * 14, 238, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "loading...").autoscale());
            this.buttons.put("b_" + i, new GenericGui.BasicButton("b_" + i, this.field_147003_i + 7, this.field_147009_r + 17 + i * 14, 7, 17 + i * 14, 242, 12, true));
        }
        this.loadRecipes();
    }

    private void loadRecipes() {
        ArrayList<CraftBlockScript.Recipe> recipes = CraftBlockScript.SORTED_REGISTRY.get(((MultiBlock)((GBlockCraftChooseContainer)this.container).tile.getMultiBlockData().getType()).getIDS());
        for (int i = 0; i < 16; ++i) {
            int j = i + 16 * ((GBlockCraftChooseContainer)this.container).page;
            if (recipes == null || j >= recipes.size()) {
                ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"t_").append((int)i).toString())).string = "";
                ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"b_").append((int)i).toString())).enabled = false;
                this.recipes[i] = null;
                continue;
            }
            ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"t_").append((int)i).toString())).string = recipes.get(j).id();
            ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"b_").append((int)i).toString())).enabled = true;
            this.recipes[i] = recipes.get(j);
        }
        if (recipes == null) {
            ((GenericGui.BasicText)this.texts.get((Object)"t_0")).string = "No recipes for block found.";
        }
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
        if (((GBlockCraftChooseContainer)this.container).tile != null) {
            ((GenericGui.BasicText)this.texts.get((Object)"top")).string = ((MultiBlock)((GBlockCraftChooseContainer)this.container).tile.getMultiBlockData().getType()).getName();
        }
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        int newhovered = -1;
        for (int i = 0; i < this.recipes.length; ++i) {
            if (!((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"b_").append((int)i).toString())).hovered) continue;
            newhovered = i;
            break;
        }
        if (newhovered != this.hovered) {
            this.hovered = newhovered;
            this.loadHoverlines();
        }
    }

    private void loadHoverlines() {
        String name;
        this.hoverlines.clear();
        if (this.hovered < 0 || this.recipes[this.hovered] == null) {
            return;
        }
        CraftBlockScript.Recipe recipe = this.recipes[this.hovered];
        for (CraftBlockScript.InputWrapper inputWrapper : recipe.getInputs()) {
            name = inputWrapper.fluid == null ? (inputWrapper.oreid == null ? (inputWrapper.ingredient == null ? "ERROR;NULL" : "I; " + inputWrapper.ingredient.func_193365_a()[0].func_82833_r()) : "O; " + inputWrapper.oreid) : inputWrapper.fluid.getLocalizedName();
            this.hoverlines.add(Formatter.format((String)"&4- %s&7x&c%s &7-> &c%s", (Object[])new Object[]{inputWrapper.amount, name, CraftBlockScript.getInvId(((GBlockCraftChooseContainer)this.container).tile.getMultiBlockData(), inputWrapper.getInputType().toInventory(), inputWrapper.inventory, "input")}));
        }
        for (Map.Entry entry : recipe.getConsume().entrySet()) {
            this.hoverlines.add(Formatter.format((String)"&b- &3%s &7-> &3%s", (Object[])new Object[]{entry.getValue(), entry.getKey()}));
        }
        for (CraftBlockScript.OutputWrapper outputWrapper : recipe.getOutput()) {
            name = outputWrapper.fluid == null ? outputWrapper.stack.func_82833_r() : outputWrapper.fluid.getLocalizedName();
            this.hoverlines.add(Formatter.format((String)"&a+ %s&7x&2%s &7-> &a%s", (Object[])new Object[]{outputWrapper.amount(), name, CraftBlockScript.getInvId(((GBlockCraftChooseContainer)this.container).tile.getMultiBlockData(), outputWrapper.getInventoryType(), outputWrapper.inventory, "output")}));
        }
    }

    public void func_146976_a(float pticks, int mouseX, int mouseY) {
        super.func_146976_a(pticks, mouseX, mouseY);
        if (this.hovered >= 0 && !this.hoverlines.isEmpty()) {
            this.func_146283_a(this.hoverlines, this.field_147003_i + 7 + 64, this.field_147009_r + 17 + this.hovered * 14);
            this.field_146297_k.func_110434_K().func_110577_a(this.texloc);
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("prev")) {
            this.updatePage(-1);
            return true;
        }
        if (button.name.equals("next")) {
            this.updatePage(1);
            return true;
        }
        if (button.name.startsWith("b_")) {
            int i = Integer.parseInt(button.name.substring(2));
            if (this.recipes[i] == null) {
                return false;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "choose");
            compound.func_74778_a("recipe", this.recipes[i].id());
            ((GBlockCraftChooseContainer)this.container).send(Side.SERVER, compound);
            return true;
        }
        return false;
    }

    protected void scrollwheel(int am, int x, int y) {
        this.updatePage(am > 0 ? 1 : -1);
    }

    private void updatePage(int i) {
        ((GBlockCraftChooseContainer)this.container).page += i;
        if (((GBlockCraftChooseContainer)this.container).page < 0) {
            ((GBlockCraftChooseContainer)this.container).page = 0;
        }
        ((GenericGui.BasicText)this.texts.get((Object)"page")).string = ((GBlockCraftChooseContainer)this.container).page + 1 + "/pg";
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cargo", "page");
        compound.func_74768_a("page", ((GBlockCraftChooseContainer)this.container).page);
        ((GBlockCraftChooseContainer)this.container).send(Side.SERVER, compound);
        this.loadRecipes();
    }
}

