/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.vehicle;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.container.ContainerHolder;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.gui.vehicle.VehicleContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class VehicleContainers
extends GenericGui<VehicleContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/vehicle_inventories.png");
    private String containers;
    private RGB[] colors = new RGB[8];
    private String[] inv_names;
    private Entity entity;
    private int page;

    public VehicleContainers(EntityPlayer player, World world, int x, int y, int z) {
        super(texture, (GenericContainer)new VehicleContainer(player, world, x, y, z), player);
        this.defbackground = true;
        this.deftexrect = true;
        ((VehicleContainer)this.container).gui = this;
        this.field_146999_f = 194;
        this.field_147000_g = 134;
        this.entity = world.func_73045_a(y);
        this.inv_names = ((ContainerHolder)this.entity.getCapability(Capabilities.CONTAINER, null)).getContainerSlotIds();
        for (int i = 0; i < 8; ++i) {
            this.colors[i] = InvType.CONTAINER.color;
        }
        this.containers = I18n.func_135052_a((String)"gui.fvtm.vehicle.container.containers", (Object[])new Object[0]);
    }

    protected void init() {
        this.texts.put("top", new GenericGui.BasicText(this.field_147003_i + 7, this.field_147009_r + 6, 162, Integer.valueOf(MapColor.field_151666_j.field_76291_p), this.containers + " [-/-]"));
        for (int i = 0; i < 8; ++i) {
            this.texts.put("row" + i, new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 19 + i * 14, 162, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "<---->"));
            this.buttons.put("inv" + i, new GenericGui.BasicButton("inv" + i, this.field_147003_i + 7, this.field_147009_r + 17 + i * 14, 7, 17, 166, 12, true));
        }
        this.buttons.put("prev", new GenericGui.BasicButton("prev", this.field_147003_i + 171, this.field_147009_r + 6, 171, 6, 8, 8, true));
        this.buttons.put("next", new GenericGui.BasicButton("next", this.field_147003_i + 180, this.field_147009_r + 6, 180, 6, 8, 8, true));
        this.updatePage(0);
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        for (int i = 0; i < 8; ++i) {
            this.colors[i].glColorApply();
            this.func_73729_b(this.field_147003_i + 175, this.field_147009_r + 17 + 14 * i, 175, 17 + 14 * i, 12, 12);
            RGB.glColorReset();
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("prev")) {
            this.updatePage(-1);
            return true;
        }
        if (button.name.equals("next")) {
            this.updatePage(1);
            return true;
        }
        if (button.name.startsWith("inv")) {
            int i = Integer.parseInt(button.name.replace("inv", ""));
            if (i < 0 || i + this.page * 8 >= this.inv_names.length) {
                return true;
            }
            VehicleContainers.openGui((int)938, (int[])new int[]{938, this.entity.func_145782_y(), i + this.page * 8}, (String)"fvtm:gui");
            return true;
        }
        return false;
    }

    protected void scrollwheel(int am, int x, int y) {
        this.updatePage(am > 0 ? -1 : 1);
    }

    private void updatePage(int i) {
        this.page += i;
        if (this.page < 0) {
            this.page = 0;
        }
        ((GenericGui.BasicText)this.texts.get((Object)"top")).string = String.format(this.containers + " [%s/%s]", this.page + 1, this.inv_names.length / 8 + 1);
        for (int j = 0; j < 8; ++j) {
            int k = j + this.page * 8;
            boolean bool = k >= this.inv_names.length;
            ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"row").append((int)j).toString())).string = bool ? "" : this.inv_names[k];
            ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"inv").append((int)j).toString())).enabled = !bool;
        }
    }
}

