/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Consumable;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.uni.EnvInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConsumableItem
extends ItemFood
implements ContentItem<Consumable>,
ItemTextureable.TextureableItem<Consumable> {
    private Consumable consumable;

    public ConsumableItem(Consumable consumable) {
        super(consumable.getHealAmount(), consumable.isAlwaysEdible());
        this.consumable = consumable;
        this.func_77625_d(consumable.getMaxStack());
        this.func_77627_a(true);
        this.setRegistryName(consumable.getID().colon());
        this.func_77655_b(consumable.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(consumable));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.consumable.getName())));
        for (String s : this.consumable.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        tooltip.add(Formatter.format((String)("&9Type: &7" + (this.consumable.isDrinkable() ? "drink/beverage" : "food"))));
        tooltip.add(Formatter.format((String)("&9Heal Amout: &7" + this.consumable.getHealAmount())));
        tooltip.add(Formatter.format((String)("&9Saturation: &7" + this.consumable.getSaturation())));
        if (this.consumable.isWolfFood()) {
            tooltip.add(Formatter.format((String)"&9&oLiked by wolves."));
        }
        if (this.consumable.isAlwaysEdible()) {
            tooltip.add(Formatter.format((String)("&8&oAlways " + (this.consumable.isDrinkable() ? "drinkable" : "edible") + ".")));
        }
        if (this.consumable.getOreDictId() != null) {
            tooltip.add(Formatter.format((String)("&9OreDict: &7" + this.consumable.getOreDictId())));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            items.add(this.consumable.getNewStack().local());
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.consumable.isDrinkable() ? EnumAction.DRINK : EnumAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return this.consumable.getItemUseDuration();
    }

    public boolean func_77845_h() {
        return this.consumable.isWolfFood();
    }

    public int func_150905_g(ItemStack stack) {
        return this.consumable.getHealAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return this.consumable.getSaturation();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_71043_e(this.consumable.isAlwaysEdible())) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    @Override
    public Consumable getContent() {
        return this.consumable;
    }

    @Override
    public ContentType getType() {
        return ContentType.CONSUMABLE;
    }
}

