/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.ContainerBlock;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.VehicleAndPartDataCache;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerItem
extends Item
implements ContentItem.ContentDataItem<Container, ContainerData>,
ItemTextureable.TextureableItem<Container> {
    private Container container;

    public ContainerItem(Container con) {
        this.container = con;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setRegistryName(this.container.getID().colon());
        this.func_77655_b(this.container.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.container));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        VehicleAndPartDataCache cache = (VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null);
        if (!cache.overridesLang(false)) {
            tooltip.add(Formatter.format((String)("&9Name: &7" + this.container.getName())));
        }
        for (String s : this.container.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        ContainerData data = cache.getContainerData();
        if (data == null) {
            return;
        }
        tooltip.add(Formatter.format((String)("&9Texture: &7" + this.getTexTitle(data))));
        tooltip.add(Formatter.format((String)("&9Type: &7" + this.container.getContainerType().name())));
        tooltip.add(Formatter.format((String)("&9Capacity: &7" + (((Container)data.getType()).getInventoryType() == InvType.FLUID ? ((Container)data.getType()).getCapacity() / 1000 : ((Container)data.getType()).getCapacity()) + " " + ((Container)data.getType()).getInventoryType().unit_suffix)));
        tooltip.add(Formatter.format((String)("&9Content: &7" + data.getInventory().getContentDesc())));
        if (data.getInventory().getFilter() != null) {
            tooltip.add(Formatter.format((String)("&9Content Filter: &7" + data.getInventory().getFilter().id())));
        }
        tooltip.add(Formatter.format((String)("&9LockCode: &7" + data.getLock().getCode())));
    }

    private String getTexTitle(ContainerData data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + ((Container)data.getType()).getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public ContainerData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public ContainerData getData(TagCW compound) {
        return new ContainerData(this.container).read(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            items.add(this.container.getNewStack().local());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos core;
        if (world.field_72995_K || side != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        ContainerData data = ((VehicleAndPartDataCache)player.func_184586_b(hand).getCapability(Capabilities.VAPDATA, null)).getContainerData();
        BlockPos blockPos = core = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177982_a(0, 1, 0);
        if (ContainerItem.isValidPostitionForContainer(world, player, core, player.func_174811_aO(), data)) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74772_a("PlacedPos", core.func_177986_g());
            ContainerBlock.getPositions(data, core, player.func_174811_aO()).forEach(blkpos -> {
                IBlockState state = ContainerBlock.INSTANCE.func_176223_P();
                state.func_177230_c().func_180633_a(world, blkpos, state.func_177226_a((IProperty)ContainerBlock.FACING, (Comparable)player.func_174811_aO()), (EntityLivingBase)player, stack);
            });
            stack.func_190918_g(64);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static boolean isValidPostitionForContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing opposite, ContainerData data) {
        ArrayList<BlockPos> list = ContainerBlock.getPositions(data, pos, opposite);
        BlockPos obstacle = null;
        IBlockState state = null;
        for (BlockPos blkpos : list) {
            state = world.func_180495_p(blkpos);
            if (state.func_177230_c().func_176200_f((IBlockAccess)world, blkpos)) continue;
            obstacle = blkpos;
            break;
        }
        if (obstacle != null) {
            Print.bar((EntityPlayer)player, (String)String.format("Obstacle at position: %sx, %sy, %sz!", obstacle.func_177958_n(), obstacle.func_177956_o(), obstacle.func_177952_p()));
            return false;
        }
        return true;
    }

    @Override
    public ContentType getType() {
        return ContentType.CONTAINER;
    }

    @Override
    public Container getContent() {
        return this.container;
    }
}

