/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RailGaugeItem
extends Item
implements ContentItem<RailGauge>,
JunctionGridItem {
    private RailGauge gauge;

    public RailGaugeItem(RailGauge type) {
        this.gauge = type;
        this.func_77627_a(true);
        this.setRegistryName(this.gauge.getID().colon());
        this.func_77655_b(this.gauge.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.gauge));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        for (String s : this.gauge.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        tooltip.add(Formatter.format((String)I18n.func_135052_a((String)"item.fvtm.railgauge.width", (Object[])new Object[]{Float.valueOf(this.gauge.getWidth())})));
        if (this.gauge.getCompatible().size() > 0) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)"item.fvtm.railgauge.compatible", (Object[])new Object[0])));
            for (String str : this.gauge.getCompatible()) {
                tooltip.add(Formatter.format((String)("- " + str)));
            }
        }
        if (this.gauge.getMaterials().size() > 0) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)"item.fvtm.railgauge.materials", (Object[])new Object[0])));
            for (RailGauge.UseMat mat : this.gauge.getMaterials()) {
                tooltip.add(Formatter.format((String)("- " + (mat.tag ? "#" : "") + mat.id + " x" + mat.amount)));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || Config.DISABLE_RAILS) {
            return EnumActionResult.PASS;
        }
        RailSystem syscap = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world));
        if (syscap == null) {
            Print.chat((ICommandSender)player, (String)"&cWorld Capability not found.");
            return EnumActionResult.FAIL;
        }
        QV3D vector = new QV3D((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        RailPlacingUtil.place(syscap, UniEntity.getEntity((Object)player), this.gauge, vector);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public RailGauge getContent() {
        return this.gauge;
    }

    @Override
    public ContentType getType() {
        return ContentType.RAILGAUGE;
    }
}

