/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.render.VehicleRenderer;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderRV
extends Render<RootVehicle>
implements IRenderFactory<RootVehicle> {
    private SeparateRenderCache.SepVehCache sepcache;

    public RenderRV(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.5f;
    }

    public void doRender(RootVehicle rv, double x, double y, double z, float entity_yaw, float ticks) {
        if (Config.RENDER_VEHICLES_SEPARATELY || rv.vehicle.data == null || rv.vehicle.point == null) {
            return;
        }
        if (rv.vehicle.cache == null) {
            rv.vehicle.cache = (RenderCache)rv.getCapability(Capabilities.RENDERCACHE, null);
        }
        this.sepcache = rv.vehicle.cache.get(SeparateRenderCache.SEP_VEH_CACHE, data -> new SeparateRenderCache.SepVehCache());
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        V3D rot = EffectRenderer.getRotations(rv, ticks);
        GL11.glRotated((double)(-rot.x), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rot.y, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rot.z, (double)0.0, (double)0.0, (double)1.0);
        this.sepcache.set(x, y, z, rot);
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            RootVehicle veh;
            RootVehicle rootVehicle = veh = Static.getServer().func_71264_H() ? (RootVehicle)Static.getServer().func_71218_a(rv.field_71093_bK).func_73045_a(rv.func_145782_y()) : rv;
            if (veh == null) {
                veh = rv;
            }
            GL11.glPushMatrix();
            TexUtil.bindTexture(rv.vehicle.data.getCurrentTexture());
            GL11.glTranslatef((float)0.0f, (float)2.0f, (float)0.0f);
            EffectRenderer.drawString(veh.vehicle.pivot().deg_yaw() + "", 0.0, 0.0, 0.0, true, true, 0.8f, 0, null);
            GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            EffectRenderer.drawString(veh.vehicle.pivot().deg_pitch() + "", 0.0, 0.0, 0.0, true, true, 0.8f, 0, null);
            GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            EffectRenderer.drawString(veh.vehicle.pivot().deg_roll() + "", 0.0, 0.0, 0.0, true, true, 0.8f, 0, null);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        Model vehmod = ((Vehicle)rv.vehicle.data.getType()).getModel();
        if (vehmod != null) {
            GL11.glPushMatrix();
            TexUtil.bindTexture(rv.vehicle.data.getCurrentTexture());
            vehmod.render(DefaultModel.RENDERDATA.set(rv.vehicle, ticks).rc(rv.vehicle.cache));
            GL11.glPopMatrix();
        } else {
            DebugUtils.renderBB(0.5f, RGB.RED.packed);
        }
        if (rv.vehicle.data.getParts().size() > 0) {
            VehicleRenderer.renderPoint(rv.vehicle.point, rv, rv.vehicle.data, rv.vehicle.cache, ticks);
        }
        EffectRenderer.renderVehicleInfo(rv.vehicle, rv.vehicle.entity.getPos(), rv.vehicle.data);
        GL11.glPopMatrix();
        EffectRenderer.renderToggableInfo(rv, rv.vehicle.data);
        EffectRenderer.renderSeatsAndInvs(rv.vehicle);
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(RootVehicle entity) {
        return (ResourceLocation)entity.vehicle.data.getCurrentTexture().local();
    }

    public Render<RootVehicle> createRenderFor(RenderManager manager) {
        return new RenderRV(manager);
    }
}

