/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.WireDecoItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.render.UniWireRenderer;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.util.Command;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class WireRenderer {
    protected static final ModelRendererTurbo model = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 2.0f, 6, 6, 1, 1).setLines(new RGB(56831));
    protected static final ModelRendererTurbo model0 = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32).setTextured(false).setColor(new RGB(245, 234, 128));
    protected static final ModelRendererTurbo model1 = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32).setTextured(false).setColor(new RGB(123, 245, 126));
    protected static final ModelRendererTurbo[] all;
    private static WireSystem wiredata;
    private static ItemStack held;
    private static boolean holding_wire;
    private static boolean holding_slack;
    private static boolean holding_relaydeco;
    private static boolean holding_deco;
    private static V3D cubepos;

    public static void renderWires(World world, double cx, double cy, double cz, float partialticks) {
        if (Config.DISABLE_WIRES) {
            return;
        }
        wiredata = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)world));
        if (wiredata == null || wiredata.getRegions() == null) {
            return;
        }
        held = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        holding_wire = Command.OTHER || held.func_77973_b() instanceof WireItem || held.func_77973_b() instanceof ToolboxItem && ToolboxType.WIRE_REMOVAL.eq(held.func_77952_i());
        boolean bl = holding_slack = Command.OTHER || held.func_77973_b() instanceof ToolboxItem && ToolboxType.WIRE_SLACK.eq(held.func_77952_i());
        if (held.func_77973_b() instanceof WireDecoItem) {
            WireDecoItem item = (WireDecoItem)held.func_77973_b();
            holding_relaydeco = item.getContent().getType().equals("relay");
            holding_deco = !holding_relaydeco;
        } else {
            holding_deco = false;
            holding_relaydeco = false;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SystemRegion reg : wiredata.getRegions().values()) {
            for (RelayHolder holder : reg.getObjects().values()) {
                for (WireRelay relay : holder.relays.values()) {
                    if (!RenderView.FRUSTUM.func_78546_a((AxisAlignedBB)relay.getAABB().local())) continue;
                    if (Command.OTHER || holding_wire) {
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(relay.pos.x - cx), (double)(relay.pos.y - cy), (double)(relay.pos.z - cz));
                        DebugUtils.renderBB(holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_CYN);
                        GL11.glPopMatrix();
                    }
                    if (relay.wires.size() > 0) {
                        if (holding_slack || holding_deco) {
                            for (Wire wire : relay.wires) {
                                if (wire.copy) continue;
                                cubepos = wire.getVectorPosition((double)wire.length * 0.5, false);
                                GL11.glPushMatrix();
                                GL11.glTranslated((double)(WireRenderer.cubepos.x - cx), (double)(WireRenderer.cubepos.y - cy), (double)(WireRenderer.cubepos.z - cz));
                                DebugUtils.renderBB(holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_CYN);
                                GL11.glPopMatrix();
                            }
                        }
                        if (holding_relaydeco) {
                            for (Wire wire : relay.wires) {
                                cubepos = wire.getVectorPosition(holder.hasRef() ? (double)(holder.ref().getSize(relay.getKey()) * 2.0f) : 0.25, false);
                                GL11.glPushMatrix();
                                GL11.glTranslated((double)(WireRenderer.cubepos.x - cx), (double)(WireRenderer.cubepos.y - cy), (double)(WireRenderer.cubepos.z - cz));
                                DebugUtils.renderBB(holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_CYN);
                                GL11.glPopMatrix();
                            }
                        }
                    }
                    if (Command.OTHER) {
                        WireRenderer.renderDebugRelay(relay, cx, cy, cz);
                        continue;
                    }
                    UniWireRenderer.renderRelay(relay, cx, cy, cz);
                }
            }
        }
        GL11.glPopMatrix();
    }

    private static void renderDebugRelay(WireRelay relay, double cx, double cy, double cz) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int o = 0; o < relay.wires.size(); ++o) {
            Wire conn = relay.wires.get(o);
            if (conn.vecpath == null) {
                return;
            }
            float flfl = conn.copy ? 1.0f : 0.0f;
            float glgl = conn.copy ? 0.0f : 1.0f;
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            for (int j = 0; j < conn.vecpath.length - 1; ++j) {
                V3D vec0 = conn.vecpath[j];
                V3D vec1 = conn.vecpath[j + 1];
                bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b(vec0.x - cx, vec0.y + (double)(conn.copy ? 0.1f : 0.0f) - cy, vec0.z - cz).func_181666_a(0.0f, glgl, flfl, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(vec1.x - cx, vec1.y + (double)(conn.copy ? 0.1f : 0.0f) - cy, vec1.z - cz).func_181666_a(0.0f, glgl, flfl, 1.0f).func_181675_d();
                tessellator.func_78381_a();
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
        }
    }

    static {
        for (ModelRendererTurbo turbo : all = new ModelRendererTurbo[]{model, model0, model1}) {
            for (TexturedPolygon poly : turbo.getFaces()) {
                poly.setColor(turbo.polygonColor);
            }
        }
    }
}

