/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.ColoredVertex;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.lib.mc.registry.NamedResourceLocation;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.model.program.BakedPrograms;
import net.fexcraft.mod.fvtm.render.block.BakedModelLoader;
import net.fexcraft.mod.fvtm.render.block.ModelImpl;
import net.fexcraft.mod.fvtm.render.block.OverrideList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelImpl
implements IBakedModel {
    protected static TreeMap<String, ResourceLocation> tempres = new TreeMap();
    protected static HashMap<String, List<BakedQuad>> quads = new HashMap();
    protected final ResourceLocation modelloc;
    protected TextureAtlasSprite deftex;
    protected VertexFormat format;
    protected BlockModel model;
    protected ModelImpl root;
    protected Float normal;
    private static BakedPrograms.ColorSetter colorprog = null;

    public BakedModelImpl(ResourceLocation modellocation, ModelImpl state, VertexFormat vformat, BlockModel blockmodel) {
        this.modelloc = modellocation;
        this.format = vformat;
        this.root = state;
        this.model = blockmodel;
        this.deftex = this.root.tex_sprites.get(this.root.textures.get(0));
        if (this.root.block.getModelData().has("StaticNormal")) {
            this.normal = Float.valueOf(this.root.block.getModelData().get("StaticNormal").float_value());
        }
    }

    public static void clear() {
        tempres.clear();
        quads.clear();
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> newquads;
        String statekey;
        block8: {
            statekey = BakedModelImpl.getStateKey(state);
            if (quads.containsKey(statekey)) {
                return quads.get(statekey);
            }
            newquads = new ArrayList<BakedQuad>();
            try {
                if (this.model.rootrender) {
                    this.getQuads(this.model, newquads, state, side, rand);
                }
                if (this.model.state_models.size() <= 0) break block8;
                for (IProperty prop : state.func_177230_c().func_176194_O().func_177623_d()) {
                    String str = prop.func_177701_a() + "=" + state.func_177229_b(prop);
                    if (!this.model.state_models.containsKey(str)) continue;
                    ArrayList<BlockModel> list = this.model.state_models.get(str);
                    for (BlockModel statemodel : list) {
                        this.getQuads(statemodel, newquads, state, side, rand);
                    }
                }
            }
            catch (Throwable thr) {
                FvtmLogger.log((Object)("BAKING ERROR: " + this.model.toString() + " (" + this.model.name + ") / " + statekey));
                for (NamedResourceLocation o : this.root.tex_sprites.keySet()) {
                    FvtmLogger.log((Object)("tex: " + o));
                }
                FvtmLogger.log((Object)thr.getMessage());
                for (StackTraceElement str : thr.getStackTrace()) {
                    FvtmLogger.log((Object)("    " + str.toString()));
                }
            }
        }
        quads.put(statekey, newquads);
        BakedModelLoader.reset(this.model, state, side, rand);
        return newquads;
    }

    private void getQuads(BlockModel model, List<BakedQuad> newquads, IBlockState state, EnumFacing side, long rand) {
        ArrayList<ModelGroup> groups = BakedModelLoader.getPolygons(model, state, side, rand);
        BakedModelLoader.convertTransforms(model, this.root.block, state);
        TextureAtlasSprite sprite = null;
        for (ModelGroup group : groups) {
            colorprog = (BakedPrograms.ColorSetter)group.getProgram("fvtm:set_color");
            if (model.grouptexname) {
                sprite = this.getTex(this.root, group.name);
            }
            if (model.tg != null) {
                if (model.tg.containsKey(group.name)) {
                    sprite = this.getTex(this.root, model.tg.get(group.name));
                }
                if (state != null) {
                    String str = null;
                    for (IProperty prop : state.func_177230_c().func_176194_O().func_177623_d()) {
                        TextureAtlasSprite nsprite;
                        str = prop.func_177701_a() + "=" + state.func_177229_b(prop) + "," + group.name;
                        if (!model.tg.containsKey(str) || (nsprite = this.getTex(this.root, model.tg.get(str))) == null) continue;
                        sprite = nsprite;
                        break;
                    }
                }
            }
            if (sprite == null) {
                sprite = this.deftex;
            }
            for (Polyhedron poly : group) {
                model.bk.rot_poly.setAngles(-poly.rotY, -poly.rotZ, -poly.rotX);
                for (Polygon poli : poly.polygons) {
                    boolean tri = poli.vertices.length == 3;
                    Vec3f vec0 = new Vec3f(poli.vertices[1].vector.sub(poli.vertices[0].vector));
                    Vec3f vec1 = new Vec3f(poli.vertices[1].vector.sub(poli.vertices[2].vector));
                    Vec3f vec2 = vec1.cross(vec0).normalize();
                    vec2 = model.bk.rot_poly.getRelativeVector(vec2);
                    if (model.defrot) {
                        vec2 = model.bk.rot_meta.getRelativeVector(vec2);
                    }
                    if (model.bk.rot_tf != null) {
                        for (AxisRotator rot : model.bk.rot_tf) {
                            vec2 = rot.getRelativeVector(vec2);
                        }
                    }
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
                    builder.setContractUVs(true);
                    builder.setQuadOrientation(EnumFacing.func_176737_a((float)vec2.x, (float)vec2.y, (float)vec2.z));
                    builder.setTexture(sprite);
                    this.putVertexData(model, builder, (Polyhedron<GLObject>)poly, poli.vertices[0], vec2, sprite, colorprog);
                    this.putVertexData(model, builder, (Polyhedron<GLObject>)poly, poli.vertices[1], vec2, sprite, colorprog);
                    this.putVertexData(model, builder, (Polyhedron<GLObject>)poly, poli.vertices[2], vec2, sprite, colorprog);
                    if (tri) {
                        this.putVertexData(model, builder, (Polyhedron<GLObject>)poly, poli.vertices[2], vec2, sprite, colorprog);
                    } else {
                        this.putVertexData(model, builder, (Polyhedron<GLObject>)poly, poli.vertices[3], vec2, sprite, colorprog);
                    }
                    newquads.add((BakedQuad)builder.build());
                }
            }
        }
    }

    public static final String getStateKey(IBlockState state) {
        String key = state.func_177230_c().getRegistryName().toString();
        if (state.func_177227_a().size() > 0) {
            key = key + ",";
        }
        Iterator it = state.func_177227_a().iterator();
        while (it.hasNext()) {
            IProperty prop = (IProperty)it.next();
            key = key + prop.func_177701_a() + "=" + state.func_177229_b(prop);
            if (!it.hasNext()) continue;
            key = key + ",";
        }
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            if (key.length() > 0 && ext.getUnlistedNames().size() > 0) {
                key = key + ",";
            }
            Iterator ite = ext.getUnlistedNames().iterator();
            while (ite.hasNext()) {
                IUnlistedProperty prop = (IUnlistedProperty)ite.next();
                key = key + prop.getName() + "=" + ext.getValue(prop);
                if (!ite.hasNext()) continue;
                key = key + ",";
            }
        }
        return key;
    }

    private TextureAtlasSprite getTex(ModelImpl root, String name) {
        for (NamedResourceLocation resloc : root.textures) {
            if (!resloc.getName().equals(name)) continue;
            return root.tex_sprites.get(resloc);
        }
        if (!tempres.containsKey(name)) {
            tempres.put(name, new ResourceLocation(name));
        }
        return root.tex_sprites.get(tempres.get(name));
    }

    private void putVertexData(BlockModel model, UnpackedBakedQuad.Builder builder, Polyhedron<GLObject> poly, Vertex vert, Vec3f norm, TextureAtlasSprite texture, BakedPrograms.ColorSetter colorprog) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    Vec3f vec = model.bk.rot_poly.getRelativeVector(vert.vector).add(poly.posX, poly.posY, poly.posZ);
                    if (model.defrot) {
                        vec = model.bk.rot_meta.getRelativeVector(vec);
                    }
                    if (model.bk.rot_tf != null) {
                        for (AxisRotator rot : model.bk.rot_tf) {
                            vec = rot.getRelativeVector(vec);
                        }
                    }
                    builder.put(e, new float[]{vec.x * model.bk.scale.x + model.bk.translate.x + 0.5f, vec.y * model.bk.scale.y + model.bk.translate.y, vec.z * model.bk.scale.z + model.bk.translate.z + 0.5f, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    boolean set = false;
                    if (vert instanceof ColoredVertex) {
                        Vec3f color = vert.color();
                        if (color.x != 1.0f || color.y != 1.0f || color.z != 1.0f) {
                            builder.put(e, new float[]{color.x, color.y, color.z, 1.0f});
                            set = true;
                        }
                    }
                    if (!set && colorprog != null) {
                        float[] arr = colorprog.color;
                        builder.put(e, new float[]{arr[0], arr[1], arr[2], 1.0f});
                        set = true;
                    }
                    if (set) continue block6;
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (!((GLObject)poly.glObj).textured) {
                        builder.put(e, new float[]{texture.func_94214_a(0.0), texture.func_94207_b(0.0), 0.0f, 1.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{texture.func_94214_a((double)(vert.u * 16.0f)), texture.func_94207_b((double)(vert.v * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (this.normal != null) {
                        builder.put(e, new float[]{this.normal.floatValue(), this.normal.floatValue(), this.normal.floatValue(), 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{norm.x, norm.y, norm.z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType perspective) {
        return Pair.of((Object)this, null);
    }

    public boolean func_188618_c() {
        return true;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.root.particle == null ? this.deftex : this.root.particle;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return OverrideList.INSTANCE;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177555_b() {
        return this.root.ambocl;
    }
}

