/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.road.UniRoadTool;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class RailPlacingUtil {
    public static final ConcurrentHashMap<UUID, NewTrack> QUEUE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<UUID, UUID> CURRENT = new ConcurrentHashMap();
    public static NewTrack CL_CURRENT = null;

    public static void place(RailSystem system, EntityW pass, RailGauge gauge, QV3D vector) {
        UUID trackid = CURRENT.get(pass.getUUID());
        if (trackid == null) {
            UUID newid = RailPlacingUtil.genId();
            Junction junc = system.getJunction(vector.pos);
            if (junc != null) {
                vector = junc.getPos();
            }
            QUEUE.put(newid, new NewTrack(newid, vector, gauge));
            CURRENT.put(pass.getUUID(), newid);
            TagCW compound = TagCW.create();
            compound.set("subtask", "new");
            compound.set("uuid_l", newid.getMostSignificantBits());
            compound.set("uuid_m", newid.getLeastSignificantBits());
            compound.set("new", true);
            compound.set("gauge", gauge.getIDS());
            vector.write(compound, "vector");
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
            FvtmResources.INSTANCE.spawnRailMarker(system.getWorld(), vector, newid);
            return;
        }
        NewTrack track = QUEUE.get(trackid);
        if (track == null) {
            CURRENT.remove(pass.getUUID());
        }
        track.add(vector);
        TagCW compound = TagCW.create();
        compound.set("subtask", "add");
        compound.set("uuid_l", trackid.getMostSignificantBits());
        compound.set("uuid_m", trackid.getLeastSignificantBits());
        vector.write(compound, "vector");
        Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        FvtmResources.INSTANCE.spawnRailMarker(system.getWorld(), vector, trackid);
    }

    private static UUID genId() {
        UUID uuid = UUID.randomUUID();
        while (QUEUE.contains(uuid) || uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            uuid = UUID.randomUUID();
        }
        return uuid;
    }

    public static class NewTrack {
        public ArrayList<QV3D> points = new ArrayList();
        public ArrayList<ArrayList<V3D>> preview;
        public RailGauge gauge;
        public Track track;
        public int selected = -1;
        public UUID id;

        public NewTrack(UUID uuid, QV3D vector, RailGauge gauge) {
            this.points.add(vector);
            this.gauge = gauge;
            this.id = uuid;
        }

        public void add(QV3D vector) {
            this.points.add(this.selected == -1 ? this.points.size() : (this.selected = this.selected + 1), vector);
            this.preview = null;
            this.gentrack();
        }

        public void gentrack() {
            this.track = this.points.size() > 1 ? new Track(null, this.points.toArray(new QV3D[0]), this.gauge) : null;
        }

        public void select(EntityW player, QV3D vector) {
            int sel = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                sel = i;
                break;
            }
            this.selected = sel;
            TagCW compound = TagCW.create();
            compound.set("selected", this.selected);
            compound.set("subtask", "selected");
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        }

        public void remove(EntityW player, QV3D vector) {
            int rem = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                rem = i;
                break;
            }
            if (rem < 0) {
                return;
            }
            if (rem <= this.selected) {
                --this.selected;
            }
            if (this.selected < -1) {
                this.selected = -1;
            }
            this.points.remove(rem);
            this.gentrack();
            this.preview = null;
            if (this.points.size() == 0) {
                this.reset();
                return;
            }
            TagCW compound = TagCW.create();
            compound.set("remove", rem);
            compound.set("subtask", "remove");
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            vector.write(compound, "vector");
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        }

        public void reset() {
            QUEUE.remove(this.id);
            CURRENT.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(this.id));
            TagCW compound = TagCW.create();
            compound.set("subtask", "reset");
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "rail_place_util", compound);
        }

        public int indexOf(QV3D vector) {
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                return i;
            }
            return -2;
        }

        /*
         * WARNING - void declaration
         */
        public void create(EntityW player, QV3D vector) {
            void var12_19;
            boolean nn;
            RailSystem sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            Junction junc = sys.getJunction(vector.pos, true);
            UUID current = CURRENT.get(player.getUUID());
            boolean bl = nn = junc != null;
            if (current == null) {
                player.send("no_queue_entry / 0");
                return;
            }
            NewTrack ntrack = QUEUE.get(current);
            if (ntrack == null) {
                player.send("no_queue_entry / 1");
                return;
            }
            HashMap<String, List> tags = new HashMap<String, List>();
            HashMap<RailGauge.UseMat, int[]> needs = new HashMap<RailGauge.UseMat, int[]>();
            if (!player.isCreative()) {
                List stacks = player.copyInventory();
                for (RailGauge.UseMat useMat : ntrack.gauge.getMaterials()) {
                    FvtmLogger.marker(useMat.id, useMat.tag, Float.valueOf(useMat.amount));
                    if (useMat.tag) {
                        List tag = UniStack.getTagAsList((String)useMat.id);
                        if (tag.isEmpty()) continue;
                        tags.put(useMat.id, tag);
                    }
                    double v = (double)useMat.amount * ntrack.track.length;
                    int n = (int)v + (v % 1.0 > 0.0 ? 1 : 0);
                    needs.put(useMat, new int[]{n, 0, 0});
                }
                boolean missing = false;
                for (Map.Entry entry : needs.entrySet()) {
                    if (((RailGauge.UseMat)entry.getKey()).tag) {
                        List tag = (List)tags.get(((RailGauge.UseMat)entry.getKey()).id);
                        block2: for (StackWrapper stack : stacks) {
                            if (stack.empty()) continue;
                            Iterator iterator = tag.iterator();
                            while (iterator.hasNext()) {
                                StackWrapper stag = (StackWrapper)iterator.next();
                                if (!stack.getID().equals(stag.getID())) continue;
                                this.fillFound((int[])entry.getValue(), 1, stack);
                                continue block2;
                            }
                        }
                    } else {
                        for (StackWrapper stack : stacks) {
                            if (stack.empty() || !stack.getID().equals(((RailGauge.UseMat)entry.getKey()).id)) continue;
                            this.fillFound((int[])entry.getValue(), 1, stack);
                        }
                    }
                    if (((int[])entry.getValue())[0] <= ((int[])entry.getValue())[1]) continue;
                    missing = true;
                }
                if (missing) {
                    player.send("interact.fvtm.rail_marker.missing_materials");
                    for (Map.Entry entry : needs.entrySet()) {
                        StackWrapper stack;
                        if (((RailGauge.UseMat)entry.getKey()).tag) {
                            stack = (StackWrapper)((List)tags.get(((RailGauge.UseMat)entry.getKey()).id)).get(0);
                            player.send("interact.fvtm.rail_marker.material_tag_entry", new Object[]{stack.getName(), ((RailGauge.UseMat)entry.getKey()).id, ((int[])entry.getValue())[1], ((int[])entry.getValue())[0]});
                            continue;
                        }
                        stack = UniStack.createStack((Object)FvtmRegistry.getItem(((RailGauge.UseMat)entry.getKey()).id));
                        player.send("interact.fvtm.rail_marker.material_entry", new Object[]{stack.getName(), ((int[])entry.getValue())[1], ((int[])entry.getValue())[0]});
                    }
                    return;
                }
            }
            if (junc == null) {
                sys.addJunction(vector);
                junc = sys.getJunction(vector.pos, true);
                junc.updateVecPos(vector);
                if (ntrack.points.size() == 1 || ntrack.allsame()) {
                    player.send("interact.fvtm.rail_marker.junction_created");
                    this.reset();
                    return;
                }
                player.send("interact.fvtm.rail_marker.end_junction_created");
            }
            if (!junc.tracks.isEmpty() && junc.tracks.size() < 2 && !junc.tracks.get(0).isCompatibleGauge(ntrack.gauge)) {
                player.send("interact.fvtm.rail_marker.incompatible_gauge");
                return;
            }
            if (junc.hasSignals()) {
                player.send("interact.fvtm.rail_marker.remove_signal");
                return;
            }
            if (junc.tracks.size() >= 4) {
                player.send("interact.fvtm.rail_marker.junction_full");
                player.send("interact.fvtm.rail_marker.cache_reset");
                ntrack.reset();
                return;
            }
            QV3D[] arr = ntrack.points.toArray(new QV3D[0]);
            if (nn) {
                arr[arr.length - 1] = junc.getPos();
            }
            Track track = new Track(junc, arr, this.gauge);
            if (track.length > (double)Config.MAX_RAIL_TRACK_LENGTH) {
                player.send("interact.fvtm.rail_marker.too_long");
                return;
            }
            Junction junction = sys.getJunction(track.start.pos);
            if (junction == null) {
                sys.addJunction(track.start);
                Junction junction2 = sys.getJunction(track.start.pos, true);
                player.send("interact.fvtm.rail_marker.start_junction_created");
            }
            if (var12_19 != null) {
                var12_19.addnew(track);
                junc.addnew(track.createOppositeCopy());
                var12_19.checkTrackSectionConsistency();
                player.send("interact.fvtm.rail_marker.track_created");
                ntrack.reset();
                for (Map.Entry entry : needs.entrySet()) {
                    StackWrapper stack;
                    if (((RailGauge.UseMat)entry.getKey()).tag) {
                        List tag = (List)tags.get(((RailGauge.UseMat)entry.getKey()).id);
                        block7: for (int i = 0; i < player.getInventorySize(); ++i) {
                            stack = player.getStackAt(i);
                            if (stack.empty()) continue;
                            for (StackWrapper stag : tag) {
                                if (!stack.getID().equals(stag.getID())) continue;
                                this.fillFound((int[])entry.getValue(), 2, stack);
                                continue block7;
                            }
                        }
                        continue;
                    }
                    for (int i = 0; i < player.getInventorySize(); ++i) {
                        stack = player.getStackAt(i);
                        if (stack.empty() || !stack.getID().equals(((RailGauge.UseMat)entry.getKey()).id)) continue;
                        this.fillFound((int[])entry.getValue(), 2, stack);
                    }
                }
            } else {
                player.send("interact.fvtm.rail_marker.no_start_junction");
            }
        }

        private void fillFound(int[] arr, int idx, StackWrapper stack) {
            int need = arr[0] - arr[idx];
            if (need <= 0) {
                return;
            }
            if (need > stack.count()) {
                int n = idx;
                arr[n] = arr[n] + stack.count();
                stack.count(0);
            } else {
                int n = idx;
                arr[n] = arr[n] + need;
                stack.decr(need);
            }
        }

        private boolean allsame() {
            QV3D vec = this.points.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                if (vec.equals(this.points.get(i))) continue;
                return false;
            }
            return true;
        }

        public void genpreview() {
            double half = this.gauge.getWidth() * 0.5f;
            this.preview = new ArrayList();
            this.preview.add(new ArrayList());
            this.preview.add(new ArrayList());
            V3D vec = this.track.vecpath[0];
            float pass = 0.0f;
            while ((double)pass < this.track.length + 0.125) {
                V3D last = vec;
                vec = this.track.getVectorPosition0(pass == 0.0f ? (double)0.001f : (double)pass, false);
                double angle = (float)Math.atan2(last.x - vec.x, last.z - vec.z);
                this.preview.get(0).add(vec.add(UniRoadTool.grv(angle, new V3D(-half, 0.0, 0.0))));
                this.preview.get(1).add(vec.add(UniRoadTool.grv(angle, new V3D(half, 0.0, 0.0))));
                pass += 0.125f;
            }
        }
    }
}

